# KR Core Condition Profile for Chief Complaint - KR Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **KR Core Condition Profile for Chief Complaint**

## Resource Profile: KR Core Condition Profile for Chief Complaint 

| | |
| :--- | :--- |
| *Official URL*:http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-condition-chief-complaint | *Version*:2.0.0 |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | *Computable Name*:KRCore_Condition_ChiefComplaint |

 
KR Core Condition Profile for Chief Complaint는 KR Core Server와 KR Core Client가 진료정보를 교류할 때 주호소 정보를 표현하는 데 사용되며, 이 경우**가능한 한(SHOULD)**본 Profile을 준수해야 한다. 주호소 정보를 표현할 때 본 Profile을 적용하지 않을 수 있는 경우는 특수한 상황에 한정된다. 이 경우 반드시 해당 진료정보교류 도메인 내에서 사전 합의가 이루어져야 한다. 

 
**KR CDI V2 진단 및 주호소 정보**클래스에서 정의한 주호소 정보 관련 항목들과 주요 추가 정보를 구조화하기 위해 정의한 Profile. 

**Usages:**

* CapabilityStatements using this Profile: [KR Core Client CapabilityStatement](CapabilityStatement-krcore-capabilitystatement-client.md) and [KR Core Server CapabilityStatement](CapabilityStatement-krcore-capabilitystatement-server.md)
* This Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.kr.core|current/StructureDefinition/krcore-condition-chief-complaint)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-krcore-condition-chief-complaint.csv), [Excel](StructureDefinition-krcore-condition-chief-complaint.xlsx), [Schematron](StructureDefinition-krcore-condition-chief-complaint.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "krcore-condition-chief-complaint",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://www.hl7korea.or.kr/fhir/krcore/ImplementationGuide/hl7.fhir.kr.core"
          }
        ]
      }
    }
  ],
  "url" : "http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-condition-chief-complaint",
  "version" : "2.0.0",
  "name" : "KRCore_Condition_ChiefComplaint",
  "title" : "KR Core Condition Profile for Chief Complaint",
  "status" : "active",
  "date" : "2025-08-29T13:39:02+09:00",
  "publisher" : "HL7 Korea",
  "description" : "KR Core Condition Profile for Chief Complaint는 KR Core Server와 KR Core Client가 진료정보를 교류할 때 주호소 정보를 표현하는 데 사용되며, 이 경우 **가능한 한(SHOULD)** 본 Profile을 준수해야 한다.\n주호소 정보를 표현할 때 본 Profile을 적용하지 않을 수 있는 경우는 특수한 상황에 한정된다. 이 경우 반드시 해당 진료정보교류 도메인 내에서 사전 합의가 이루어져야 한다.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "KR",
          "display" : "Korea, Republic of"
        }
      ]
    }
  ],
  "purpose" : "**KR CDI V2 진단 및 주호소 정보** 클래스에서 정의한 주호소 정보 관련 항목들과 주요 추가 정보를 구조화하기 위해 정의한 Profile.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "sct-concept",
      "uri" : "http://snomed.info/conceptdomain",
      "name" : "SNOMED CT Concept Domain Binding"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "sct-attr",
      "uri" : "http://snomed.org/attributebinding",
      "name" : "SNOMED CT Attribute Binding"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Condition",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Condition",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Condition",
        "path" : "Condition",
        "short" : "KR Core Condition Profile for Chief Complaint"
      },
      {
        "id" : "Condition.clinicalStatus",
        "path" : "Condition.clinicalStatus",
        "short" : "주호소 임상적 상태: active | recurrence | relapse | inactive | remission | resolved",
        "alias" : ["KRCDI: 주호소 임상적 상태"]
      },
      {
        "id" : "Condition.category",
        "path" : "Condition.category",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "$this"
            }
          ],
          "rules" : "open"
        },
        "short" : "주호소 범주",
        "min" : 1
      },
      {
        "id" : "Condition.category:CC",
        "path" : "Condition.category",
        "sliceName" : "CC",
        "min" : 1,
        "max" : "1",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://www.hl7korea.or.kr/fhir/krcore/CodeSystem/krcore-condition-category-types",
              "code" : "주호소"
            }
          ]
        },
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://www.hl7korea.or.kr/fhir/krcore/ValueSet/krcore-condition-category-codes"
        }
      },
      {
        "id" : "Condition.code",
        "path" : "Condition.code",
        "short" : "주호소명",
        "alias" : ["KRCDI: 주호소명"],
        "min" : 1,
        "binding" : {
          "strength" : "example",
          "valueSet" : "http://hl7.org/fhir/ValueSet/condition-code|4.0.1"
        }
      },
      {
        "id" : "Condition.code.coding.system",
        "path" : "Condition.code.coding.system",
        "min" : 1
      },
      {
        "id" : "Condition.code.coding.code",
        "path" : "Condition.code.coding.code",
        "min" : 1
      },
      {
        "id" : "Condition.subject",
        "path" : "Condition.subject",
        "short" : "주호소 대상 환자",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-patient"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Condition.encounter",
        "path" : "Condition.encounter",
        "short" : "주호소 관련 진료 정보",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-encounter"
            ]
          }
        ]
      },
      {
        "id" : "Condition.onset[x]",
        "path" : "Condition.onset[x]",
        "short" : "주호소 발생 일시 또는 연령",
        "alias" : ["KRCDI: 주호소 발생 일자"]
      }
    ]
  }
}

```
