# krcore-sp-organization-name - KR Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **krcore-sp-organization-name**

## SearchParameter: krcore-sp-organization-name 

| | |
| :--- | :--- |
| *Official URL*:http://www.hl7korea.or.kr/fhir/krcore/SearchParameter/krcore-sp-organization-name | *Version*:2.0.0 |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | *Computable Name*:KRCoreSearchParameterOrganizationName |

 
기관 명칭 



## Resource Content

```json
{
  "resourceType" : "SearchParameter",
  "id" : "krcore-sp-organization-name",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
      "valueCode" : "SHOULD"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/note",
      "valueAnnotation" : {
        "text" : "KR Core Client는 **반드시(SHALL)** 한글 문자열 검색을 지원해야 한다. KR Core Server는 **반드시(SHALL)** 한글 문자열 검색을 지원해야 한다."
      }
    }
  ],
  "url" : "http://www.hl7korea.or.kr/fhir/krcore/SearchParameter/krcore-sp-organization-name",
  "version" : "2.0.0",
  "name" : "KRCoreSearchParameterOrganizationName",
  "derivedFrom" : "http://hl7.org/fhir/SearchParameter/Organization-name",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-08-29T13:39:02+09:00",
  "publisher" : "HL7 Korea",
  "description" : "기관 명칭",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "KR",
          "display" : "Korea, Republic of"
        }
      ]
    }
  ],
  "code" : "name",
  "base" : ["Organization"],
  "type" : "string",
  "expression" : "Organization.name | Organization.alias",
  "multipleOr" : true,
  "_multipleOr" : {
    "extension" : [
      {
        "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
        "valueCode" : "MAY"
      }
    ]
  },
  "multipleAnd" : true,
  "_multipleAnd" : {
    "extension" : [
      {
        "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
        "valueCode" : "MAY"
      }
    ]
  }
}

```
