# ns-hira-edi-procedure - KR Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ns-hira-edi-procedure**

## NamingSystem: ns-hira-edi-procedure 

| | |
| :--- | :--- |
| *Official URL*:http://www.hl7korea.or.kr/fhir/krcore/NamingSystem/ns-hira-edi-procedure | *Version*:1.0.2 |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | *Computable Name*:HIRA_EDI_Procedure |

 
건강보험심사평가원 EDI 진료행위 코드 명명체계 



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "ns-hira-edi-procedure",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-NamingSystem.url",
      "valueUri" : "http://www.hl7korea.or.kr/fhir/krcore/NamingSystem/ns-hira-edi-procedure"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-NamingSystem.version",
      "valueString" : "1.0.2"
    }
  ],
  "name" : "HIRA_EDI_Procedure",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2023-06-30",
  "publisher" : "HL7 Korea",
  "description" : "건강보험심사평가원 EDI 진료행위 코드 명명체계",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "KR",
          "display" : "Korea, Republic of"
        }
      ]
    }
  ],
  "uniqueId" : [
    {
      "type" : "uri",
      "value" : "http://www.hl7korea.or.kr/CodeSystem/hira-edi-procedure",
      "preferred" : true,
      "comment" : "건강보험심사평가원 EDI 진료행위 코드체계를 식별하기 위해 HL7 Korea에서 부여한 식별자"
    }
  ]
}

```
