# KR Core Vaccination Types - KR Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **KR Core Vaccination Types**

## CodeSystem: KR Core Vaccination Types 

| | |
| :--- | :--- |
| *Official URL*:http://www.hl7korea.or.kr/fhir/krcore/CodeSystem/krcore-vcnt-types | *Version*:1.0.2 |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | *Computable Name*:KR_Core_Vaccination_Types |

 
KR Core 예방접종 유형 코드체계 

 
질병관리청 예방접종 유형을 HL7 FHIR 및 KR Core에서 활용하기 쉽도록 코드를 부여 

 This Code system is referenced in the content logical definition of the following value sets: 

* [KR_Core_Vaccination_Type_Codes](ValueSet-krcore-vcnt-type-codes.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "krcore-vcnt-types",
  "url" : "http://www.hl7korea.or.kr/fhir/krcore/CodeSystem/krcore-vcnt-types",
  "version" : "1.0.2",
  "name" : "KR_Core_Vaccination_Types",
  "title" : "KR Core Vaccination Types",
  "status" : "active",
  "experimental" : false,
  "date" : "2023-06-30",
  "publisher" : "HL7 Korea",
  "description" : "KR Core 예방접종 유형 코드체계",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "KR",
          "display" : "Korea, Republic of"
        }
      ]
    }
  ],
  "purpose" : "질병관리청 예방접종 유형을 HL7 FHIR 및 KR Core에서 활용하기 쉽도록 코드를 부여",
  "caseSensitive" : false,
  "content" : "complete",
  "count" : 46,
  "property" : [
    {
      "code" : "class",
      "description" : "필수예방접종 | 국가예방접종 | 기타예방접종",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "00",
      "display" : "디프테리아",
      "property" : [
        {
          "code" : "class",
          "valueCode" : "필수예방접종"
        }
      ]
    },
    {
      "code" : "01",
      "display" : "폴리오",
      "property" : [
        {
          "code" : "class",
          "valueCode" : "필수예방접종"
        }
      ]
    },
    {
      "code" : "02",
      "display" : "백일해",
      "property" : [
        {
          "code" : "class",
          "valueCode" : "필수예방접종"
        }
      ]
    },
    {
      "code" : "03",
      "display" : "홍역",
      "property" : [
        {
          "code" : "class",
          "valueCode" : "필수예방접종"
        }
      ]
    },
    {
      "code" : "04",
      "display" : "파상풍",
      "property" : [
        {
          "code" : "class",
          "valueCode" : "필수예방접종"
        }
      ]
    },
    {
      "code" : "05",
      "display" : "결핵",
      "property" : [
        {
          "code" : "class",
          "valueCode" : "필수예방접종"
        }
      ]
    },
    {
      "code" : "06",
      "display" : "B형간염",
      "property" : [
        {
          "code" : "class",
          "valueCode" : "필수예방접종"
        }
      ]
    },
    {
      "code" : "07",
      "display" : "유행성이하선염",
      "property" : [
        {
          "code" : "class",
          "valueCode" : "필수예방접종"
        }
      ]
    },
    {
      "code" : "08",
      "display" : "풍진",
      "property" : [
        {
          "code" : "class",
          "valueCode" : "필수예방접종"
        }
      ]
    },
    {
      "code" : "09",
      "display" : "수두",
      "property" : [
        {
          "code" : "class",
          "valueCode" : "필수예방접종"
        }
      ]
    },
    {
      "code" : "10",
      "display" : "일본뇌염",
      "property" : [
        {
          "code" : "class",
          "valueCode" : "필수예방접종"
        }
      ]
    },
    {
      "code" : "11",
      "display" : "b형 헤모필루스 인플루엔자",
      "property" : [
        {
          "code" : "class",
          "valueCode" : "필수예방접종"
        }
      ]
    },
    {
      "code" : "12",
      "display" : "폐렴구균",
      "property" : [
        {
          "code" : "class",
          "valueCode" : "필수예방접종"
        }
      ]
    },
    {
      "code" : "13",
      "display" : "인플루엔자",
      "property" : [
        {
          "code" : "class",
          "valueCode" : "필수예방접종"
        }
      ]
    },
    {
      "code" : "14",
      "display" : "A형간염",
      "property" : [
        {
          "code" : "class",
          "valueCode" : "필수예방접종"
        }
      ]
    },
    {
      "code" : "15",
      "display" : "사람유두종바이러스",
      "property" : [
        {
          "code" : "class",
          "valueCode" : "필수예방접종"
        }
      ]
    },
    {
      "code" : "16",
      "display" : "장티푸스",
      "property" : [
        {
          "code" : "class",
          "valueCode" : "필수예방접종"
        }
      ]
    },
    {
      "code" : "17",
      "display" : "신증후군출혈",
      "property" : [
        {
          "code" : "class",
          "valueCode" : "필수예방접종"
        }
      ]
    },
    {
      "code" : "18",
      "display" : "B형간염(HepB)",
      "property" : [
        {
          "code" : "class",
          "valueCode" : "국가예방접종"
        }
      ]
    },
    {
      "code" : "19",
      "display" : "결핵(BCG, 피내접종)",
      "property" : [
        {
          "code" : "class",
          "valueCode" : "국가예방접종"
        }
      ]
    },
    {
      "code" : "20",
      "display" : "디프테리아/파상풍/백일해 (DTaP)",
      "property" : [
        {
          "code" : "class",
          "valueCode" : "국가예방접종"
        }
      ]
    },
    {
      "code" : "21",
      "display" : "디프테리아/파상풍/백일해/폴리오 (DTaP-IPV)",
      "property" : [
        {
          "code" : "class",
          "valueCode" : "국가예방접종"
        }
      ]
    },
    {
      "code" : "22",
      "display" : "디프테리아/파상풍/백일해/폴리오/b형 헤모필루스 인플루엔자(DTaP-IPV/Hib)",
      "property" : [
        {
          "code" : "class",
          "valueCode" : "국가예방접종"
        }
      ]
    },
    {
      "code" : "23",
      "display" : "파상풍/디프테리아(Td)",
      "property" : [
        {
          "code" : "class",
          "valueCode" : "국가예방접종"
        }
      ]
    },
    {
      "code" : "24",
      "display" : "파상풍/디프테리아/백일해 (Tdap)",
      "property" : [
        {
          "code" : "class",
          "valueCode" : "국가예방접종"
        }
      ]
    },
    {
      "code" : "25",
      "display" : "폴리오 (IPV)",
      "property" : [
        {
          "code" : "class",
          "valueCode" : "국가예방접종"
        }
      ]
    },
    {
      "code" : "26",
      "display" : "b형 헤모필루스 인플루엔자 (Hib)",
      "property" : [
        {
          "code" : "class",
          "valueCode" : "국가예방접종"
        }
      ]
    },
    {
      "code" : "27",
      "display" : "폐렴구균(PCV, PPSV)",
      "property" : [
        {
          "code" : "class",
          "valueCode" : "국가예방접종"
        }
      ]
    },
    {
      "code" : "28",
      "display" : "로타바이러스(RV) 감염증",
      "property" : [
        {
          "code" : "class",
          "valueCode" : "국가예방접종"
        }
      ]
    },
    {
      "code" : "29",
      "display" : "홍역/유행성이하선염/풍진 (MMR)",
      "property" : [
        {
          "code" : "class",
          "valueCode" : "국가예방접종"
        }
      ]
    },
    {
      "code" : "30",
      "display" : "수두 (VAR)",
      "property" : [
        {
          "code" : "class",
          "valueCode" : "국가예방접종"
        }
      ]
    },
    {
      "code" : "31",
      "display" : "A형간염(HepA, 소아용)",
      "property" : [
        {
          "code" : "class",
          "valueCode" : "국가예방접종"
        }
      ]
    },
    {
      "code" : "32",
      "display" : "일본뇌염 (IJEV, 불활성화 백신)",
      "property" : [
        {
          "code" : "class",
          "valueCode" : "국가예방접종"
        }
      ]
    },
    {
      "code" : "33",
      "display" : "일본뇌염 (LJEV, 약독화 생백신)",
      "property" : [
        {
          "code" : "class",
          "valueCode" : "국가예방접종"
        }
      ]
    },
    {
      "code" : "34",
      "display" : "사람유두종바이러스 감염증(HPV2, HP4)",
      "property" : [
        {
          "code" : "class",
          "valueCode" : "국가예방접종"
        }
      ]
    },
    {
      "code" : "35",
      "display" : "인플루엔자 (IIV)",
      "property" : [
        {
          "code" : "class",
          "valueCode" : "국가예방접종"
        }
      ]
    },
    {
      "code" : "36",
      "display" : "장티푸스 (ViCPS, 고위험군 대상, 주사용)",
      "property" : [
        {
          "code" : "class",
          "valueCode" : "국가예방접종"
        }
      ]
    },
    {
      "code" : "37",
      "display" : "신증후군출혈열 (HFRS, 고위험군 대상)",
      "property" : [
        {
          "code" : "class",
          "valueCode" : "국가예방접종"
        }
      ]
    },
    {
      "code" : "38",
      "display" : "결핵 (BCG, 경피접종)",
      "property" : [
        {
          "code" : "class",
          "valueCode" : "기타예방접종"
        }
      ]
    },
    {
      "code" : "39",
      "display" : "일본뇌염(LJEV, 키메라 바이러스 생백신)",
      "property" : [
        {
          "code" : "class",
          "valueCode" : "기타예방접종"
        }
      ]
    },
    {
      "code" : "40",
      "display" : "사람유두종바이러스 감염증(HPV9)",
      "property" : [
        {
          "code" : "class",
          "valueCode" : "기타예방접종"
        }
      ]
    },
    {
      "code" : "41",
      "display" : "디프테리아/파상풍/백일해/폴리오/B형간염/b형 헤모필루스 인플루엔자(DTaP-IPV-HepB-Hib)",
      "property" : [
        {
          "code" : "class",
          "valueCode" : "기타예방접종"
        }
      ]
    },
    {
      "code" : "42",
      "display" : "수막구균(MCV4)",
      "property" : [
        {
          "code" : "class",
          "valueCode" : "기타예방접종"
        }
      ]
    },
    {
      "code" : "43",
      "display" : "대상포진(HZV)",
      "property" : [
        {
          "code" : "class",
          "valueCode" : "기타예방접종"
        }
      ]
    },
    {
      "code" : "44",
      "display" : "A형간염(HepA, 성인용)",
      "property" : [
        {
          "code" : "class",
          "valueCode" : "기타예방접종"
        }
      ]
    },
    {
      "code" : "45",
      "display" : "장티푸스 (Ty21a, 경구용)",
      "property" : [
        {
          "code" : "class",
          "valueCode" : "기타예방접종"
        }
      ]
    }
  ]
}

```
