# KR Core Procedure Category Types - KR Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **KR Core Procedure Category Types**

## CodeSystem: KR Core Procedure Category Types 

| | |
| :--- | :--- |
| *Official URL*:http://www.hl7korea.or.kr/fhir/krcore/CodeSystem/krcore-procedure-category-types | *Version*:2.0.0 |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | *Computable Name*:KR_Core_Procedure_Category_Types |

 
KR Core 수술 및 처치 범주 코드체계 

 
KR Core Procedure Profile의 범주 구분을 위해 정의 

 This Code system is referenced in the content logical definition of the following value sets: 

* [KR_Core_Procedure_Category_Codes](ValueSet-krcore-procedure-category-codes.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "krcore-procedure-category-types",
  "url" : "http://www.hl7korea.or.kr/fhir/krcore/CodeSystem/krcore-procedure-category-types",
  "version" : "2.0.0",
  "name" : "KR_Core_Procedure_Category_Types",
  "title" : "KR Core Procedure Category Types",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-08-29T13:39:02+09:00",
  "publisher" : "HL7 Korea",
  "description" : "KR Core 수술 및 처치 범주 코드체계",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "KR",
          "display" : "Korea, Republic of"
        }
      ]
    }
  ],
  "purpose" : "KR Core Procedure Profile의 범주 구분을 위해 정의",
  "caseSensitive" : false,
  "content" : "complete",
  "count" : 3,
  "concept" : [
    {
      "code" : "1",
      "display" : "수술"
    },
    {
      "code" : "2",
      "display" : "처치"
    },
    {
      "code" : "3",
      "display" : "마취"
    }
  ]
}

```
