# HIRA Healthcare Organization Types - KR Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **HIRA Healthcare Organization Types**

## CodeSystem: HIRA Healthcare Organization Types 

| | |
| :--- | :--- |
| *Official URL*:http://www.hl7korea.or.kr/CodeSystem/hira-healthcare-organization-types | *Version*:1.0.2 |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | *Computable Name*:HIRA_Healthcare_Organization_Types |

 
건강보험심사평가원 요양종별 코드체계 

 This Code system is referenced in the content logical definition of the following value sets: 

* [KR_Core_Organization_Type_Codes](ValueSet-krcore-healthcare-organization-type-codes.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "hira-healthcare-organization-types",
  "url" : "http://www.hl7korea.or.kr/CodeSystem/hira-healthcare-organization-types",
  "version" : "1.0.2",
  "name" : "HIRA_Healthcare_Organization_Types",
  "title" : "HIRA Healthcare Organization Types",
  "status" : "active",
  "experimental" : false,
  "date" : "2023-06-30",
  "publisher" : "HL7 Korea",
  "description" : "건강보험심사평가원 요양종별 코드체계",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "KR",
          "display" : "Korea, Republic of"
        }
      ]
    }
  ],
  "caseSensitive" : false,
  "content" : "complete",
  "count" : 19,
  "concept" : [
    {
      "code" : "01",
      "display" : "상급종합병원"
    },
    {
      "code" : "11",
      "display" : "종합병원"
    },
    {
      "code" : "21",
      "display" : "병원"
    },
    {
      "code" : "28",
      "display" : "요양병원"
    },
    {
      "code" : "29",
      "display" : "정신병원"
    },
    {
      "code" : "31",
      "display" : "의원"
    },
    {
      "code" : "41",
      "display" : "치과병원"
    },
    {
      "code" : "51",
      "display" : "치과의원"
    },
    {
      "code" : "61",
      "display" : "조산원"
    },
    {
      "code" : "71",
      "display" : "보건소"
    },
    {
      "code" : "72",
      "display" : "보건지소"
    },
    {
      "code" : "73",
      "display" : "보건진료소"
    },
    {
      "code" : "74",
      "display" : "모자보건센타"
    },
    {
      "code" : "75",
      "display" : "보건의료원"
    },
    {
      "code" : "81",
      "display" : "약국"
    },
    {
      "code" : "91",
      "display" : "한방종합병원"
    },
    {
      "code" : "92",
      "display" : "한방병원"
    },
    {
      "code" : "93",
      "display" : "한의원"
    },
    {
      "code" : "94",
      "display" : "한약방"
    }
  ]
}

```
