# Search Parameters - KR Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* **Search Parameters**

## Search Parameters

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

**NOTE**: 아래의 Search Parameter 목록은 클라이언트 또는 서버에 대한 검색 요구사항 목록이 아님. CapabilityStatement는 KR Core Server에 대한 검색 기능 기대치를 정의함. 본 문단에서는 CapabilityStatement 내에서 사용되는 Search Parameter들에 대한 정의가 나열되어 있음.

### KR Core Implementation Guide에서 정의한(defined) Search Parameter 목록

#### DiagnosticReport

| | | | | |
| :--- | :--- | :--- | :--- | :--- |
| [request-date](SearchParameter-krcore-sp-diagnosticreport-request-date.md) | [datetime](http://hl7.org/fhir/r4/search.html#datetime) | 진단을 위한 검사 의뢰일 | DiagnosticReport.extension('http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-testRequestDateTime').value.ofType(dateTime) | MAY |
| [study](SearchParameter-krcore-sp-diagnosticreport-study.md) | [reference](http://hl7.org/fhir/r4/search.html#reference) | 진단보고를 위한 진단영상 | DiagnosticReport.imagingStudy | MAY |

#### Encounter

| | | | | |
| :--- | :--- | :--- | :--- | :--- |
| [insurance-type](SearchParameter-krcore-sp-encounter-insurance-type.md) | [token](http://hl7.org/fhir/r4/search.html#token) | 환자의 건강보험유형 | Encounter.extension('http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-insuranceTypes').value.ofType(CodeableConcept) | MAY |

#### Immunization

| | | | | |
| :--- | :--- | :--- | :--- | :--- |
| [dose-number](SearchParameter-krcore-sp-immunization-dose-number.md) | [positiveint](http://hl7.org/fhir/r4/search.html#positiveint) | 예방 접종 차수 | Immunization.protocolApplied.doseNumber.ofType(positiveInt) | MAY |

#### MedicationRequest

| | | | | |
| :--- | :--- | :--- | :--- | :--- |
| [ingredient-code](SearchParameter-krcore-sp-medicationrequest-ingredient-code.md) | [token](http://hl7.org/fhir/r4/search.html#token) | 약품성분명 | MedicationRequest.medication.ofType(CodeableConcept).extension('http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-medicationIngredient').value.ofType(CodeableConcept) | SHOULD |

#### Observation

| | | | | |
| :--- | :--- | :--- | :--- | :--- |
| [issued](SearchParameter-krcore-sp-observation-issued.md) | [datetime](http://hl7.org/fhir/r4/search.html#datetime) | 관찰 및 측정 보고 일시 | Observation.issued | SHOULD |

#### Organization

| | | | | |
| :--- | :--- | :--- | :--- | :--- |
| [telecom](SearchParameter-krcore-sp-organization-telecom.md) | [token](http://hl7.org/fhir/r4/search.html#token) | 기관 연락처 | Organization.telecom | MAY |

#### Practitioner

| | | | | |
| :--- | :--- | :--- | :--- | :--- |
| [code](SearchParameter-krcore-sp-practitioner-code.md) | [token](http://hl7.org/fhir/r4/search.html#token) | 의료인 면허 및 자격증 유형 | Practitioner.qualification.code | MAY |

### 기본 FHIR Specification에서 파생된(derived) Search Parameter 목록

본 절의 KR Core Search Parameter 목록은 기본 FHIR 사양에서 파생되었으며, 아래 요소에 대한 구현 기대치를 정의함:

* [multipleAnd](http://hl7.org/fhir/R4/searchparameter-definitions.html#SearchParameter.multipleAnd)
* [multipleOr](http://hl7.org/fhir/R4/searchparameter-definitions.html#SearchParameter.multipleOr)
* [comparator](http://hl7.org/fhir/R4/searchparameter-definitions.html#SearchParameter.comparator)
* [modifier](http://hl7.org/fhir/R4/searchparameter-definitions.html#SearchParameter.modifier)
* [chain](http://hl7.org/fhir/R4/searchparameter-definitions.html#SearchParameter.chain)

#### AllergyIntolerance

| | | | | |
| :--- | :--- | :--- | :--- | :--- |
| [category](SearchParameter-krcore-sp-allergyintolerance-category.md) | [token](http://hl7.org/fhir/r4/search.html#token) | 알레르기 및 불내성 원인구분 | AllergyIntolerance.category | MAY |
| [clinical-status](SearchParameter-krcore-sp-allergyintolerance-clinical-status.md) | [token](http://hl7.org/fhir/r4/search.html#token) | 알레르기 및 불내성 상태: active | inactive | resolved | AllergyIntolerance.clinicalStatus | MAY |
| [code](SearchParameter-krcore-sp-allergyintolerance-code.md) | [token](http://hl7.org/fhir/r4/search.html#token) | 원인물질 등 알레르기 및 불내성 반응 코드 | AllergyIntolerance.code | AllergyIntolerance.reaction.substance | SHOULD |
| [manifestation](SearchParameter-krcore-sp-allergyintolerance-manifestation.md) | [token](http://hl7.org/fhir/r4/search.html#token) | 알레르기 및 불내성 증상 | AllergyIntolerance.reaction.manifestation | MAY |
| [onset](SearchParameter-krcore-sp-allergyintolerance-onset.md) | [datetime](http://hl7.org/fhir/r4/search.html#datetime) | 알레르기 및 불내성 발생일 또는 개별 증상 발생일 | AllergyIntolerance.onset.ofType(dateTime) | AllergyIntolerance.reaction.onset | MAY |
| [patient](SearchParameter-krcore-sp-allergyintolerance-patient.md) | [reference](http://hl7.org/fhir/r4/search.html#reference) | 알레르기 및 불내성 정보의 대상 환자 | AllergyIntolerance.patient | SHALL |

#### Condition

| | | | | |
| :--- | :--- | :--- | :--- | :--- |
| [category](SearchParameter-krcore-sp-condition-category.md) | [token](http://hl7.org/fhir/r4/search.html#token) | 진단 및 주호소 범주 | Condition.category | MAY |
| [clinical-status](SearchParameter-krcore-sp-condition-clinical-status.md) | [token](http://hl7.org/fhir/r4/search.html#token) | 진단 및 주호소 임상적 상태: active | recurrence | relapse | inactive | remission | resolved | Condition.clinicalStatus | MAY |
| [code](SearchParameter-krcore-sp-condition-code.md) | [token](http://hl7.org/fhir/r4/search.html#token) | 진단 및 주호소 상태를 식별하는 코드 | Condition.code | SHALL |
| [encounter](SearchParameter-krcore-sp-condition-encounter.md) | [reference](http://hl7.org/fhir/r4/search.html#reference) | 진단 및 주호소 상태가 속한 수진 | Condition.encounter | MAY |
| [onset-date](SearchParameter-krcore-sp-condition-onset-date.md) | [datetime](http://hl7.org/fhir/r4/search.html#datetime) | 진단 및 주호소 발생일자 | Condition.onset.ofType(dateTime) | Condition.onset.ofType(Period) | MAY |
| [patient](SearchParameter-krcore-sp-condition-patient.md) | [reference](http://hl7.org/fhir/r4/search.html#reference) | 진단 및 주호소 상태의 대상 | Condition.subject.where(resolve() is Patient) | SHALL |
| [recorded-date](SearchParameter-krcore-sp-condition-recorded-date.md) | [datetime](http://hl7.org/fhir/r4/search.html#datetime) | 진단 및 주호소 최초 기록일자 또는 진단일자 | Condition.recordedDate | MAY |

#### DiagnosticReport

| | | | | |
| :--- | :--- | :--- | :--- | :--- |
| [category](SearchParameter-krcore-sp-diagnosticreport-category.md) | [token](http://hl7.org/fhir/r4/search.html#token) | 진단보고서 범주 | DiagnosticReport.category | SHOULD |
| [code](SearchParameter-krcore-sp-diagnosticreport-code.md) | [token](http://hl7.org/fhir/r4/search.html#token) | 진단보고서 항목을 식별하는 코드 | DiagnosticReport.code | SHALL |
| [issued](SearchParameter-krcore-sp-diagnosticreport-issued.md) | [datetime](http://hl7.org/fhir/r4/search.html#datetime) | 진단 보고 일시 | DiagnosticReport.issued | MAY |
| [patient](SearchParameter-krcore-sp-diagnosticreport-patient.md) | [reference](http://hl7.org/fhir/r4/search.html#reference) | 진단보고서 대상 환자 | DiagnosticReport.subject.where(resolve() is Patient) | SHALL |
| [performer](SearchParameter-krcore-sp-diagnosticreport-performer.md) | [reference](http://hl7.org/fhir/r4/search.html#reference) | 진단 책임자 | DiagnosticReport.performer | MAY |
| [result](SearchParameter-krcore-sp-diagnosticreport-result.md) | [reference](http://hl7.org/fhir/r4/search.html#reference) | 진단보고를 위한 검사 결과 | DiagnosticReport.result | SHOULD |
| [specimen](SearchParameter-krcore-sp-diagnosticreport-specimen.md) | [reference](http://hl7.org/fhir/r4/search.html#reference) | 본 진단보고에 사용된 검체 | DiagnosticReport.specimen | MAY |
| [status](SearchParameter-krcore-sp-diagnosticreport-status.md) | [token](http://hl7.org/fhir/r4/search.html#token) | 진단보고서 상태 | DiagnosticReport.status | MAY |

#### Encounter

| | | | | |
| :--- | :--- | :--- | :--- | :--- |
| [class](SearchParameter-krcore-sp-encounter-class.md) | [token](http://hl7.org/fhir/r4/search.html#token) | 진료 구분 | Encounter.class | MAY |
| [date](SearchParameter-krcore-sp-encounter-date.md) | [datetime](http://hl7.org/fhir/r4/search.html#datetime) | 내원 기간 내 날짜 | Encounter.period | MAY |
| [participant](SearchParameter-krcore-sp-encounter-participant.md) | [reference](http://hl7.org/fhir/r4/search.html#reference) | 내원 참여 의료인 | Encounter.participant.individual | MAY |
| [patient](SearchParameter-krcore-sp-encounter-patient.md) | [reference](http://hl7.org/fhir/r4/search.html#reference) | 내원 환자 | Encounter.subject.where(resolve() is Patient) | SHALL |
| [service-provider](SearchParameter-krcore-sp-encounter-service-provider.md) | [reference](http://hl7.org/fhir/r4/search.html#reference) | 내원 기관 | Encounter.serviceProvider | MAY |
| [status](SearchParameter-krcore-sp-encounter-status.md) | [token](http://hl7.org/fhir/r4/search.html#token) | 내원 상태: planned | arrived | triaged | in-progress | onleave | finished | cancelled \+ | Encounter.status | MAY |

#### ImagingStudy

| | | | | |
| :--- | :--- | :--- | :--- | :--- |
| [modality](SearchParameter-krcore-sp-imagingstudy-modality.md) | [token](http://hl7.org/fhir/r4/search.html#token) | DICOM 촬영 장비 | ImagingStudy.series.modality | MAY |
| [patient](SearchParameter-krcore-sp-imagingstudy-patient.md) | [reference](http://hl7.org/fhir/r4/search.html#reference) | 진단영상 대상 환자 | ImagingStudy.subject.where(resolve() is Patient) | SHALL |
| [series](SearchParameter-krcore-sp-imagingstudy-series.md) | [token](http://hl7.org/fhir/r4/search.html#token) | DICOM Series UID | ImagingStudy.series.uid | MAY |
| [started](SearchParameter-krcore-sp-imagingstudy-started.md) | [datetime](http://hl7.org/fhir/r4/search.html#datetime) | 진단영상 촬영 시작 날짜 | ImagingStudy.started | MAY |
| [status](SearchParameter-krcore-sp-imagingstudy-status.md) | [token](http://hl7.org/fhir/r4/search.html#token) | 진단영상 상태 | ImagingStudy.status | MAY |

#### Immunization

| | | | | |
| :--- | :--- | :--- | :--- | :--- |
| [date](SearchParameter-krcore-sp-immunization-date.md) | [datetime](http://hl7.org/fhir/r4/search.html#datetime) | 예방 접종 일시 | Immunization.occurrence | SHOULD |
| [patient](SearchParameter-krcore-sp-immunization-patient.md) | [reference](http://hl7.org/fhir/r4/search.html#reference) | 예방 접종 대상 | Immunization.patient | SHALL |
| [status](SearchParameter-krcore-sp-immunization-status.md) | [token](http://hl7.org/fhir/r4/search.html#token) | 예방 접종 상태 | Immunization.status | MAY |
| [vaccine-code](SearchParameter-krcore-sp-immunization-vaccine-code.md) | [token](http://hl7.org/fhir/r4/search.html#token) | 예방접종 식별 코드 | Immunization.vaccineCode | SHALL |

#### Medication

| | | | | |
| :--- | :--- | :--- | :--- | :--- |
| [code](SearchParameter-krcore-sp-medication-code.md) | [token](http://hl7.org/fhir/r4/search.html#token) | 약품제품명 | Medication.code | SHALL |
| [ingredient-code](SearchParameter-krcore-sp-medication-ingredient-code.md) | [token](http://hl7.org/fhir/r4/search.html#token) | 약품성분명 | Medication.ingredient.item.ofType(CodeableConcept) | SHOULD |

#### MedicationRequest

| | | | | |
| :--- | :--- | :--- | :--- | :--- |
| [authoredon](SearchParameter-krcore-sp-medicationrequest-authoredon.md) | [datetime](http://hl7.org/fhir/r4/search.html#datetime) | 약물 처방 일시 | MedicationRequest.authoredOn | MAY |
| [code](SearchParameter-krcore-sp-medicationrequest-code.md) | [token](http://hl7.org/fhir/r4/search.html#token) | 처방한 약물 | (MedicationRequest.medication as CodeableConcept) | SHOULD |
| [intent](SearchParameter-krcore-sp-medicationrequest-intent.md) | [token](http://hl7.org/fhir/r4/search.html#token) | 약물 처방 의도 | MedicationRequest.intent | SHOULD |
| [medication](SearchParameter-krcore-sp-medicationrequest-medication.md) | [reference](http://hl7.org/fhir/r4/search.html#reference) | 처방한 약물 | MedicationRequest.medication.ofType(Reference) | SHOULD |
| [patient](SearchParameter-krcore-sp-medicationrequest-patient.md) | [reference](http://hl7.org/fhir/r4/search.html#reference) | 약물 처방 대상 | MedicationRequest.subject.where(resolve() is Patient) | SHALL |
| [status](SearchParameter-krcore-sp-medicationrequest-status.md) | [token](http://hl7.org/fhir/r4/search.html#token) | 약물 처방 진행 상태 | MedicationRequest.status | MAY |

#### Observation

| | | | | |
| :--- | :--- | :--- | :--- | :--- |
| [category](SearchParameter-krcore-sp-observation-category.md) | [token](http://hl7.org/fhir/r4/search.html#token) | 관찰 및 측정 범주 | Observation.category | SHOULD |
| [code](SearchParameter-krcore-sp-observation-code.md) | [token](http://hl7.org/fhir/r4/search.html#token) | 관찰 및 측정의 유형 | Observation.code | MAY |
| [code-value-concept](SearchParameter-krcore-sp-observation-code-value-concept.md) | [composite](http://hl7.org/fhir/r4/search.html#composite) | 관찰 및 측정의 유형과 CodeableConcept 자료형으로 표현된 측정값 쌍 | On Observation: code: code value-concept: value.ofType(CodeableConcept) | MAY |
| [code-value-date](SearchParameter-krcore-sp-observation-code-value-date.md) | [composite](http://hl7.org/fhir/r4/search.html#composite) | 관찰 및 측정의 유형과 date/time 자료형으로 표현된 측정값 쌍 | On Observation: code: code value-date: value.ofType(DateTime) | value.ofType(Period) | MAY |
| [code-value-quantity](SearchParameter-krcore-sp-observation-code-value-quantity.md) | [composite](http://hl7.org/fhir/r4/search.html#composite) | 관찰 및 측정의 유형과 quantity 자료형으로 표현된 측정값 쌍 | On Observation: code: code value-quantity: value.ofType(Quantity) | MAY |
| [code-value-string](SearchParameter-krcore-sp-observation-code-value-string.md) | [composite](http://hl7.org/fhir/r4/search.html#composite) | 관찰 및 측정의 유형과 string 자료형으로 표현된 측정값 쌍 | On Observation: code: code value-string: value.ofType(string) | MAY |
| [component-code](SearchParameter-krcore-sp-observation-component-code.md) | [token](http://hl7.org/fhir/r4/search.html#token) | 세부 관찰 및 측정의 유형 | Observation.component.code | MAY |
| [component-code-value-concept](SearchParameter-krcore-sp-observation-component-code-value-concept.md) | [composite](http://hl7.org/fhir/r4/search.html#composite) | 세부 관찰 및 측정의 유형과 CodeableConcept 자료형으로 표현된 세부 관찰 및 측정값 쌍 | On Observation.component: component-code: code component-value-concept: value.ofType(CodeableConcept) | MAY |
| [component-code-value-quantity](SearchParameter-krcore-sp-observation-component-code-value-quantity.md) | [composite](http://hl7.org/fhir/r4/search.html#composite) | 세부 관찰 및 측정의 유형과 Quantity 자료형으로 표현된 세부 관찰 및 측정값 쌍 | On Observation.component: component-code: code component-value-quantity: value.ofType(Quantity) | MAY |
| [component-data-absent-reason](SearchParameter-krcore-sp-observation-component-data-absent-reason.md) | [token](http://hl7.org/fhir/r4/search.html#token) | 세부 관찰 및 측정 결과(Observation.component.value[x]) 부재 사유 | Observation.component.dataAbsentReason | MAY |
| [component-value-concept](SearchParameter-krcore-sp-observation-component-value-concept.md) | [token](http://hl7.org/fhir/r4/search.html#token) | CodeableConcept 자료형으로 표현된 세부 관찰 및 측정값 | Observation.component.value.ofType(CodeableConcept) | MAY |
| [component-value-quantity](SearchParameter-krcore-sp-observation-component-value-quantity.md) | [quantity](http://hl7.org/fhir/r4/search.html#quantity) | Quantity 또는 SampledData 자료형으로 표현된 세부 관찰 및 측정값 | Observation.component.value.ofType(Quantity) | Observation.component.value.ofType(SampledData) | MAY |
| [data-absent-reason](SearchParameter-krcore-sp-observation-data-absent-reason.md) | [token](http://hl7.org/fhir/r4/search.html#token) | 관찰 및 측정 결과(Observation.value[x]) 부재 사유 | Observation.dataAbsentReason | MAY |
| [date](SearchParameter-krcore-sp-observation-date.md) | [datetime](http://hl7.org/fhir/r4/search.html#datetime) | 관찰 및 측정 일시 | Observation.effective | MAY |
| [patient](SearchParameter-krcore-sp-observation-patient.md) | [reference](http://hl7.org/fhir/r4/search.html#reference) | 관찰 및 측정 대상 환자 | Observation.subject.where(resolve() is Patient) | SHALL |
| [performer](SearchParameter-krcore-sp-observation-performer.md) | [reference](http://hl7.org/fhir/r4/search.html#reference) | 관찰 및 측정 책임자 | Observation.performer | SHOULD |
| [specimen](SearchParameter-krcore-sp-observation-specimen.md) | [reference](http://hl7.org/fhir/r4/search.html#reference) | 본 관찰 및 측정에 사용된 검체 | Observation.specimen | MAY |
| [status](SearchParameter-krcore-sp-observation-status.md) | [token](http://hl7.org/fhir/r4/search.html#token) | 관찰 및 측정 진행 상태 | Observation.status | MAY |
| [value-concept](SearchParameter-krcore-sp-observation-value-concept.md) | [token](http://hl7.org/fhir/r4/search.html#token) | CodeableConcept 자료형으로 표현된 측정값 | Observation.value.ofType(CodeableConcept) | MAY |
| [value-date](SearchParameter-krcore-sp-observation-value-date.md) | [datetime](http://hl7.org/fhir/r4/search.html#datetime) | dateTime 또는 Period 자료형으로 표현된 측정값 | Observation.value.ofType(dateTime) | Observation.value.ofType(Period) | MAY |
| [value-quantity](SearchParameter-krcore-sp-observation-value-quantity.md) | [quantity](http://hl7.org/fhir/r4/search.html#quantity) | Quantity 또는 SampledData 자료형으로 표현된 측정값 | Observation.value.ofType(Quantity) | Observation.value.ofType(SampledData) | MAY |
| [value-string](SearchParameter-krcore-sp-observation-value-string.md) | [string](http://hl7.org/fhir/r4/search.html#string) | string 자료형 또는 CodeableConcept 자료형 내 text로 표현된 측정값 | Observation.value.ofType(string) | Observation.value.ofType(CodeableConcept).text | MAY |

#### Organization

| | | | | |
| :--- | :--- | :--- | :--- | :--- |
| [address](SearchParameter-krcore-sp-organization-address.md) | [string](http://hl7.org/fhir/r4/search.html#string) | 한국 도로명 주소를 포함한 기관 주소 검색 | Organization.address | Organization.address.text | Organization.address.extension('http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-roadNameAddress').extension.value | MAY |
| [identifier](SearchParameter-krcore-sp-organization-identifier.md) | [token](http://hl7.org/fhir/r4/search.html#token) | 기관 식별자 | Organization.identifier | SHALL |
| [name](SearchParameter-krcore-sp-organization-name.md) | [string](http://hl7.org/fhir/r4/search.html#string) | 기관 명칭 | Organization.name | Organization.alias | SHOULD |
| [type](SearchParameter-krcore-sp-organization-type.md) | [token](http://hl7.org/fhir/r4/search.html#token) | 기관 유형 | Organization.type | MAY |

#### Patient

| | | | | |
| :--- | :--- | :--- | :--- | :--- |
| [_id](SearchParameter-krcore-sp-patient-id.md) | [token](http://hl7.org/fhir/r4/search.html#token) | 본 리소스 인스턴스의 논리적 ID | Patient.id | SHALL |
| [address](SearchParameter-krcore-sp-patient-address.md) | [string](http://hl7.org/fhir/r4/search.html#string) | 한국 도로명 주소를 포함한 환자 주소 검색 | Patient.address | Patient.address.text | Patient.address.extension('http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-roadNameAddress').extension.value | MAY |
| [birthdate](SearchParameter-krcore-sp-patient-birthdate.md) | [date](http://hl7.org/fhir/r4/search.html#date) | 환자의 생일 | Patient.birthDate | SHOULD |
| [gender](SearchParameter-krcore-sp-patient-gender.md) | [token](http://hl7.org/fhir/r4/search.html#token) | 환자의 성별 | Patient.gender | SHOULD |
| [identifier](SearchParameter-krcore-sp-patient-identifier.md) | [token](http://hl7.org/fhir/r4/search.html#token) | 환자의 식별자 | Patient.identifier | SHALL |
| [name](SearchParameter-krcore-sp-patient-name.md) | [string](http://hl7.org/fhir/r4/search.html#string) | 환자의 성명을 구성하는 성, 이름 등의 요소 중 일치하는 문자열 | Patient.name | SHALL |
| [telecom](SearchParameter-krcore-sp-patient-telecom.md) | [token](http://hl7.org/fhir/r4/search.html#token) | 환자의 연락처 | Patient.telecom | SHOULD |

#### Practitioner

| | | | | |
| :--- | :--- | :--- | :--- | :--- |
| [_id](SearchParameter-krcore-sp-practitioner-id.md) | [token](http://hl7.org/fhir/r4/search.html#token) | 본 리소스 인스턴스의 논리적 ID | Practitioner.id | SHOULD |
| [identifier](SearchParameter-krcore-sp-practitioner-identifier.md) | [token](http://hl7.org/fhir/r4/search.html#token) | 의료인 식별자 | Practitioner.identifier | Practitioner.qualification.identifier | SHALL |
| [name](SearchParameter-krcore-sp-practitioner-name.md) | [string](http://hl7.org/fhir/r4/search.html#string) | 의료인의 성명을 구성하는 성, 이름 등의 요소 중 일치하는 문자열 | Practitioner.name | SHALL |

#### PractitionerRole

| | | | | |
| :--- | :--- | :--- | :--- | :--- |
| [organization](SearchParameter-krcore-sp-practitionerrole-organization.md) | [reference](http://hl7.org/fhir/r4/search.html#reference) | 의료인 소속 기관 | PractitionerRole.organization | MAY |
| [practitioner](SearchParameter-krcore-sp-practitionerrole-practitioner.md) | [reference](http://hl7.org/fhir/r4/search.html#reference) | 의료인 인적사항 | PractitionerRole.practitioner | SHALL |
| [role](SearchParameter-krcore-sp-practitionerrole-role.md) | [token](http://hl7.org/fhir/r4/search.html#token) | 의료인 역할 | PractitionerRole.code | SHOULD |
| [specialty](SearchParameter-krcore-sp-practitionerrole-specialty.md) | [token](http://hl7.org/fhir/r4/search.html#token) | 의료인 진료과목 코드 | PractitionerRole.specialty | SHOULD |

#### Procedure

| | | | | |
| :--- | :--- | :--- | :--- | :--- |
| [category](SearchParameter-krcore-sp-procedure-category.md) | [token](http://hl7.org/fhir/r4/search.html#token) | 수술 및 처치 범주 | Procedure.category | MAY |
| [code](SearchParameter-krcore-sp-procedure-code.md) | [token](http://hl7.org/fhir/r4/search.html#token) | 수술 및 처치 식별 코드 | Procedure.code | SHOULD |
| [date](SearchParameter-krcore-sp-procedure-date.md) | [datetime](http://hl7.org/fhir/r4/search.html#datetime) | 수술 및 처치 수행 일시 | Procedure.performed | SHOULD |
| [patient](SearchParameter-krcore-sp-procedure-patient.md) | [reference](http://hl7.org/fhir/r4/search.html#reference) | 수술 및 처치 대상 환자 | Procedure.subject.where(resolve() is Patient) | SHALL |
| [status](SearchParameter-krcore-sp-procedure-status.md) | [token](http://hl7.org/fhir/r4/search.html#token) | 수술 및 처치 상태: preparation | in-progress | not-done | on-hold | stopped | completed | entered-in-error | unknown | Procedure.status | MAY |

#### Specimen

| | | | | |
| :--- | :--- | :--- | :--- | :--- |
| [bodysite](SearchParameter-krcore-sp-specimen-bodysite.md) | [token](http://hl7.org/fhir/r4/search.html#token) | 검체 채취 부위 | Specimen.collection.bodySite | MAY |
| [identifier](SearchParameter-krcore-sp-specimen-identifier.md) | [token](http://hl7.org/fhir/r4/search.html#token) | 검체의 검사실 외부 식별자 | Specimen.identifier | MAY |
| [patient](SearchParameter-krcore-sp-specimen-patient.md) | [reference](http://hl7.org/fhir/r4/search.html#reference) | 검체 채취 대상 환자 | Specimen.subject.where(resolve() is Patient) | SHALL |
| [type](SearchParameter-krcore-sp-specimen-type.md) | [token](http://hl7.org/fhir/r4/search.html#token) | 검체 유형 | Specimen.type | SHOULD |

