# hl7.fhir.kr.core#2.0.0: KR Core Implementation Guide

## Pages

* [Home](index.md)
* [Examples](examples.md)
* [Search Parameters Organization Defined](search_parameters_organization_defined.md)
* [Search Parameters Practitioner Defined](search_parameters_practitioner_defined.md)
* [Search Parameters Observation Defined](search_parameters_observation_defined.md)
* [KR Core Server - XML Representation](ActorDefinition-krcore-actordefinition-server.xml.md)
* [Search Parameters Specimen Derived](search_parameters_specimen_derived.md)
* [Search Parameters Encounter Defined](search_parameters_encounter_defined.md)
* [Search Parameters Diagnosticreport Derived](search_parameters_diagnosticreport_derived.md)
* [Terminology](terminology.md)
* [](ActorDefinition-krcore-actordefinition-client.change.history.md)
* [Extra Codesystems](extra_codesystems.md)
* [Profiles and Extensions](profiles_and_extensions.md)
* [Search Parameters](search_parameters.md)
* [Search Parameters Imagingstudy Derived](search_parameters_imagingstudy_derived.md)
* [Key Terms](key_terms.md)
* [Search Parameters Medicationrequest Defined](search_parameters_medicationrequest_defined.md)
* [KR Core Client - Testing](ActorDefinition-krcore-actordefinition-client-testing.md)
* [KR Core Client - XML Representation](ActorDefinition-krcore-actordefinition-client.xml.md)
* [KR Core Server - JSON Representation](ActorDefinition-krcore-actordefinition-server.json.md)
* [](ActorDefinition-krcore-actordefinition-server.change.history.md)
* [Capability Statements](capability_statements.md)
* [Change Log](change_log.md)
* [Kr Cdi](kr_cdi.md)
* [Search Parameters Medication Derived](search_parameters_medication_derived.md)
* [KR Core Server](ActorDefinition-krcore-actordefinition-server.md)
* [Search Parameters Immunization Defined](search_parameters_immunization_defined.md)
* [Search Parameters Encounter Derived](search_parameters_encounter_derived.md)
* [KR Core Server - TTL Representation](ActorDefinition-krcore-actordefinition-server.ttl.md)
* [Search Parameters Practitionerrole Derived](search_parameters_practitionerrole_derived.md)
* [Search Parameters Medicationrequest Derived](search_parameters_medicationrequest_derived.md)
* [Search Parameters Observation Derived](search_parameters_observation_derived.md)
* [KR Core Client](ActorDefinition-krcore-actordefinition-client.md)
* [Search Parameters Practitioner Derived](search_parameters_practitioner_derived.md)
* [Search Parameters Organization Derived](search_parameters_organization_derived.md)
* [Actor Definitions](actor_definitions.md)
* [Search Parameters Diagnosticreport Defined](search_parameters_diagnosticreport_defined.md)
* [KR Core Client - TTL Representation](ActorDefinition-krcore-actordefinition-client.ttl.md)
* [General Guidance](general_guidance.md)
* [Namingsystems](namingsystems.md)
* [Search Parameters Procedure Derived](search_parameters_procedure_derived.md)
* [Search Parameters Allergyintolerance Derived](search_parameters_allergyintolerance_derived.md)
* [KR Core Client - JSON Representation](ActorDefinition-krcore-actordefinition-client.json.md)
* [KR Core Server - Testing](ActorDefinition-krcore-actordefinition-server-testing.md)
* [Search Parameters Condition Derived](search_parameters_condition_derived.md)
* [Artifacts Summary](artifacts.md)
* [Downloads](downloads.md)
* [Element Support and Responsibilities](element_support_and_responsibilities.md)
* [Search Parameters Immunization Derived](search_parameters_immunization_derived.md)
* [Search Parameters Patient Derived](search_parameters_patient_derived.md)
* [General Requirements](general_requirements.md)

## Resources

### CodeSystems

* [HIRA EDI Material](CodeSystem-hira-edi-material.md)
* [HIRA EDI Medication](CodeSystem-hira-edi-medication.md)
* [HIRA EDI Procedure](CodeSystem-hira-edi-procedure.md)
* [HIRA Healthcare Organization Types](CodeSystem-hira-healthcare-organization-types.md)
* [HIRA Insurance Types](CodeSystem-hira-insurance-types.md)
* [HIRA Medical Department](CodeSystem-hira-medical-department.md)
* [KOSTAT KCD-8](CodeSystem-kostat-kcd-8.md)
* [KPIS Korea Drug Code](CodeSystem-kpis-kdcode.md)
* [KR Core Condition Category Types](CodeSystem-krcore-condition-category-types.md)
* [KR Core Procedure Category Types](CodeSystem-krcore-procedure-category-types.md)
* [KR Core Vaccination Types](CodeSystem-krcore-vcnt-types.md)
* [MOHW Practitioner Qualification Types](CodeSystem-mohw-practitioner-qualification-types.md)

### ValueSets

* [ATC Codes](ValueSet-krcore-atc-codes.md)
* [KR Core Condition Category Codes](ValueSet-krcore-condition-category-codes.md)
* [KR Core Diagnostic Imaging Codes](ValueSet-krcore-diagnostic-imaging-codes.md)
* [KR Core Doctor Qualification Codes](ValueSet-krcore-doctor-qualification-codes.md)
* [KR Core EDI Material Codes](ValueSet-krcore-edi-material-codes.md)
* [KR Core EDI Medication Codes](ValueSet-krcore-edi-medication-codes.md)
* [KR Core EDI Procedure Codes](ValueSet-krcore-edi-procedure-codes.md)
* [KR Core Organization Type Codes](ValueSet-krcore-healthcare-organization-type-codes.md)
* [KR Core Insurance Types Codes](ValueSet-krcore-insurance-types-codes.md)
* [KR Core KCD8 Codes](ValueSet-krcore-kcd8-codes.md)
* [KR Core Korea Drug Codes](ValueSet-krcore-korea-drug-codes.md)
* [KR Core Laboratory Codes](ValueSet-krcore-laboratory-codes.md)
* [KR Core LOINC Codes](ValueSet-krcore-loinc-codes.md)
* [KR Core Medical Department Codes](ValueSet-krcore-medicaldepartment-codes.md)
* [KR Core Pathology Codes](ValueSet-krcore-pathology-codes.md)
* [KR Core Procedure Category Codes](ValueSet-krcore-procedure-category-codes.md)
* [KR Core Procedure Codes](ValueSet-krcore-procedure-codes.md)
* [KR Core SNOMED CT Codes](ValueSet-krcore-snomed-ct-codes.md)
* [KR Core Vaccination Type Codes](ValueSet-krcore-vcnt-type-codes.md)
* [KR Core Vital Signs Codes](ValueSet-krcore-vital-signs-codes.md)

### Resource Profiles

* [KR Core AllergyIntolerance Profile](StructureDefinition-krcore-allergyintolerance.md)
* [KR Core Observation Profile for Vital Signs: Blood Pressure](StructureDefinition-krcore-bloodpressure.md)
* [KR Core Observation Profile for Vital Signs: Body Height](StructureDefinition-krcore-bodyheight.md)
* [KR Core Observation Profile for Vital Signs: Body Temperature](StructureDefinition-krcore-bodytemperature.md)
* [KR Core Observation Profile for Vital Signs: Body Weight](StructureDefinition-krcore-bodyweight.md)
* [KR Core Condition Profile for Chief Complaint](StructureDefinition-krcore-condition-chief-complaint.md)
* [KR Core Condition Profile for Encounter Diagnosis](StructureDefinition-krcore-condition-encounter-diagnosis.md)
* [KR Core DiagnosticReport Profile for Diagnostic Imaging](StructureDefinition-krcore-diagnosticreport-diagnostic-imaging.md)
* [KR Core DiagnosticReport Profile for Functional Tests](StructureDefinition-krcore-diagnosticreport-function-tests.md)
* [KR Core DiagnosticReport Profile for Laboratory Results](StructureDefinition-krcore-diagnosticreport-laboratory-results.md)
* [KR Core DiagnosticReport Profile for Pathology Results](StructureDefinition-krcore-diagnosticreport-pathology-results.md)
* [KR Core Encounter Profile](StructureDefinition-krcore-encounter.md)
* [KR Core Healthcare Organization Profile](StructureDefinition-krcore-healthcare-organization.md)
* [KR Core Observation Profile for Vital Signs: Heart Rate](StructureDefinition-krcore-heartrate.md)
* [KR Core ImagingStudy Profile](StructureDefinition-krcore-imagingstudy.md)
* [KR Core Immunization Profile](StructureDefinition-krcore-immunization.md)
* [KR Core PractitionerRole Profile for Medical Doctor](StructureDefinition-krcore-medical-doctor-role.md)
* [KR Core Practitioner Profile for Medical Doctor](StructureDefinition-krcore-medical-doctor.md)
* [KR Core Medication Profile](StructureDefinition-krcore-medication.md)
* [KR Core MedicationRequest Profile](StructureDefinition-krcore-medicationrequest.md)
* [KR Core Observation Profile for Functional Test](StructureDefinition-krcore-observation-function-test.md)
* [KR Core Observation Profile for Laboratory Result](StructureDefinition-krcore-observation-laboratory-result.md)
* [KR Core Organization Profile](StructureDefinition-krcore-organization.md)
* [KR Core Patient Profile](StructureDefinition-krcore-patient.md)
* [KR Core PractitionerRole Profile](StructureDefinition-krcore-practitioner-role.md)
* [KR Core Practitioner Profile](StructureDefinition-krcore-practitioner.md)
* [KR Core Procedure Profile](StructureDefinition-krcore-procedure.md)
* [KR Core Observation Profile for Vital Signs: Pulse Oximetry](StructureDefinition-krcore-pulseoximetry.md)
* [KR Core Observation Profile for Vital Signs: Respiratory Rate](StructureDefinition-krcore-respiratoryrate.md)
* [KR Core Specimen Profile](StructureDefinition-krcore-specimen.md)
* [KR Core Observation Profile for Vital Signs](StructureDefinition-krcore-vitalsigns.md)

### Extensions

* [KR Core Insurance Types Extension](StructureDefinition-krcore-insuranceTypes.md)
* [KR Core Medication Ingredient Extension](StructureDefinition-krcore-medicationIngredient.md)
* [KR Core Road Name Address Extension](StructureDefinition-krcore-roadNameAddress.md)
* [KR Core Test Request DateTime Extension](StructureDefinition-krcore-testRequestDateTime.md)

### Basics

* [krcore-actordefinition-client](Basic-krcore-actordefinition-client.md)
* [krcore-actordefinition-server](Basic-krcore-actordefinition-server.md)

### CapabilityStatements

* [KR Core Client CapabilityStatement](CapabilityStatement-krcore-capabilitystatement-client.md)
* [KR Core Server CapabilityStatement](CapabilityStatement-krcore-capabilitystatement-server.md)

### ImplementationGuides

* [KR Core Implementation Guide](index.md)

### NamingSystems

* [HIRA_EDI_Material](NamingSystem-ns-hira-edi-material.md)
* [HIRA_EDI_Medication](NamingSystem-ns-hira-edi-medication.md)
* [HIRA_EDI_Procedure](NamingSystem-ns-hira-edi-procedure.md)
* [HIRA_Healthcare_Organization_Identifier](NamingSystem-ns-hira-healthcare-organization-identifier.md)
* [HIRA_Healthcare_Organization_Types](NamingSystem-ns-hira-healthcare-organization-types.md)
* [HIRA_Insurance_Types](NamingSystem-ns-hira-insurance-types.md)
* [HIRA_Medical_Department](NamingSystem-ns-hira-medical-department.md)
* [KOSTAT_KCD8](NamingSystem-ns-kostat-kcd-8.md)
* [KPIS_Korea_Drug_Code](NamingSystem-ns-kpis-kdcode.md)
* [MOHW_MD_License_Id](NamingSystem-ns-mohw-md-license-id.md)
* [MOHW_Practitioner_Qualification_Types](NamingSystem-ns-mohw-practitioner-qualification-types.md)

### SearchParameters

* [KRCoreSearchParameterAllergyIntoleranceCategory](SearchParameter-krcore-sp-allergyintolerance-category.md)
* [KRCoreSearchParameterAllergyIntoleranceClinicalStatus](SearchParameter-krcore-sp-allergyintolerance-clinical-status.md)
* [KRCoreSearchParameterAllergyIntoleranceCode](SearchParameter-krcore-sp-allergyintolerance-code.md)
* [KRCoreSearchParameterAllergyIntoleranceManifestation](SearchParameter-krcore-sp-allergyintolerance-manifestation.md)
* [KRCoreSearchParameterAllergyIntoleranceOnset](SearchParameter-krcore-sp-allergyintolerance-onset.md)
* [KRCoreSearchParameterAllergyIntolerancePatient](SearchParameter-krcore-sp-allergyintolerance-patient.md)
* [KRCoreSearchParameterConditionCategory](SearchParameter-krcore-sp-condition-category.md)
* [KRCoreSearchParameterConditionClinicalStatus](SearchParameter-krcore-sp-condition-clinical-status.md)
* [KRCoreSearchParameterConditionCode](SearchParameter-krcore-sp-condition-code.md)
* [KRCoreSearchParameterDiagnosticReportResult](SearchParameter-krcore-sp-diagnosticreport-result.md)
* [KRCoreSearchParameterDiagnosticReportSpecimen](SearchParameter-krcore-sp-diagnosticreport-specimen.md)
* [KRCoreSearchParameterDiagnosticReportStudy](SearchParameter-krcore-sp-diagnosticreport-study.md)
* [KRCoreSearchParameterEncounterStatus](SearchParameter-krcore-sp-encounter-status.md)
* [KRCoreSearchParameterImagingStudyModality](SearchParameter-krcore-sp-imagingstudy-modality.md)
* [KRCoreSearchParameterImagingStudySeries](SearchParameter-krcore-sp-imagingstudy-series.md)
* [KRCoreSearchParameterImmunizationDoseNumber](SearchParameter-krcore-sp-immunization-dose-number.md)
* [KRCoreSearchParameterImmunizationStatus](SearchParameter-krcore-sp-immunization-status.md)
* [KRCoreSearchParameterMedicationRequestAuthoredOn](SearchParameter-krcore-sp-medicationrequest-authoredon.md)
* [KRCoreSearchParameterMedicationRequestIntent](SearchParameter-krcore-sp-medicationrequest-intent.md)
* [KRCoreSearchParameterMedicationRequestMedication](SearchParameter-krcore-sp-medicationrequest-medication.md)
* [KRCoreSearchParameterObservationCode](SearchParameter-krcore-sp-observation-code.md)
* [KRCoreSearchParameterObservationComponentCodeValueConcept](SearchParameter-krcore-sp-observation-component-code-value-concept.md)
* [KRCoreSearchParameterObservationComponentCodeValueQuantity](SearchParameter-krcore-sp-observation-component-code-value-quantity.md)
* [KRCoreSearchParameterObservationComponentCode](SearchParameter-krcore-sp-observation-component-code.md)
* [KRCoreSearchParameterObservationComponentDataAbsentReason](SearchParameter-krcore-sp-observation-component-data-absent-reason.md)
* [KRCoreSearchParameterObservationComponentValueConcept](SearchParameter-krcore-sp-observation-component-value-concept.md)
* [KRCoreSearchParameterObservationPerformer](SearchParameter-krcore-sp-observation-performer.md)
* [KRCoreSearchParameterObservationSpecimen](SearchParameter-krcore-sp-observation-specimen.md)
* [KRCoreSearchParameterObservationValueDate](SearchParameter-krcore-sp-observation-value-date.md)
* [KRCoreSearchParameterOrganizationAddress](SearchParameter-krcore-sp-organization-address.md)
* [KRCoreSearchParameterOrganizationName](SearchParameter-krcore-sp-organization-name.md)
* [KRCoreSearchParameterPatientId](SearchParameter-krcore-sp-patient-id.md)
* [KRCoreSearchParameterPatientName](SearchParameter-krcore-sp-patient-name.md)
* [KRCoreSearchParameterPractitionerName](SearchParameter-krcore-sp-practitioner-name.md)
* [KRCoreSearchParameterPractitionerRolePractitioner](SearchParameter-krcore-sp-practitionerrole-practitioner.md)
* [KRCoreSearchParameterPractitionerRoleSpecialty](SearchParameter-krcore-sp-practitionerrole-specialty.md)
* [KRCoreSearchParameterProcedureCode](SearchParameter-krcore-sp-procedure-code.md)
* [KRCoreSearchParameterProcedureStatus](SearchParameter-krcore-sp-procedure-status.md)
* [KRCoreSearchParameterSpecimenBodySite](SearchParameter-krcore-sp-specimen-bodysite.md)
