# KR Core Vital Signs Codes - KR Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **KR Core Vital Signs Codes**

## ValueSet: KR Core Vital Signs Codes 

| | |
| :--- | :--- |
| *Official URL*:http://www.hl7korea.or.kr/fhir/krcore/ValueSet/krcore-vital-signs-codes | *Version*:1.0.2 |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | *Computable Name*:KR_Core_Vital_Signs_Codes |

 
KR Core 활력징후 및 신체 계측 항목 코드집합 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "krcore-vital-signs-codes",
  "url" : "http://www.hl7korea.or.kr/fhir/krcore/ValueSet/krcore-vital-signs-codes",
  "version" : "1.0.2",
  "name" : "KR_Core_Vital_Signs_Codes",
  "title" : "KR Core Vital Signs Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2023-06-30",
  "publisher" : "HL7 Korea",
  "description" : "KR Core 활력징후 및 신체 계측 항목 코드집합",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "KR",
          "display" : "Korea, Republic of"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "http://loinc.org",
        "concept" : [
          {
            "code" : "8867-4"
          },
          {
            "code" : "9279-1"
          },
          {
            "code" : "2708-6"
          },
          {
            "code" : "8310-5"
          },
          {
            "code" : "8302-2"
          },
          {
            "code" : "29463-7"
          },
          {
            "code" : "85354-9"
          },
          {
            "code" : "8480-6"
          },
          {
            "code" : "8462-4"
          },
          {
            "code" : "8478-0"
          }
        ]
      }
    ]
  }
}

```
