# KR Core Vaccination Type Codes - KR Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **KR Core Vaccination Type Codes**

## ValueSet: KR Core Vaccination Type Codes 

| | |
| :--- | :--- |
| *Official URL*:http://www.hl7korea.or.kr/fhir/krcore/ValueSet/krcore-vcnt-type-codes | *Version*:1.0.2 |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | *Computable Name*:KR_Core_Vaccination_Type_Codes |

 
KR Core 예방접종명 코드집합 

 **References** 

* [KR Core Immunization Profile](StructureDefinition-krcore-immunization.md)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "krcore-vcnt-type-codes",
  "url" : "http://www.hl7korea.or.kr/fhir/krcore/ValueSet/krcore-vcnt-type-codes",
  "version" : "1.0.2",
  "name" : "KR_Core_Vaccination_Type_Codes",
  "title" : "KR Core Vaccination Type Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2023-06-30",
  "publisher" : "HL7 Korea",
  "description" : "KR Core 예방접종명 코드집합",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "KR",
          "display" : "Korea, Republic of"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "http://www.hl7korea.or.kr/fhir/krcore/CodeSystem/krcore-vcnt-types"
      }
    ]
  }
}

```
