# KR Core EDI Procedure Codes - KR Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **KR Core EDI Procedure Codes**

## ValueSet: KR Core EDI Procedure Codes 

| | |
| :--- | :--- |
| *Official URL*:http://www.hl7korea.or.kr/fhir/krcore/ValueSet/krcore-edi-procedure-codes | *Version*:1.0.2 |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | *Computable Name*:KR_Core_EDI_Procedure_Codes |

 
KR Core EDI 진료행위 코드집합 

 **References** 

* Included into [KR_Core_Diagnostic_Imaging_Codes](ValueSet-krcore-diagnostic-imaging-codes.md)
* Included into [KR_Core_Laboratory_Codes](ValueSet-krcore-laboratory-codes.md)
* Included into [KR_Core_Pathology_Codes](ValueSet-krcore-pathology-codes.md)
* Included into [KR_Core_Procedure_Codes](ValueSet-krcore-procedure-codes.md)
* [KR Core DiagnosticReport Profile for Functional Tests](StructureDefinition-krcore-diagnosticreport-function-tests.md)
* [KR Core Observation Profile for Functional Test](StructureDefinition-krcore-observation-function-test.md)

### Logical Definition (CLD)

 

### Expansion

No Expansion for this valueset (not supported by Publication Tooling)

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "krcore-edi-procedure-codes",
  "url" : "http://www.hl7korea.or.kr/fhir/krcore/ValueSet/krcore-edi-procedure-codes",
  "version" : "1.0.2",
  "name" : "KR_Core_EDI_Procedure_Codes",
  "title" : "KR Core EDI Procedure Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2023-06-30",
  "publisher" : "HL7 Korea",
  "description" : "KR Core EDI 진료행위 코드집합",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "KR",
          "display" : "Korea, Republic of"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "http://www.hl7korea.or.kr/CodeSystem/hira-edi-procedure"
      }
    ]
  }
}

```
