# KR Core Doctor Qualification Codes - KR Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **KR Core Doctor Qualification Codes**

## ValueSet: KR Core Doctor Qualification Codes 

| | |
| :--- | :--- |
| *Official URL*:http://www.hl7korea.or.kr/fhir/krcore/ValueSet/krcore-doctor-qualification-codes | *Version*:1.0.2 |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | *Computable Name*:KR_Core_Doctor_Qualification_Codes |

 
KR Core 진료의 면허(자격) 종별 코드집합 

 **References** 

* [KR Core Practitioner Profile for Medical Doctor](StructureDefinition-krcore-medical-doctor.md)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "krcore-doctor-qualification-codes",
  "url" : "http://www.hl7korea.or.kr/fhir/krcore/ValueSet/krcore-doctor-qualification-codes",
  "version" : "1.0.2",
  "name" : "KR_Core_Doctor_Qualification_Codes",
  "title" : "KR Core Doctor Qualification Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2023-06-30",
  "publisher" : "HL7 Korea",
  "description" : "KR Core 진료의 면허(자격) 종별 코드집합",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "KR",
          "display" : "Korea, Republic of"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "http://www.hl7korea.or.kr/CodeSystem/mohw-practitioner-qualification-types",
        "concept" : [
          {
            "code" : "의사"
          },
          {
            "code" : "치과의사"
          },
          {
            "code" : "한의사"
          },
          {
            "code" : "내과"
          },
          {
            "code" : "신경과"
          },
          {
            "code" : "정신건강의학과"
          },
          {
            "code" : "외과"
          },
          {
            "code" : "정형외과"
          },
          {
            "code" : "신경외과"
          },
          {
            "code" : "심장혈관흉부외과"
          },
          {
            "code" : "성형외과"
          },
          {
            "code" : "마취통증의학과"
          },
          {
            "code" : "산부인과"
          },
          {
            "code" : "소아청소년과"
          },
          {
            "code" : "안과"
          },
          {
            "code" : "이비인후과"
          },
          {
            "code" : "피부과"
          },
          {
            "code" : "비뇨의학과"
          },
          {
            "code" : "영상의학과"
          },
          {
            "code" : "방사선종양학과"
          },
          {
            "code" : "병리과"
          },
          {
            "code" : "진단검사의학과"
          },
          {
            "code" : "결핵과"
          },
          {
            "code" : "재활의학과"
          },
          {
            "code" : "예방의학과"
          },
          {
            "code" : "가정의학과"
          },
          {
            "code" : "응급의학과"
          },
          {
            "code" : "핵의학"
          },
          {
            "code" : "직업환경의학과"
          },
          {
            "code" : "신경정신과"
          },
          {
            "code" : "방사선과"
          },
          {
            "code" : "구강악안면외과"
          },
          {
            "code" : "치과보철과"
          },
          {
            "code" : "치과교정과"
          },
          {
            "code" : "소아치과"
          },
          {
            "code" : "치주과"
          },
          {
            "code" : "치과보존과"
          },
          {
            "code" : "구강내과"
          },
          {
            "code" : "영상치의학과"
          },
          {
            "code" : "구강병리과"
          },
          {
            "code" : "예방치과"
          },
          {
            "code" : "통합치의학과"
          },
          {
            "code" : "한방내과"
          },
          {
            "code" : "한방부인과"
          },
          {
            "code" : "한방소아과"
          },
          {
            "code" : "한방신경정신과"
          },
          {
            "code" : "침구과"
          },
          {
            "code" : "한방안.이비인후.피부과"
          },
          {
            "code" : "한방재활의학과"
          },
          {
            "code" : "사상체질과"
          }
        ]
      }
    ]
  }
}

```
