# KR Core Specimen Profile - KR Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **KR Core Specimen Profile**

## Resource Profile: KR Core Specimen Profile 

| | |
| :--- | :--- |
| *Official URL*:http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-specimen | *Version*:2.0.0 |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | *Computable Name*:KRCore_Specimen |

 
KR Core Specimen Profile은 KR Core Server와 KR Core Client가 진료정보를 교류할 때 검체 정보를 표현하는 데 사용되며, 이 경우**가능한 한(SHOULD)**본 Profile을 준수해야 한다. 검체 정보 표현할 때 본 Profile을 적용하지 않을 수 있는 경우는 특수한 상황에 한정된다. 이 경우 반드시 해당 진료정보교류 도메인 내에서 사전 합의가 이루어져야 한다. 

 
**KR CDI V2 검체**클래스에서 정의한 항목들과 주요 추가 정보를 구조화하기 위해 정의한 Profile. 

**Usages:**

* Refer to this Profile: [KR Core DiagnosticReport Profile for Laboratory Results](StructureDefinition-krcore-diagnosticreport-laboratory-results.md), [KR Core DiagnosticReport Profile for Pathology Results](StructureDefinition-krcore-diagnosticreport-pathology-results.md) and [KR Core Observation Profile for Laboratory Result](StructureDefinition-krcore-observation-laboratory-result.md)
* CapabilityStatements using this Profile: [KR Core Client CapabilityStatement](CapabilityStatement-krcore-capabilitystatement-client.md) and [KR Core Server CapabilityStatement](CapabilityStatement-krcore-capabilitystatement-server.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.kr.core|current/StructureDefinition/krcore-specimen)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-krcore-specimen.csv), [Excel](StructureDefinition-krcore-specimen.xlsx), [Schematron](StructureDefinition-krcore-specimen.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "krcore-specimen",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://www.hl7korea.or.kr/fhir/krcore/ImplementationGuide/hl7.fhir.kr.core"
          }
        ]
      }
    }
  ],
  "url" : "http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-specimen",
  "version" : "2.0.0",
  "name" : "KRCore_Specimen",
  "title" : "KR Core Specimen Profile",
  "status" : "active",
  "date" : "2025-08-29T13:39:02+09:00",
  "publisher" : "HL7 Korea",
  "description" : "KR Core Specimen Profile은 KR Core Server와 KR Core Client가 진료정보를 교류할 때 검체 정보를 표현하는 데 사용되며, 이 경우 **가능한 한(SHOULD)** 본 Profile을 준수해야 한다.\n검체 정보 표현할 때 본 Profile을 적용하지 않을 수 있는 경우는 특수한 상황에 한정된다. 이 경우 반드시 해당 진료정보교류 도메인 내에서 사전 합의가 이루어져야 한다.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "KR",
          "display" : "Korea, Republic of"
        }
      ]
    }
  ],
  "purpose" : "**KR CDI V2 검체** 클래스에서 정의한 항목들과 주요 추가 정보를 구조화하기 위해 정의한 Profile.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Specimen",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Specimen",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Specimen",
        "path" : "Specimen",
        "short" : "KR Core Specimen Profile"
      },
      {
        "id" : "Specimen.identifier",
        "path" : "Specimen.identifier",
        "short" : "검사실 외부에서 부여된 검체 ID"
      },
      {
        "id" : "Specimen.identifier.system",
        "path" : "Specimen.identifier.system",
        "min" : 1
      },
      {
        "id" : "Specimen.identifier.value",
        "path" : "Specimen.identifier.value",
        "min" : 1
      },
      {
        "id" : "Specimen.type",
        "path" : "Specimen.type",
        "short" : "검체 종류",
        "alias" : ["KRCDI: 검체 종류"],
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://www.hl7korea.or.kr/fhir/krcore/ValueSet/krcore-snomed-ct-codes"
        }
      },
      {
        "id" : "Specimen.type.coding.system",
        "path" : "Specimen.type.coding.system",
        "min" : 1
      },
      {
        "id" : "Specimen.type.coding.code",
        "path" : "Specimen.type.coding.code",
        "min" : 1
      },
      {
        "id" : "Specimen.subject",
        "path" : "Specimen.subject",
        "short" : "검체 출처",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-patient",
              "http://hl7.org/fhir/StructureDefinition/Group",
              "http://hl7.org/fhir/StructureDefinition/Device",
              "http://hl7.org/fhir/StructureDefinition/Substance",
              "http://hl7.org/fhir/StructureDefinition/Location"
            ]
          }
        ]
      },
      {
        "id" : "Specimen.collection",
        "path" : "Specimen.collection",
        "short" : "검체 채취 정보"
      },
      {
        "id" : "Specimen.collection.bodySite",
        "path" : "Specimen.collection.bodySite",
        "short" : "채취 부위"
      },
      {
        "id" : "Specimen.collection.bodySite.coding.system",
        "path" : "Specimen.collection.bodySite.coding.system",
        "min" : 1
      },
      {
        "id" : "Specimen.collection.bodySite.coding.code",
        "path" : "Specimen.collection.bodySite.coding.code",
        "min" : 1
      }
    ]
  }
}

```
