# KR Core Practitioner Profile - KR Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **KR Core Practitioner Profile**

## Resource Profile: KR Core Practitioner Profile 

| | |
| :--- | :--- |
| *Official URL*:http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-practitioner | *Version*:2.0.0 |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | *Computable Name*:KRCore_Practitioner |

 
KR Core Practitioner Profile은 KR Core Server와 KR Core Client가 진료정보를 교류할 때 보건의료 환경에서 실질적으로 진료 과정에 참여하는 다양한 인력을 일관되게 표현하는데 사용되며, 이 경우**반드시(SHALL)**본 Profile을 준수해야 한다. 임상 행위, 진료 흐름, 환자 정보 처리, 의료 데이터 관리에 공식적으로 참여하는 모든 인력을 표현하는데 이 Profile을 적용할 수 있다. 단, 의료법에 따라 자격이 부여된 의사(Medical Doctor)를 표현하기 위해서는 본 Profile을 상속하여 정의한[KR Core Practitioner Profile for Medical Doctor](StructureDefinition-krcore-medical-doctor.md)를**반드시(SHALL)**적용해야 한다. KR Core Practitioner Profile for Medical Doctor를 만족하는 FHIR 리소스 인스턴스는 자동적으로 본 Profile을 만족한다. 
※ 주의사항 
* KR Core Practitioner Profile은 **반드시(SHALL)** 의사 외 보건의료 서비스 관련자 정보를 표현하기 위한 목적으로만 한정하여 사용한다.
 

 
보건의료 서비스 제공 과정에 직접 또는 간접적으로 관여하는 사람의 정보를 FHIR Practitioner 리소스를 기반으로 구조화하기 위해 정의한 범용 Profile. 

**Usages:**

* Derived from this Profile: [KR Core Practitioner Profile for Medical Doctor](StructureDefinition-krcore-medical-doctor.md)
* Refer to this Profile: [KR Core DiagnosticReport Profile for Diagnostic Imaging](StructureDefinition-krcore-diagnosticreport-diagnostic-imaging.md), [KR Core DiagnosticReport Profile for Functional Tests](StructureDefinition-krcore-diagnosticreport-function-tests.md), [KR Core DiagnosticReport Profile for Laboratory Results](StructureDefinition-krcore-diagnosticreport-laboratory-results.md), [KR Core DiagnosticReport Profile for Pathology Results](StructureDefinition-krcore-diagnosticreport-pathology-results.md)...Show 5 more,[KR Core Encounter Profile](StructureDefinition-krcore-encounter.md),[KR Core Observation Profile for Functional Test](StructureDefinition-krcore-observation-function-test.md),[KR Core Observation Profile for Laboratory Result](StructureDefinition-krcore-observation-laboratory-result.md),[KR Core PractitionerRole Profile](StructureDefinition-krcore-practitioner-role.md)and[KR Core Observation Profile for Vital Signs](StructureDefinition-krcore-vitalsigns.md)
* CapabilityStatements using this Profile: [KR Core Client CapabilityStatement](CapabilityStatement-krcore-capabilitystatement-client.md) and [KR Core Server CapabilityStatement](CapabilityStatement-krcore-capabilitystatement-server.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.kr.core|current/StructureDefinition/krcore-practitioner)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-krcore-practitioner.csv), [Excel](StructureDefinition-krcore-practitioner.xlsx), [Schematron](StructureDefinition-krcore-practitioner.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "krcore-practitioner",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://www.hl7korea.or.kr/fhir/krcore/ImplementationGuide/hl7.fhir.kr.core"
          }
        ]
      }
    }
  ],
  "url" : "http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-practitioner",
  "version" : "2.0.0",
  "name" : "KRCore_Practitioner",
  "title" : "KR Core Practitioner Profile",
  "status" : "active",
  "date" : "2025-08-29T13:39:02+09:00",
  "publisher" : "HL7 Korea",
  "description" : "KR Core Practitioner Profile은 KR Core Server와 KR Core Client가 진료정보를 교류할 때 보건의료 환경에서 실질적으로 진료 과정에 참여하는\n다양한 인력을 일관되게 표현하는데 사용되며, 이 경우 **반드시(SHALL)** 본 Profile을 준수해야 한다.\n임상 행위, 진료 흐름, 환자 정보 처리, 의료 데이터 관리에 공식적으로 참여하는 모든 인력을 표현하는데 이 Profile을 적용할 수 있다.\n단, 의료법에 따라 자격이 부여된 의사(Medical Doctor)를 표현하기 위해서는 본 Profile을 상속하여 정의한\n[KR Core Practitioner Profile for Medical Doctor](StructureDefinition-krcore-medical-doctor.html)를\n**반드시(SHALL)** 적용해야 한다. KR Core Practitioner Profile for Medical Doctor를 만족하는 FHIR 리소스 인스턴스는 자동적으로 본 Profile을 만족한다.\n\n\n※ 주의사항\n+ KR Core Practitioner Profile은 **반드시(SHALL)** 의사 외 보건의료 서비스 관련자 정보를 표현하기 위한 목적으로만 한정하여 사용한다.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "KR",
          "display" : "Korea, Republic of"
        }
      ]
    }
  ],
  "purpose" : "보건의료 서비스 제공 과정에 직접 또는 간접적으로 관여하는 사람의 정보를 FHIR Practitioner 리소스를 기반으로 구조화하기 위해 정의한 범용 Profile.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "servd",
      "uri" : "http://www.omg.org/spec/ServD/1.0/",
      "name" : "ServD"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Practitioner",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Practitioner",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Practitioner",
        "path" : "Practitioner",
        "short" : "KR Core Practitioner Profile"
      },
      {
        "id" : "Practitioner.identifier",
        "path" : "Practitioner.identifier",
        "short" : "보건의료 종사자 ID"
      },
      {
        "id" : "Practitioner.name",
        "path" : "Practitioner.name",
        "short" : "성명",
        "min" : 1
      },
      {
        "id" : "Practitioner.name.text",
        "path" : "Practitioner.name.text",
        "short" : "전체 성명",
        "min" : 1
      },
      {
        "id" : "Practitioner.telecom",
        "path" : "Practitioner.telecom",
        "short" : "보건의료 종사자 개인 연락처"
      },
      {
        "id" : "Practitioner.address",
        "path" : "Practitioner.address",
        "short" : "보건의료 종사자 개인 주소"
      },
      {
        "id" : "Practitioner.address.extension:krcore-roadNameAddress",
        "path" : "Practitioner.address.extension",
        "sliceName" : "krcore-roadNameAddress",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-roadNameAddress"
            ]
          }
        ]
      },
      {
        "id" : "Practitioner.address.text",
        "path" : "Practitioner.address.text",
        "short" : "주소 텍스트"
      },
      {
        "id" : "Practitioner.address.postalCode",
        "path" : "Practitioner.address.postalCode",
        "short" : "우편번호"
      },
      {
        "id" : "Practitioner.qualification",
        "path" : "Practitioner.qualification",
        "short" : "보건의료 종사자 자격증 정보"
      },
      {
        "id" : "Practitioner.qualification.identifier",
        "path" : "Practitioner.qualification.identifier",
        "short" : "보건의료 종사자 자격증 식별 정보"
      },
      {
        "id" : "Practitioner.qualification.code",
        "path" : "Practitioner.qualification.code",
        "short" : "보건의료 종사자 자격증 종류 정보"
      }
    ]
  }
}

```
