# KR Core Encounter Profile - KR Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **KR Core Encounter Profile**

## Resource Profile: KR Core Encounter Profile 

| | |
| :--- | :--- |
| *Official URL*:http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-encounter | *Version*:2.0.0 |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | *Computable Name*:KRCore_Encounter |

 
KR Core Encounter Profile은 KR Core Server와 KR Core Client가 진료정보를 교류할 때, 환자와 의사 간의 대면, 접촉, 만남, 혹은 의료 서비스 과정 전체에 대한 시간적·공간적 정보를 표현하는 데 사용되며, 이 경우**가능한 한(SHOULD)**본 Profile을 준수해야 한다. 진료 정보를 표현할 때 본 Profile을 적용하지 않을 수 있는 경우는 특수한 상황에 한정된다. 이 경우 반드시 해당 진료정보교류 도메인 내에서 사전 합의가 이루어져야 한다. 

 
**KR CDI V2 내원 정보**클래스에서 정의한 항목들과 주요 추가 정보를 FHIR Encounter 리소스를 기반으로 구조화하기 위해 정의한 Profile. 

**Usages:**

* Refer to this Profile: [KR Core Condition Profile for Chief Complaint](StructureDefinition-krcore-condition-chief-complaint.md) and [KR Core Condition Profile for Encounter Diagnosis](StructureDefinition-krcore-condition-encounter-diagnosis.md)
* CapabilityStatements using this Profile: [KR Core Client CapabilityStatement](CapabilityStatement-krcore-capabilitystatement-client.md) and [KR Core Server CapabilityStatement](CapabilityStatement-krcore-capabilitystatement-server.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.kr.core|current/StructureDefinition/krcore-encounter)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-krcore-encounter.csv), [Excel](StructureDefinition-krcore-encounter.xlsx), [Schematron](StructureDefinition-krcore-encounter.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "krcore-encounter",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://www.hl7korea.or.kr/fhir/krcore/ImplementationGuide/hl7.fhir.kr.core"
          }
        ]
      }
    }
  ],
  "url" : "http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-encounter",
  "version" : "2.0.0",
  "name" : "KRCore_Encounter",
  "title" : "KR Core Encounter Profile",
  "status" : "active",
  "date" : "2025-08-29T13:39:02+09:00",
  "publisher" : "HL7 Korea",
  "description" : "KR Core Encounter Profile은 KR Core Server와 KR Core Client가 진료정보를 교류할 때, 환자와 의사 간의 대면, 접촉, 만남, 혹은 의료 서비스 과정 전체에 대한 시간적·공간적 정보를 표현하는 데 사용되며, 이 경우 **가능한 한(SHOULD)** 본 Profile을 준수해야 한다.\n진료 정보를 표현할 때 본 Profile을 적용하지 않을 수 있는 경우는 특수한 상황에 한정된다. 이 경우 반드시 해당 진료정보교류 도메인 내에서 사전 합의가 이루어져야 한다.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "KR",
          "display" : "Korea, Republic of"
        }
      ]
    }
  ],
  "purpose" : "**KR CDI V2 내원 정보** 클래스에서 정의한 항목들과 주요 추가 정보를 FHIR Encounter 리소스를 기반으로 구조화하기 위해 정의한 Profile.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Encounter",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Encounter",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Encounter",
        "path" : "Encounter",
        "short" : "KR Core Encounter Profile"
      },
      {
        "id" : "Encounter.extension",
        "path" : "Encounter.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Encounter.extension:krcore-insuranceTypes",
        "path" : "Encounter.extension",
        "sliceName" : "krcore-insuranceTypes",
        "alias" : ["KRCDI: 건강보험유형", "user content"],
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-insuranceTypes"
            ]
          }
        ]
      },
      {
        "id" : "Encounter.status",
        "path" : "Encounter.status",
        "short" : "진료 상태: planned | arrived | triaged | in-progress | onleave | finished | cancelled +",
        "alias" : ["KRCDI: 내원 상태"],
        "example" : [
          {
            "label" : "Value (Preferred)",
            "valueCode" : "finished"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Encounter.class",
        "path" : "Encounter.class",
        "short" : "진료 구분: AMB | EMER | IMP +",
        "alias" : ["KRCDI: 진료 구분"],
        "mustSupport" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "EncounterClass"
            }
          ],
          "strength" : "required",
          "description" : "Classification of the encounter.",
          "valueSet" : "http://terminology.hl7.org/ValueSet/v3-ActEncounterCode"
        }
      },
      {
        "id" : "Encounter.class.system",
        "path" : "Encounter.class.system",
        "short" : "진료 구분 코드체계 식별자",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Encounter.class.code",
        "path" : "Encounter.class.code",
        "short" : "진료 구분 코드",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Encounter.subject",
        "path" : "Encounter.subject",
        "short" : "진료 대상 환자",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-patient"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Encounter.participant",
        "path" : "Encounter.participant",
        "short" : "진료 참여 의료인"
      },
      {
        "id" : "Encounter.participant.individual",
        "path" : "Encounter.participant.individual",
        "short" : "진료 참여 의료인 인적사항 또는 역할",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-medical-doctor",
              "http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-practitioner",
              "http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-medical-doctor-role",
              "http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-practitioner-role",
              "http://hl7.org/fhir/StructureDefinition/RelatedPerson"
            ]
          }
        ]
      },
      {
        "id" : "Encounter.period",
        "path" : "Encounter.period",
        "short" : "진료 기간",
        "alias" : ["KRCDI: 내원 기간"],
        "mustSupport" : true
      },
      {
        "id" : "Encounter.period.start",
        "path" : "Encounter.period.start",
        "short" : "시작 일시",
        "alias" : ["KRCDI: 시작 일자"],
        "mustSupport" : true
      },
      {
        "id" : "Encounter.period.end",
        "path" : "Encounter.period.end",
        "short" : "종료 일시",
        "alias" : ["KRCDI: 종료 일자"],
        "mustSupport" : true
      },
      {
        "id" : "Encounter.serviceProvider",
        "path" : "Encounter.serviceProvider",
        "short" : "진료 기관",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-healthcare-organization",
              "http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-organization"
            ]
          }
        ]
      }
    ]
  }
}

```
