# KR Core DiagnosticReport Profile for Pathology Results - KR Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **KR Core DiagnosticReport Profile for Pathology Results**

## Resource Profile: KR Core DiagnosticReport Profile for Pathology Results 

| | |
| :--- | :--- |
| *Official URL*:http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-diagnosticreport-pathology-results | *Version*:2.0.0 |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | *Computable Name*:KRCore_DiagnosticReport_PathologyResults |

 
KR Core DiagnosticReport Profile for Pathology Results는 KR Core Server와 KR Core Client가 진료정보를 교류할 때 병리검사 정보를 표현하는 데 사용되며, 이 경우**가능한 한(SHOULD)**본 Profile을 준수해야 한다. 병리검사 정보를 표현할 때 본 Profile을 적용하지 않을 수 있는 경우는 특수한 상황에 한정된다. 이 경우 반드시 해당 진료정보교류 도메인 내에서 사전 합의가 이루어져야 한다. 

 
**KR CDI V2 병리검사**클래스에서 정의한 항목들과 주요 추가 정보를 구조화하기 위해 정의한 Profile. 

**Usages:**

* CapabilityStatements using this Profile: [KR Core Client CapabilityStatement](CapabilityStatement-krcore-capabilitystatement-client.md) and [KR Core Server CapabilityStatement](CapabilityStatement-krcore-capabilitystatement-server.md)
* This Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.kr.core|current/StructureDefinition/krcore-diagnosticreport-pathology-results)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-krcore-diagnosticreport-pathology-results.csv), [Excel](StructureDefinition-krcore-diagnosticreport-pathology-results.xlsx), [Schematron](StructureDefinition-krcore-diagnosticreport-pathology-results.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "krcore-diagnosticreport-pathology-results",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://www.hl7korea.or.kr/fhir/krcore/ImplementationGuide/hl7.fhir.kr.core"
          }
        ]
      }
    }
  ],
  "url" : "http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-diagnosticreport-pathology-results",
  "version" : "2.0.0",
  "name" : "KRCore_DiagnosticReport_PathologyResults",
  "title" : "KR Core DiagnosticReport Profile for Pathology Results",
  "status" : "active",
  "date" : "2025-08-29T13:39:02+09:00",
  "publisher" : "HL7 Korea",
  "description" : "KR Core DiagnosticReport Profile for Pathology Results는 KR Core Server와 KR Core Client가 진료정보를 교류할 때 병리검사 정보를 표현하는 데 사용되며, 이 경우 **가능한 한(SHOULD)** 본 Profile을 준수해야 한다.\n병리검사 정보를 표현할 때 본 Profile을 적용하지 않을 수 있는 경우는 특수한 상황에 한정된다. 이 경우 반드시 해당 진료정보교류 도메인 내에서 사전 합의가 이루어져야 한다.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "KR",
          "display" : "Korea, Republic of"
        }
      ]
    }
  ],
  "purpose" : "**KR CDI V2 병리검사** 클래스에서 정의한 항목들과 주요 추가 정보를 구조화하기 위해 정의한 Profile.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "DiagnosticReport",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/DiagnosticReport",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "DiagnosticReport",
        "path" : "DiagnosticReport",
        "short" : "KR Core DiagnosticReport Profile for Pathology Results"
      },
      {
        "id" : "DiagnosticReport.extension",
        "path" : "DiagnosticReport.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "DiagnosticReport.extension:krcore-testRequestDateTime",
        "path" : "DiagnosticReport.extension",
        "sliceName" : "krcore-testRequestDateTime",
        "short" : "병리검사 의뢰일",
        "alias" : ["KRCDI: 병리검사 의뢰일", "user content"],
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-testRequestDateTime"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "DiagnosticReport.status",
        "path" : "DiagnosticReport.status",
        "short" : "병리검사 보고서 상태: registered | partial | preliminary | final +",
        "alias" : ["KRCDI: 병리검사 상태"],
        "example" : [
          {
            "label" : "Value (Preferred)",
            "valueCode" : "final"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "DiagnosticReport.category",
        "path" : "DiagnosticReport.category",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "$this"
            }
          ],
          "rules" : "open"
        },
        "short" : "진단보고서 범주",
        "min" : 1,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "DiagnosticServiceSection"
            }
          ],
          "strength" : "extensible",
          "description" : "Codes for diagnostic service sections.",
          "valueSet" : "http://hl7.org/fhir/ValueSet/diagnostic-service-sections"
        }
      },
      {
        "id" : "DiagnosticReport.category:Pathology",
        "path" : "DiagnosticReport.category",
        "sliceName" : "Pathology",
        "min" : 1,
        "max" : "1",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
              "code" : "PAT"
            }
          ]
        }
      },
      {
        "id" : "DiagnosticReport.code",
        "path" : "DiagnosticReport.code",
        "short" : "병리검사 보고서 항목 정보",
        "alias" : ["KRCDI: 병리검사명"],
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://www.hl7korea.or.kr/fhir/krcore/ValueSet/krcore-pathology-codes"
        }
      },
      {
        "id" : "DiagnosticReport.code.coding.system",
        "path" : "DiagnosticReport.code.coding.system",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "DiagnosticReport.code.coding.code",
        "path" : "DiagnosticReport.code.coding.code",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "DiagnosticReport.subject",
        "path" : "DiagnosticReport.subject",
        "short" : "병리검사 대상 환자",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-patient"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "DiagnosticReport.issued",
        "path" : "DiagnosticReport.issued",
        "short" : "병리검사 결과 보고서 발행 일시"
      },
      {
        "id" : "DiagnosticReport.performer",
        "path" : "DiagnosticReport.performer",
        "short" : "병리검사 결과 보고 책임자",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-practitioner",
              "http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-practitioner-role",
              "http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-organization",
              "http://hl7.org/fhir/StructureDefinition/CareTeam"
            ]
          }
        ]
      },
      {
        "id" : "DiagnosticReport.specimen",
        "path" : "DiagnosticReport.specimen",
        "short" : "검체 정보 참조",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-specimen"
            ]
          }
        ]
      },
      {
        "id" : "DiagnosticReport.result",
        "path" : "DiagnosticReport.result",
        "short" : "병리검사 결과 정보 참조",
        "alias" : [
          "KRCDI: 병리검사 결과",
          "Atomic Value",
          "Result",
          "Atomic result",
          "Data",
          "Test",
          "Analyte",
          "Battery",
          "Organizer"
        ],
        "mustSupport" : true
      },
      {
        "id" : "DiagnosticReport.conclusion",
        "path" : "DiagnosticReport.conclusion",
        "short" : "병리검사 결과 판독 소견"
      },
      {
        "id" : "DiagnosticReport.conclusionCode",
        "path" : "DiagnosticReport.conclusionCode",
        "short" : "코드화된 병리검사 결과 판독 소견"
      }
    ]
  }
}

```
