# KR Core Observation Profile for Vital Signs: Blood Pressure - KR Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **KR Core Observation Profile for Vital Signs: Blood Pressure**

## Resource Profile: KR Core Observation Profile for Vital Signs: Blood Pressure 

| | |
| :--- | :--- |
| *Official URL*:http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-bloodpressure | *Version*:2.0.0 |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | *Computable Name*:KRCore_Observation_VitalSigns_BloodPressure |

 
본 Profile은 환자를 대상으로 측정한 수축기 혈압 및 이완기 혈압을 표현하기 위해[KR Core Observation Profile for Vital Signs](StructureDefinition-krcore-vitalsigns.md)를 상속하여 정의하였으며, 본 Profile을 만족하는 FHIR 리소스 인스턴스는 자동적으로 KR Core Observation Profile for Vital Signs를 만족한다. 
※ 주의사항 
* KR Core Observation Profile for Vital Signs는 **반드시(SHALL)** 수축기 혈압 및 이완기 혈압, 키, 체온, 몸무게, 맥박수, 산소포화도, 호흡수 외 활력징후 및 신체 계측 정보를 표현하기 위한 목적으로만 한정하여 사용한다.
 

 
**KR CDI V2 활력 징후 및 신체 계측 정보**클래스에서 정의한`수축기 혈압`,`이완기 혈압`항목과 주요 추가 정보를 구조화하기 위해 정의한 Profile. 

**Usages:**

* CapabilityStatements using this Profile: [KR Core Client CapabilityStatement](CapabilityStatement-krcore-capabilitystatement-client.md) and [KR Core Server CapabilityStatement](CapabilityStatement-krcore-capabilitystatement-server.md)
* This Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.kr.core|current/StructureDefinition/krcore-bloodpressure)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-krcore-bloodpressure.csv), [Excel](StructureDefinition-krcore-bloodpressure.xlsx), [Schematron](StructureDefinition-krcore-bloodpressure.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "krcore-bloodpressure",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://www.hl7korea.or.kr/fhir/krcore/ImplementationGuide/hl7.fhir.kr.core"
          }
        ]
      }
    }
  ],
  "url" : "http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-bloodpressure",
  "version" : "2.0.0",
  "name" : "KRCore_Observation_VitalSigns_BloodPressure",
  "title" : "KR Core Observation Profile for Vital Signs: Blood Pressure",
  "status" : "active",
  "date" : "2025-08-29T13:39:02+09:00",
  "publisher" : "HL7 Korea",
  "description" : "본 Profile은 환자를 대상으로 측정한 수축기 혈압 및 이완기 혈압을 표현하기 위해 [KR Core Observation Profile for Vital Signs](StructureDefinition-krcore-vitalsigns.html)를\n상속하여 정의하였으며, 본 Profile을 만족하는 FHIR 리소스 인스턴스는 자동적으로 KR Core Observation Profile for Vital Signs를 만족한다.\n\n\n※ 주의사항\n+ KR Core Observation Profile for Vital Signs는 **반드시(SHALL)** 수축기 혈압 및 이완기 혈압, 키, 체온, 몸무게, 맥박수, 산소포화도, 호흡수 외 활력징후 및 신체 계측 정보를 표현하기 위한 목적으로만 한정하여 사용한다.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "KR",
          "display" : "Korea, Republic of"
        }
      ]
    }
  ],
  "purpose" : "**KR CDI V2 활력 징후 및 신체 계측 정보** 클래스에서 정의한 `수축기 혈압`, `이완기 혈압` 항목과 주요 추가 정보를 구조화하기 위해 정의한 Profile.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "sct-concept",
      "uri" : "http://snomed.info/conceptdomain",
      "name" : "SNOMED CT Concept Domain Binding"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "sct-attr",
      "uri" : "http://snomed.org/attributebinding",
      "name" : "SNOMED CT Attribute Binding"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Observation",
  "baseDefinition" : "http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-vitalsigns",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Observation",
        "path" : "Observation",
        "short" : "KR Core Observation Profile for Vital Signs: Blood Pressure",
        "constraint" : [
          {
            "key" : "krcore-obs-02",
            "requirements" : "KR Core 권장사항",
            "severity" : "warning",
            "human" : "component.value 또는 component.dataAbsentReason 중 하나는 제공할 것.",
            "expression" : "component.value.exists() or component.dataAbsentReason.exists()",
            "source" : "http://www.hl7korea.or.kr/fhir/krcore/StructureDefinition/krcore-bloodpressure"
          }
        ]
      },
      {
        "id" : "Observation.code",
        "path" : "Observation.code",
        "mustSupport" : true
      },
      {
        "id" : "Observation.code.coding:LOINC",
        "path" : "Observation.code.coding",
        "sliceName" : "LOINC",
        "short" : "혈압 측정"
      },
      {
        "id" : "Observation.code.coding:LOINC.system",
        "path" : "Observation.code.coding.system",
        "mustSupport" : true
      },
      {
        "id" : "Observation.code.coding:LOINC.code",
        "path" : "Observation.code.coding.code",
        "fixedCode" : "85354-9",
        "mustSupport" : true
      },
      {
        "id" : "Observation.code.coding:LOINC.display",
        "path" : "Observation.code.coding.display",
        "example" : [
          {
            "label" : "Value (Preferred)",
            "valueString" : "Blood pressure panel with all children optional"
          }
        ]
      },
      {
        "id" : "Observation.component",
        "path" : "Observation.component",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "code.coding.code"
            }
          ],
          "rules" : "open"
        }
      },
      {
        "id" : "Observation.component:Systolic",
        "path" : "Observation.component",
        "sliceName" : "Systolic",
        "short" : "수축기 혈압 측정 정보",
        "alias" : ["KRCDI: 수축기 혈압"],
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:Systolic.code.coding:LOINC",
        "path" : "Observation.component.code.coding",
        "sliceName" : "LOINC",
        "short" : "수축기 혈압 측정"
      },
      {
        "id" : "Observation.component:Systolic.code.coding:LOINC.system",
        "path" : "Observation.component.code.coding.system",
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:Systolic.code.coding:LOINC.code",
        "path" : "Observation.component.code.coding.code",
        "fixedCode" : "8480-6",
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:Systolic.code.coding:LOINC.display",
        "path" : "Observation.component.code.coding.display",
        "example" : [
          {
            "label" : "Value (Preferred)",
            "valueString" : "Systolic blood pressure"
          }
        ]
      },
      {
        "id" : "Observation.component:Systolic.value[x]",
        "path" : "Observation.component.value[x]",
        "short" : "수축기 혈압 측정 결과",
        "type" : [
          {
            "code" : "Quantity"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:Systolic.value[x].value",
        "path" : "Observation.component.value[x].value",
        "short" : "측정값",
        "min" : 1
      },
      {
        "id" : "Observation.component:Systolic.value[x].unit",
        "path" : "Observation.component.value[x].unit",
        "example" : [
          {
            "label" : "Value (Preferred)",
            "valueString" : "mmHg"
          }
        ]
      },
      {
        "id" : "Observation.component:Systolic.value[x].system",
        "path" : "Observation.component.value[x].system",
        "min" : 1,
        "fixedUri" : "http://unitsofmeasure.org"
      },
      {
        "id" : "Observation.component:Systolic.value[x].code",
        "path" : "Observation.component.value[x].code",
        "min" : 1,
        "fixedCode" : "mm[Hg]"
      },
      {
        "id" : "Observation.component:Diastolic",
        "path" : "Observation.component",
        "sliceName" : "Diastolic",
        "short" : "이완기 혈압 측정 정보",
        "alias" : ["KRCDI: 이완기 혈압"],
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:Diastolic.code.coding:LOINC",
        "path" : "Observation.component.code.coding",
        "sliceName" : "LOINC",
        "short" : "이완기 혈압 측정"
      },
      {
        "id" : "Observation.component:Diastolic.code.coding:LOINC.system",
        "path" : "Observation.component.code.coding.system",
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:Diastolic.code.coding:LOINC.code",
        "path" : "Observation.component.code.coding.code",
        "fixedCode" : "8462-4",
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:Diastolic.code.coding:LOINC.display",
        "path" : "Observation.component.code.coding.display",
        "example" : [
          {
            "label" : "Value (Preferred)",
            "valueString" : "Diastolic blood pressure"
          }
        ]
      },
      {
        "id" : "Observation.component:Diastolic.value[x]",
        "path" : "Observation.component.value[x]",
        "short" : "이완기 혈압 측정 결과",
        "type" : [
          {
            "code" : "Quantity"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:Diastolic.value[x].value",
        "path" : "Observation.component.value[x].value",
        "short" : "측정값",
        "min" : 1
      },
      {
        "id" : "Observation.component:Diastolic.value[x].unit",
        "path" : "Observation.component.value[x].unit",
        "example" : [
          {
            "label" : "Value (Preferred)",
            "valueString" : "mmHg"
          }
        ]
      },
      {
        "id" : "Observation.component:Diastolic.value[x].system",
        "path" : "Observation.component.value[x].system",
        "min" : 1,
        "fixedUri" : "http://unitsofmeasure.org"
      },
      {
        "id" : "Observation.component:Diastolic.value[x].code",
        "path" : "Observation.component.value[x].code",
        "min" : 1,
        "fixedCode" : "mm[Hg]"
      }
    ]
  }
}

```
