# krcore-sp-allergyintolerance-onset - KR Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **krcore-sp-allergyintolerance-onset**

## SearchParameter: krcore-sp-allergyintolerance-onset 

| | |
| :--- | :--- |
| *Official URL*:http://www.hl7korea.or.kr/fhir/krcore/SearchParameter/krcore-sp-allergyintolerance-onset | *Version*:2.0.0 |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | *Computable Name*:KRCoreSearchParameterAllergyIntoleranceOnset |

 
알레르기 및 불내성 발생일 또는 개별 증상 발생일 



## Resource Content

```json
{
  "resourceType" : "SearchParameter",
  "id" : "krcore-sp-allergyintolerance-onset",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
      "valueCode" : "MAY"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/note",
      "valueAnnotation" : {
        "text" : "KR Core Client는 **반드시(SHALL)** *second* + *time offset* 수준의 정확도를 가지는 값을 제공해야 한다. KR Core Server는 **반드시(SHALL)** *second* + *time offset* 수준의 정확도를 가지는 값을 지원해야 한다."
      }
    }
  ],
  "url" : "http://www.hl7korea.or.kr/fhir/krcore/SearchParameter/krcore-sp-allergyintolerance-onset",
  "version" : "2.0.0",
  "name" : "KRCoreSearchParameterAllergyIntoleranceOnset",
  "derivedFrom" : "http://hl7.org/fhir/SearchParameter/AllergyIntolerance-onset",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-08-29T13:39:02+09:00",
  "publisher" : "HL7 Korea",
  "description" : "알레르기 및 불내성 발생일 또는 개별 증상 발생일",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "KR",
          "display" : "Korea, Republic of"
        }
      ]
    }
  ],
  "code" : "onset",
  "base" : ["AllergyIntolerance"],
  "type" : "date",
  "expression" : "AllergyIntolerance.onset.ofType(dateTime) | AllergyIntolerance.reaction.onset",
  "multipleOr" : true,
  "_multipleOr" : {
    "extension" : [
      {
        "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
        "valueCode" : "MAY"
      }
    ]
  },
  "multipleAnd" : true,
  "_multipleAnd" : {
    "extension" : [
      {
        "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
        "valueCode" : "MAY"
      }
    ]
  },
  "comparator" : [
    "eq",
    "ne",
    "gt",
    "ge",
    "lt",
    "le",
    "sa",
    "eb",
    "ap"
  ],
  "_comparator" : [
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
          "valueCode" : "MAY"
        }
      ]
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
          "valueCode" : "MAY"
        }
      ]
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
          "valueCode" : "MAY"
        }
      ]
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
          "valueCode" : "MAY"
        }
      ]
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
          "valueCode" : "MAY"
        }
      ]
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
          "valueCode" : "MAY"
        }
      ]
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
          "valueCode" : "MAY"
        }
      ]
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
          "valueCode" : "MAY"
        }
      ]
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
          "valueCode" : "MAY"
        }
      ]
    }
  ]
}

```
