# hl7.fhir.it.base#0.1.1: HL7 Italia FHIR Implementation Guide (base)

## Pages

* [IG Home Page](index.md)
* [IG Change History](changes.md)
* [Metodologia](methodology.md)
* [Principi e disegno](design.md)
* [Copyright](copyright.md)
* [Detailed Specification](spec.md)
* [Useful Downloads](downloads.md)
* [Background](background.md)
* [Artifacts Summary](artifacts.md)

## Resources

### Logicals

* [Azienda Sanitaria](StructureDefinition-AziendaSanitaria.md)
* [Persona di Contatto](StructureDefinition-ContattoPersona.md)
* [Documento di Identificazione](StructureDefinition-DocumentoIdentificazione.md)
* [EHIC (TEAM)](StructureDefinition-EHIC.md)
* [Esenzione](StructureDefinition-Esenzione.md)
* [Indirizzo](StructureDefinition-Indirizzo.md)
* [Medico Curante](StructureDefinition-MedicoCurante.md)
* [Paziente](StructureDefinition-Paziente.md)

### Complex-type Profiles

* [Address - base](StructureDefinition-Address-it-base.md)
* [Money - base](StructureDefinition-Money-it-base.md)

### Resource Profiles

* [Coverage - base](StructureDefinition-Coverage-it-base.md)
* [Organization - base](StructureDefinition-Organization-it-base.md)
* [Organization - Operatore sanitario/socio sanitario](StructureDefinition-Organization-it-hcp.md)
* [Patient - base](StructureDefinition-Patient-it-base.md)
* [Practitioner - base](StructureDefinition-Practitioner-it-base.md)
* [PractitionerRole - base](StructureDefinition-PractitionerRole-it-base.md)
* [PractitionerRole - MMG/PLS](StructureDefinition-PractitionerRole-it-mmg.md)

### Extensions

* [DUG (Denominazione Urbanistica Generica)](StructureDefinition-address-dug.md)
* [Official Address](StructureDefinition-address-official.md)
* [Stato Esenzione](StructureDefinition-coverage-exceptionStatus.md)
* [Codice comune e/o stato di nascita](StructureDefinition-patient-codeableBirthPlace.md)
* [Professione del paziente](StructureDefinition-patient-occupation-it.md)
* [Titolo di Studio del paziente](StructureDefinition-patient-qualification-it.md)
* [Certificazione](StructureDefinition-recordCertification.md)

### ImplementationGuides

* [HL7 Italia FHIR Implementation Guide (base)](index.md)

### Examples

* [EsempioEsenzione (Coverage)](Coverage-EsempioEsenzione.md)
* [AZIENDA U.S.L. VALLE D'AOSTA (Organization)](Organization-asl-020101.md)
* [Fantastica Azienda (Organization)](Organization-nice-org.md)
* [Patient-STP-soloTesto (Patient)](Patient-Patient-STP-soloTesto.md)
* [Patient-birthPlace-opt2 (Patient)](Patient-Patient-birthPlace-opt2.md)
* [es-trad (Patient)](Patient-es-trad.md)
* [esempio-CF-residenza (Patient)](Patient-esempio-CF-residenza.md)
* [esempio-professione (Patient)](Patient-esempio-professione.md)
* [PractitionerExample (Practitioner)](Practitioner-PractitionerExample.md)
* [PractitionerMMGExample (Practitioner)](Practitioner-PractitionerMMGExample.md)
* [PractitionerRoleExample (PractitionerRole)](PractitionerRole-PractitionerRoleExample.md)
* [PractitionerRoleMMGExample (PractitionerRole)](PractitionerRole-PractitionerRoleMMGExample.md)
