# Stato Esenzione - HL7 Italia FHIR Implementation Guide (base) v0.1.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Stato Esenzione**

## Extension: Stato Esenzione 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.it/fhir/StructureDefinition/coverage-exceptionStatus | *Version*:0.1.1 |
| Draft as of 2025-11-18 | *Computable Name*:StatoEsenzioneCoverage |

Estensione per gestire lo stato di una esenzione

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [Coverage - base](StructureDefinition-Coverage-it-base.md)
* Examples for this Extension: [Coverage/EsempioEsenzione](Coverage-EsempioEsenzione.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.it.base|current/StructureDefinition/coverage-exceptionStatus)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-coverage-exceptionStatus.csv), [Excel](StructureDefinition-coverage-exceptionStatus.xlsx), [Schematron](StructureDefinition-coverage-exceptionStatus.sch) 

#### Terminology Bindings

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "coverage-exceptionStatus",
  "url" : "http://hl7.it/fhir/StructureDefinition/coverage-exceptionStatus",
  "version" : "0.1.1",
  "name" : "StatoEsenzioneCoverage",
  "title" : "Stato Esenzione",
  "status" : "draft",
  "date" : "2025-11-18T14:18:52+00:00",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.it"
        }
      ]
    }
  ],
  "description" : "Estensione per gestire lo stato di una esenzione",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "Element"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "Stato Esenzione",
        "definition" : "Estensione per gestire lo stato di una esenzione"
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "http://hl7.it/fhir/StructureDefinition/coverage-exceptionStatus"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://terminology.fhir.it/ValueSet/statoEsenzione"
        }
      }
    ]
  }
}

```
