# PractitionerRole - base - HL7 Italia FHIR Implementation Guide (base) v0.1.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **PractitionerRole - base**

## Resource Profile: PractitionerRole - base 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.it/fhir/StructureDefinition/PractitionerRole-it-base | *Version*:0.1.1 |
| Draft as of 2025-11-18 | *Computable Name*:PractitionerRoleItBase |

 
Profilo base generico per PractitionerRole 

**Usages:**

* Derived from this Profile: [PractitionerRole - MMG/PLS](StructureDefinition-PractitionerRole-it-mmg.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.it.base|current/StructureDefinition/PractitionerRole-it-base)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-PractitionerRole-it-base.csv), [Excel](StructureDefinition-PractitionerRole-it-base.xlsx), [Schematron](StructureDefinition-PractitionerRole-it-base.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "PractitionerRole-it-base",
  "url" : "http://hl7.it/fhir/StructureDefinition/PractitionerRole-it-base",
  "version" : "0.1.1",
  "name" : "PractitionerRoleItBase",
  "title" : "PractitionerRole - base",
  "status" : "draft",
  "date" : "2025-11-18T14:18:52+00:00",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.it"
        }
      ]
    }
  ],
  "description" : "Profilo base generico per PractitionerRole",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "servd",
      "uri" : "http://www.omg.org/spec/ServD/1.0/",
      "name" : "ServD"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "PractitionerRole",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/PractitionerRole",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "PractitionerRole",
        "path" : "PractitionerRole"
      },
      {
        "id" : "PractitionerRole.identifier",
        "path" : "PractitionerRole.identifier",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "pattern",
              "path" : "$this"
            }
          ],
          "description" : "Slice based on the identifier pattern",
          "rules" : "open"
        },
        "short" : "Identificativo dell'operatore (e.g. Codice Fiscale, ID Regionale)",
        "mustSupport" : true
      },
      {
        "id" : "PractitionerRole.identifier:codiceFiscale",
        "path" : "PractitionerRole.identifier",
        "sliceName" : "codiceFiscale",
        "min" : 0,
        "max" : "1",
        "patternIdentifier" : {
          "system" : "http://hl7.it/sid/codiceFiscale"
        },
        "mustSupport" : true
      },
      {
        "id" : "PractitionerRole.period",
        "path" : "PractitionerRole.period",
        "mustSupport" : true
      },
      {
        "id" : "PractitionerRole.practitioner",
        "path" : "PractitionerRole.practitioner",
        "short" : "Dettagli dell'operatore",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.it/fhir/StructureDefinition/Practitioner-it-base"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "PractitionerRole.organization",
        "path" : "PractitionerRole.organization",
        "short" : "Organizzazione di Appartenenza",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.it/fhir/StructureDefinition/Organization-it-base"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "PractitionerRole.code",
        "path" : "PractitionerRole.code",
        "mustSupport" : true
      }
    ]
  }
}

```
