# Patient - base - HL7 Italia FHIR Implementation Guide (base) v0.1.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Patient - base**

## Resource Profile: Patient - base ( Experimental ) 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.it/fhir/StructureDefinition/Patient-it-base | *Version*:0.1.1 |
| Draft as of 2018-03-20 | *Computable Name*:PatientItBase |

 
Profilo base generico per Patient: descrive come rappresentare in FHIR alcune informazioni tipiche per il contesto Italiano. 

> **Rappresentazione del codice comune/stato di nascita**
Questa versione del profilo include diverse opzioni di rappresentazione del codice comune/stato di nascita, descritte nella[pagina confluence](https://confluence.hl7.org/pages/viewpage.action?pageId=76162969#ITbaseIG-Codificacomune/statodinascita)
I lettori sono invitati a valutare queste opzioni e suggerire quali di opzioni è la più adeguata.

**Usages:**

* This Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.it.base|current/StructureDefinition/Patient-it-base)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Patient-it-base.csv), [Excel](StructureDefinition-Patient-it-base.xlsx), [Schematron](StructureDefinition-Patient-it-base.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Patient-it-base",
  "url" : "http://hl7.it/fhir/StructureDefinition/Patient-it-base",
  "version" : "0.1.1",
  "name" : "PatientItBase",
  "title" : "Patient - base",
  "status" : "draft",
  "experimental" : true,
  "date" : "2018-03-20T16:43:56.519+01:00",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.it"
        }
      ]
    }
  ],
  "description" : "Profilo base generico per Patient: descrive come rappresentare in FHIR alcune informazioni tipiche per il contesto Italiano.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "loinc",
      "uri" : "http://loinc.org",
      "name" : "LOINC code for the element"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Patient",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Patient",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Patient",
        "path" : "Patient",
        "mustSupport" : true
      },
      {
        "id" : "Patient.extension:certificazione",
        "path" : "Patient.extension",
        "sliceName" : "certificazione",
        "short" : "Indica che i dati presenti nella risorsa sono stati certificati da uno specifico entità",
        "definition" : "Indica che i dati presenti nella risorsa (non quelli referenziati) sono stati certificati da uno specifico entità",
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["http://hl7.it/fhir/StructureDefinition/recordCertification"]
          }
        ]
      },
      {
        "id" : "Patient.extension:luogoNascita",
        "path" : "Patient.extension",
        "sliceName" : "luogoNascita",
        "short" : "Indica il luogo di nascita. Tipicamente attraverso il codice comune o stato di nascita",
        "definition" : "Luogo di Nascita del paziente. In base al contesto può includere informazioni testuali e/o codificate, in forma strutturata o non strutturata. Tipicamente attraverso il codice comune o stato di nascita.",
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/patient-birthPlace"]
          }
        ]
      },
      {
        "id" : "Patient.extension:luogoNascita.valueAddress",
        "path" : "Patient.extension.valueAddress",
        "short" : "Indirizzo del luogo di Nascita",
        "definition" : "Indirizzo del luogo di Nascita",
        "type" : [
          {
            "code" : "Address",
            "profile" : ["http://hl7.it/fhir/StructureDefinition/Address-it-base"]
          }
        ]
      },
      {
        "id" : "Patient.extension:luogoNascitaCodeable",
        "path" : "Patient.extension",
        "sliceName" : "luogoNascitaCodeable",
        "short" : "Codice del comune e/o dello stato di nascita",
        "definition" : "Codice del comune e/o dello stato di nascita del paziente. In via eccezionle, può essere usato per indicare comune e/o stato di nascita in forma testuale",
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.it/fhir/StructureDefinition/patient-codeableBirthPlace"
            ]
          }
        ],
        "binding" : {
          "strength" : "example",
          "valueSet" : "http://terminology.hl7.it/ValueSet/istat-luogoNascita"
        }
      },
      {
        "id" : "Patient.extension:cittadinanza",
        "path" : "Patient.extension",
        "sliceName" : "cittadinanza",
        "short" : "Cittadinanza",
        "definition" : "Indica la cittadinanza del cittadino attraverso lo stato di provenienza",
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/StructureDefinition/patient-citizenship"
            ]
          }
        ],
        "binding" : {
          "strength" : "example",
          "valueSet" : "http://terminology.hl7.it/ValueSet/istat-cittadinanza"
        }
      },
      {
        "id" : "Patient.extension:professione",
        "path" : "Patient.extension",
        "sliceName" : "professione",
        "short" : "Professione",
        "definition" : "Indica la professione del cittadino come semplice CodeableConcept",
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.it/fhir/StructureDefinition/patient-occupation-it"
            ]
          }
        ],
        "mustSupport" : false,
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://terminology.hl7.it/ValueSet/istat-professione"
        }
      },
      {
        "id" : "Patient.extension:titoloStudio",
        "path" : "Patient.extension",
        "sliceName" : "titoloStudio",
        "short" : "Titolo di studio",
        "definition" : "Indica il titolo di studio del cittadino come semplice CodeableConcept",
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.it/fhir/StructureDefinition/patient-qualification-it"
            ]
          }
        ],
        "mustSupport" : false,
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://terminology.hl7.it/ValueSet/istat-titoloStudio"
        }
      },
      {
        "id" : "Patient.identifier",
        "path" : "Patient.identifier",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "$this.system"
            }
          ],
          "rules" : "open"
        },
        "short" : "Identificativo del paziente",
        "definition" : "Identificativo del paziente. \r\n Lo slicing specificato per questo element è di tipo open; questo significa che sono ammessi identificativi che non rispettano le regole definite per le sice specificate.  \r\n Esempi di possibili sistemi di identificazione sono elencati in https://confluence.hl7.org/display/HI/Identificatori",
        "mustSupport" : true
      },
      {
        "id" : "Patient.identifier.extension:certificazioneId",
        "path" : "Patient.identifier.extension",
        "sliceName" : "certificazioneId",
        "short" : "Identificativo certificato (tipicamente per CF)",
        "definition" : "Indica che questo identificativo è stato certificato. Usato tipicamente per il Codice Fiscale.",
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["http://hl7.it/fhir/StructureDefinition/recordCertification"]
          }
        ]
      },
      {
        "id" : "Patient.identifier.type",
        "path" : "Patient.identifier.type",
        "mustSupport" : false,
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://terminology.hl7.it/ValueSet/tipoIdentificatore"
        }
      },
      {
        "id" : "Patient.identifier.value",
        "path" : "Patient.identifier.value",
        "short" : "ID del paziente (e.g. Codice Fiscale)",
        "definition" : "Identifictivo del paziente",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Patient.identifier:codiceFiscale",
        "path" : "Patient.identifier",
        "sliceName" : "codiceFiscale",
        "mustSupport" : true
      },
      {
        "id" : "Patient.identifier:codiceFiscale.system",
        "path" : "Patient.identifier.system",
        "min" : 1,
        "fixedUri" : "http://hl7.it/sid/codiceFiscale",
        "mustSupport" : true
      },
      {
        "id" : "Patient.identifier:codiceFiscale.value",
        "path" : "Patient.identifier.value",
        "min" : 1,
        "constraint" : [
          {
            "key" : "pat-id-cf-1",
            "severity" : "error",
            "human" : "Il Codice Fiscale deve essere di 16 caratteri alfanumerici (3 per il cognome; 3 per il nome; 2 caratteri numerici per l'anno di nascita; 1 per il mese di nascita; 2 caratteri numerici per il giorno di nascita ed il sesso; 4 associati al Comune oppure allo Stato estero di nascita. 1 carattere di controllo",
            "expression" : "matches('^[A-Za-z]{6}[0-9LMNPQRSTUV]{2}[A-Za-z]{1}[0-9LMNPQRSTUV]{2}[A-Za-z]{1}[0-9LMNPQRSTUV]{3}[A-Za-z]{1}$')",
            "xpath" : "matches(@value,'^[A-Za-z]{6}[0-9LMNPQRSTUV]{2}[A-Za-z]{1}[0-9LMNPQRSTUV]{2}[A-Za-z]{1}[0-9LMNPQRSTUV]{3}[A-Za-z]{1}$')"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Patient.identifier:anpr",
        "path" : "Patient.identifier",
        "sliceName" : "anpr"
      },
      {
        "id" : "Patient.identifier:anpr.system",
        "path" : "Patient.identifier.system",
        "min" : 1,
        "fixedUri" : "http://hl7.it/sid/anpr",
        "mustSupport" : true
      },
      {
        "id" : "Patient.identifier:idRegionale",
        "path" : "Patient.identifier",
        "sliceName" : "idRegionale"
      },
      {
        "id" : "Patient.identifier:idRegionale.system",
        "path" : "Patient.identifier.system",
        "min" : 1,
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://terminology.hl7.it/ValueSet/uri-idRegionali"
        }
      },
      {
        "id" : "Patient.identifier:codiceENI",
        "path" : "Patient.identifier",
        "sliceName" : "codiceENI",
        "short" : "Codice ENI"
      },
      {
        "id" : "Patient.identifier:codiceENI.system",
        "path" : "Patient.identifier.system",
        "min" : 1,
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://terminology.hl7.it/ValueSet/uri-idEni"
        }
      },
      {
        "id" : "Patient.identifier:codiceSTP",
        "path" : "Patient.identifier",
        "sliceName" : "codiceSTP"
      },
      {
        "id" : "Patient.identifier:codiceSTP.system",
        "path" : "Patient.identifier.system",
        "min" : 1,
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://terminology.hl7.it/ValueSet/uri-idStp"
        }
      },
      {
        "id" : "Patient.name",
        "path" : "Patient.name",
        "requirements" : "Need to be able to track the patient by multiple names. Examples are your official name and a partner name.\r\nThe Alphabetic representation of the name SHALL be always provided",
        "min" : 1,
        "constraint" : [
          {
            "key" : "it-pat-1",
            "severity" : "error",
            "human" : "Patient.name.given or Patient.name.family or both SHALL be present",
            "expression" : "family.exists() or given.exists()",
            "xpath" : "f:given or f:family",
            "source" : "http://hl7.org/fhir/StructureDefinition/Patient"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Patient.name.extension:name-absent-reason",
        "path" : "Patient.name.extension",
        "sliceName" : "name-absent-reason",
        "short" : "Ragione non valorizzazione elemento name",
        "definition" : "Ragione per cui l'elemento name non è stato valorizzato",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/data-absent-reason"]
          }
        ]
      },
      {
        "id" : "Patient.name.text",
        "path" : "Patient.name.text",
        "mustSupport" : true
      },
      {
        "id" : "Patient.name.family",
        "path" : "Patient.name.family",
        "mustSupport" : true
      },
      {
        "id" : "Patient.name.given",
        "path" : "Patient.name.given",
        "mustSupport" : true
      },
      {
        "id" : "Patient.telecom",
        "path" : "Patient.telecom",
        "mustSupport" : true
      },
      {
        "id" : "Patient.gender",
        "path" : "Patient.gender",
        "mustSupport" : true
      },
      {
        "id" : "Patient.birthDate",
        "path" : "Patient.birthDate",
        "mustSupport" : true
      },
      {
        "id" : "Patient.deceased[x]",
        "path" : "Patient.deceased[x]",
        "mustSupport" : false
      },
      {
        "id" : "Patient.address",
        "path" : "Patient.address",
        "type" : [
          {
            "code" : "Address",
            "profile" : ["http://hl7.it/fhir/StructureDefinition/Address-it-base"]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Patient.maritalStatus",
        "path" : "Patient.maritalStatus",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://terminology.hl7.it/ValueSet/statoCivile"
        }
      },
      {
        "id" : "Patient.generalPractitioner",
        "path" : "Patient.generalPractitioner",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "$this"
            }
          ],
          "rules" : "open"
        },
        "mustSupport" : true
      },
      {
        "id" : "Patient.generalPractitioner:mmgPlsRole",
        "path" : "Patient.generalPractitioner",
        "sliceName" : "mmgPlsRole",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.it/fhir/StructureDefinition/PractitionerRole-it-mmg"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Patient.generalPractitioner:mmgPls",
        "path" : "Patient.generalPractitioner",
        "sliceName" : "mmgPls",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.it/fhir/StructureDefinition/Practitioner-it-base"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Patient.generalPractitioner:mmgPlsAzienda",
        "path" : "Patient.generalPractitioner",
        "sliceName" : "mmgPlsAzienda",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : ["http://hl7.it/fhir/StructureDefinition/Organization-it-hcp"]
          }
        ],
        "mustSupport" : true
      }
    ]
  }
}

```
