# Documento di Identificazione - HL7 Italia FHIR Implementation Guide (base) v0.1.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Documento di Identificazione**

## Logical Model: Documento di Identificazione ( Abstract Experimental ) 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.it/fhir/StructureDefinition/DocumentoIdentificazione | *Version*:0.1.1 |
| Draft as of 2025-11-18 | *Computable Name*:DocumentoIdentificazione |

 
Modello Logico che definisce il set di dati che caratterizzano i documenti di Identificazione (e.g. Passaporto, CI) . 

**Usages:**

* Use this Logical Model: [Paziente](StructureDefinition-Paziente.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.it.base|current/StructureDefinition/DocumentoIdentificazione)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-DocumentoIdentificazione.csv), [Excel](StructureDefinition-DocumentoIdentificazione.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "DocumentoIdentificazione",
  "url" : "http://hl7.it/fhir/StructureDefinition/DocumentoIdentificazione",
  "version" : "0.1.1",
  "name" : "DocumentoIdentificazione",
  "title" : "Documento di Identificazione",
  "status" : "draft",
  "experimental" : true,
  "date" : "2025-11-18T14:18:52+00:00",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.it"
        }
      ]
    }
  ],
  "description" : "Modello Logico che definisce il set di dati che caratterizzano i documenti di Identificazione (e.g. Passaporto, CI) .",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : true,
  "type" : "DocumentoIdentificazione",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Element",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "DocumentoIdentificazione",
        "path" : "DocumentoIdentificazione",
        "short" : "DocumentoIdentificazione",
        "definition" : "Modello Logico che definisce il set di dati che caratterizzano i documenti di Identificazione (e.g. Passaporto, CI)",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "DocumentoIdentificazione.idDocumento",
        "path" : "DocumentoIdentificazione.idDocumento",
        "short" : "Identificativo del documento di identificazione",
        "definition" : "Identificativo del documento di identificazione",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "string",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/string"]
          }
        ]
      },
      {
        "id" : "DocumentoIdentificazione.tipo",
        "path" : "DocumentoIdentificazione.tipo",
        "short" : "Tipo di documento di identificazione (e.g. Passaporto, CI)",
        "definition" : "Tipo di documento di identificazione (e.g. Passaporto, CI)",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/CodeableConcept"]
          }
        ]
      },
      {
        "id" : "DocumentoIdentificazione.periodoValidita",
        "path" : "DocumentoIdentificazione.periodoValidita",
        "short" : "Periodo di validità del documento",
        "definition" : "Periodo di validità del documento. da data di emissione a data scadenza",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Period",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/Period"]
          }
        ]
      },
      {
        "id" : "DocumentoIdentificazione.enteRilasciante",
        "path" : "DocumentoIdentificazione.enteRilasciante",
        "short" : "Ente rilasciante",
        "definition" : "Ente rilasciante",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "string",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/string"]
          }
        ]
      },
      {
        "id" : "DocumentoIdentificazione.statoRilasciante",
        "path" : "DocumentoIdentificazione.statoRilasciante",
        "short" : "Stato Rilasciante",
        "definition" : "Stato Rilasciante",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/CodeableConcept"]
          }
        ]
      }
    ]
  }
}

```
