# Organization. Esempio generico - HL7 Italia FHIR Implementation Guide (base) v0.1.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Organization. Esempio generico**

## Example Organization: Organization. Esempio generico

**identifier**: `http://example.org/identificativo`/12345

**active**: true

**name**: Fantastica Azienda

**telecom**: ph: tel:+39 123 456 7890(Mobile), [mailto:info@nice-org.it](mailto:mailto:info@nice-org.it)

**address**: 1, Piazza Signoria Firenze 50100 IT 

### Contacts

| | |
| :--- | :--- |
| - | **Name** |
| * | Dott. Ivo Serbelloni Viendalmare |



## Resource Content

```json
{
  "resourceType" : "Organization",
  "id" : "nice-org",
  "identifier" : [
    {
      "system" : "http://example.org/identificativo",
      "value" : "12345"
    }
  ],
  "active" : true,
  "name" : "Fantastica Azienda",
  "telecom" : [
    {
      "system" : "phone",
      "value" : "tel:+39 123 456 7890",
      "use" : "mobile"
    },
    {
      "system" : "email",
      "value" : "mailto:info@nice-org.it",
      "use" : "work"
    }
  ],
  "address" : [
    {
      "line" : ["1, Piazza Signoria"],
      "city" : "Firenze",
      "postalCode" : "50100",
      "country" : "IT"
    }
  ],
  "contact" : [
    {
      "name" : {
        "text" : "Dott. Ivo Serbelloni Viendalmare"
      }
    }
  ]
}

```
