# Certificazione - HL7 Italia FHIR Implementation Guide (base) v0.1.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Certificazione**

## Extension: Certificazione 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.it/fhir/StructureDefinition/recordCertification | *Version*:0.1.1 |
| Draft as of 2025-11-18 | *Computable Name*:ExtRecordCertification |

Estensione usata per indicare che l'informazione associata è stata certificata (od autocertificata) da una certa entità (persona, organizzazione). L'estensione è caratterizzata da: (a) una data di certificazione o da una periodo di validità (b) un codice od un riferimento al certificatore.

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [Address - base](StructureDefinition-Address-it-base.md) and [Patient - base](StructureDefinition-Patient-it-base.md)
* Examples for this Extension: [Patient/esempio-CF-residenza](Patient-esempio-CF-residenza.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.it.base|current/StructureDefinition/recordCertification)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-recordCertification.csv), [Excel](StructureDefinition-recordCertification.xlsx), [Schematron](StructureDefinition-recordCertification.sch) 

#### Terminology Bindings

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "recordCertification",
  "url" : "http://hl7.it/fhir/StructureDefinition/recordCertification",
  "version" : "0.1.1",
  "name" : "ExtRecordCertification",
  "title" : "Certificazione",
  "status" : "draft",
  "date" : "2025-11-18T14:18:52+00:00",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.it"
        }
      ]
    }
  ],
  "description" : "Estensione usata per indicare che l'informazione associata è stata certificata (od autocertificata) da una certa entità (persona, organizzazione).  L'estensione è caratterizzata da: (a) una data di certificazione o da una periodo di validità (b) un codice od un riferimento al certificatore.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "Address"
    },
    {
      "type" : "element",
      "expression" : "Patient"
    },
    {
      "type" : "element",
      "expression" : "Patient.identifier"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "Certificazione del record",
        "definition" : "Identifica che un certo record paziente, o codice fiscale od indirizzo di residenza è stato certificato da una specifica entità (e.g. MEF)."
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "rules" : "open"
        }
      },
      {
        "id" : "Extension.extension:when",
        "path" : "Extension.extension",
        "sliceName" : "when",
        "short" : "Data/Periodo  di certificazione",
        "max" : "1"
      },
      {
        "id" : "Extension.extension:when.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "when"
      },
      {
        "id" : "Extension.extension:when.value[x]",
        "path" : "Extension.extension.value[x]",
        "type" : [
          {
            "code" : "dateTime"
          },
          {
            "code" : "Period"
          }
        ]
      },
      {
        "id" : "Extension.extension:who",
        "path" : "Extension.extension",
        "sliceName" : "who",
        "short" : "Entità Certificante",
        "max" : "1"
      },
      {
        "id" : "Extension.extension:who.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "who"
      },
      {
        "id" : "Extension.extension:who.value[x]",
        "path" : "Extension.extension.value[x]",
        "type" : [
          {
            "code" : "CodeableConcept"
          },
          {
            "code" : "Reference"
          }
        ],
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://terminology.hl7.it/ValueSet/tipoCertificatore"
        }
      },
      {
        "id" : "Extension.extension:rank",
        "path" : "Extension.extension",
        "sliceName" : "rank"
      },
      {
        "id" : "Extension.extension:rank.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "rank"
      },
      {
        "id" : "Extension.extension:rank.value[x]",
        "path" : "Extension.extension.value[x]",
        "type" : [
          {
            "code" : "decimal"
          }
        ]
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "http://hl7.it/fhir/StructureDefinition/recordCertification"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "max" : "0"
      }
    ]
  }
}

```
