# Official Address - HL7 Italia FHIR Implementation Guide (base) v0.1.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Official Address**

## Extension: Official Address 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/fhir/StructureDefinition/address-official | *Version*:0.1.1 |
| Draft as of 2025-11-18 | *Computable Name*:OfficialAddress |
| **Copyright/Legal**: CC0 | |

Indicate that this address is meant to be the 'official' address for that person. What an 'official' address is depends on the country. This extension allows to specify if this address is or it is not the official address, or to indicate that this is the official address for that country

**Context of Use**

> **Questa estensione è inclusa in via sperimentale in questa versione della guida in attesa dell'effettiva definizione da parte di HL7.org (vedi[Jira tracker #25938)](https://jira.hl7.org/browse/FHIR-25938))**
La struttura dell'estensione e/o il suo url potrebbero cambiare.

**Usage info**

**Usages:**

* Use this Extension: [Address - base](StructureDefinition-Address-it-base.md)
* Examples for this Extension: [Patient/esempio-CF-residenza](Patient-esempio-CF-residenza.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.it.base|current/StructureDefinition/address-official)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-address-official.csv), [Excel](StructureDefinition-address-official.xlsx), [Schematron](StructureDefinition-address-official.sch) 

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "address-official",
  "url" : "http://hl7.org/fhir/StructureDefinition/address-official",
  "version" : "0.1.1",
  "name" : "OfficialAddress",
  "title" : "Official Address",
  "status" : "draft",
  "date" : "2025-11-18T14:18:52+00:00",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.it"
        }
      ]
    }
  ],
  "description" : "Indicate that this address is meant to be the 'official' address for that person. What an 'official' address is depends on the country. This extension allows to specify if this address is or it is not the official address, or to indicate that this is the official address for that country",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT"
        }
      ]
    }
  ],
  "copyright" : "CC0",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "Address"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "Official Address",
        "definition" : "This extension allows to specify if this address is or it is not the official address, or to indicate that this is the official address for that country (true assumed)."
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "http://hl7.org/fhir/StructureDefinition/address-official",
        "mapping" : [
          {
            "identity" : "rim",
            "map" : "AD/@use[.='OR']"
          }
        ]
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "boolean"
          },
          {
            "code" : "CodeableConcept"
          }
        ],
        "meaningWhenMissing" : "Nothing can be inferred when this extension is missing. I.e. the absence of this extension shall not be interpreted as non-official address."
      }
    ]
  }
}

```
