# Indirizzo - HL7 Italia FHIR Implementation Guide (base) v0.1.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Indirizzo**

## Logical Model: Indirizzo ( Abstract Experimental ) 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.it/fhir/StructureDefinition/Indirizzo | *Version*:0.1.1 |
| Draft as of 2025-11-18 | *Computable Name*:Indirizzo |

 
Modello Logico che definisce le tipiche informazioni che caratterizzano un indirizzo nella giurisdizione italiana. 

**Usages:**

* Use this Logical Model: [Persona di Contatto](StructureDefinition-ContattoPersona.md) and [Paziente](StructureDefinition-Paziente.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.it.base|current/StructureDefinition/Indirizzo)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Indirizzo.csv), [Excel](StructureDefinition-Indirizzo.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Indirizzo",
  "url" : "http://hl7.it/fhir/StructureDefinition/Indirizzo",
  "version" : "0.1.1",
  "name" : "Indirizzo",
  "title" : "Indirizzo",
  "status" : "draft",
  "experimental" : true,
  "date" : "2025-11-18T14:18:52+00:00",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.it"
        }
      ]
    }
  ],
  "description" : "Modello Logico che definisce le tipiche informazioni che caratterizzano un indirizzo nella giurisdizione italiana.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "fhir-it",
      "uri" : "http://hl7.it/fhir",
      "name" : "HL7 FHIR IT Profiles"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : true,
  "type" : "Indirizzo",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Element",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "Indirizzo",
        "path" : "Indirizzo",
        "short" : "Indirizzo",
        "definition" : "Modello Logico che definisce le tipiche informazioni che caratterizzano un indirizzo nella giurisdizione italiana.",
        "min" : 0,
        "max" : "*",
        "mapping" : [
          {
            "identity" : "fhir-it",
            "map" : "Address.conformsTo('http://hl7.it/fhir/StructureDefinition/Address-it-base')"
          }
        ]
      },
      {
        "id" : "Indirizzo.tipo",
        "path" : "Indirizzo.tipo",
        "short" : "Tipo di indirizzo (e.g residenza, domicilio)",
        "definition" : "Tipo di indirizzo (e.g residenza, domicilio)",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/CodeableConcept"]
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir-it",
            "map" : "Address.extension",
            "comment" : "I diversi tipi di indirizzo sono caratterizzati dalla valorizzazione di specifici campi: e.g. use='home' per domicilio. In caso sia necessario descivere specificatamente la categoria di indirizzo una specifica estensione (opzionale) può essere aggiunta."
          }
        ]
      },
      {
        "id" : "Indirizzo.periodoValidita",
        "path" : "Indirizzo.periodoValidita",
        "short" : "Periodo di validità",
        "definition" : "Periodo di validità dell'indirizzo",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Period",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/Period"]
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir-it",
            "map" : "Address.period"
          }
        ]
      },
      {
        "id" : "Indirizzo.stringaIndirizzo",
        "path" : "Indirizzo.stringaIndirizzo",
        "short" : "Indirizzo completo o parziale testuale",
        "definition" : "Indirizzo completo o parziale testuale",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "string",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/string"]
          }
        ],
        "mustSupport" : true,
        "mapping" : [
          {
            "identity" : "fhir-it",
            "map" : "Address.text"
          }
        ]
      },
      {
        "id" : "Indirizzo.strutturaIndirizzo",
        "path" : "Indirizzo.strutturaIndirizzo",
        "short" : "Struttura Indirizzo",
        "definition" : "Struttura Indirizzo",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true,
        "mapping" : [
          {
            "identity" : "fhir-it",
            "map" : "Address",
            "comment" : "La struttura è descritta da una serie di elementi diversi"
          }
        ]
      },
      {
        "id" : "Indirizzo.strutturaIndirizzo.linea",
        "path" : "Indirizzo.strutturaIndirizzo.linea",
        "short" : "Linea Indirizzo",
        "definition" : "Linea Indirizzo",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir-it",
            "map" : "Address.line"
          }
        ]
      },
      {
        "id" : "Indirizzo.strutturaIndirizzo.linea.stringa",
        "path" : "Indirizzo.strutturaIndirizzo.linea.stringa",
        "short" : "Linea Indirizzo testuale",
        "definition" : "Linea Indirizzo testuale",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "string",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/string"]
          }
        ],
        "example" : [
          {
            "label" : "linea",
            "valueString" : "Via dei Carpini 33r, scala 2, interno 8"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir-it",
            "map" : "Address.line"
          }
        ]
      },
      {
        "id" : "Indirizzo.strutturaIndirizzo.linea.odonimo",
        "path" : "Indirizzo.strutturaIndirizzo.linea.odonimo",
        "short" : "Toponimo stradale (e.g. Via Carso)",
        "definition" : "Toponimo stradale (e.g. Via Carso)",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "string",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/string"]
          }
        ],
        "example" : [
          {
            "label" : "odonimo",
            "valueString" : "Vicolo Alberti"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir-it",
            "map" : "Address.line.extension('http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-streetName')"
          }
        ]
      },
      {
        "id" : "Indirizzo.strutturaIndirizzo.linea.denominazioneUrbanisticaGenerica",
        "path" : "Indirizzo.strutturaIndirizzo.linea.denominazioneUrbanisticaGenerica",
        "short" : "Denominazione Urbanistica Generica (DUG)",
        "definition" : "Denominazione Urbanistica Generica (DUG)",
        "alias" : ["specie"],
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/string"]
          }
        ],
        "example" : [
          {
            "label" : "DUG",
            "valueString" : "Via"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir-it",
            "map" : "Address.line.extension('http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-streetNameType')"
          }
        ]
      },
      {
        "id" : "Indirizzo.strutturaIndirizzo.linea.dugCode",
        "path" : "Indirizzo.strutturaIndirizzo.linea.dugCode",
        "short" : "Codice Denominazione Urbanistica Generica (DUG)",
        "definition" : "Codice Denominazione Urbanistica Generica (DUG)",
        "alias" : ["specie"],
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/CodeableConcept"]
          }
        ],
        "example" : [
          {
            "label" : "DUG",
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://registry.geodati.gov.it/dug",
                  "code" : "67",
                  "display" : "via"
                }
              ]
            }
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir-it",
            "map" : "Address.line.extension('http://hl7.it/fhir/StructureDefinition/address-dug')"
          }
        ]
      },
      {
        "id" : "Indirizzo.strutturaIndirizzo.linea.denominazioneUrbanisticaUfficiale",
        "path" : "Indirizzo.strutturaIndirizzo.linea.denominazioneUrbanisticaUfficiale",
        "short" : "Denominazione Urbanistica Ufficiale (DUF)",
        "definition" : "Denominazione Urbanistica Ufficiale (DUF)",
        "alias" : ["denominazione"],
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/string"]
          }
        ],
        "example" : [
          {
            "label" : "DUF",
            "valueString" : "Corta"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir-it",
            "map" : "Address.line.extension('http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-streetNameBase')"
          }
        ]
      },
      {
        "id" : "Indirizzo.strutturaIndirizzo.linea.numeroCivico",
        "path" : "Indirizzo.strutturaIndirizzo.linea.numeroCivico",
        "short" : "Numero Civico",
        "definition" : "Numero Civico",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "string",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/string"]
          }
        ],
        "example" : [
          {
            "label" : "numeroCivico",
            "valueString" : "37"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir-it",
            "map" : "Address.line.extension('http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-houseNumber')"
          }
        ]
      },
      {
        "id" : "Indirizzo.strutturaIndirizzo.linea.interno",
        "path" : "Indirizzo.strutturaIndirizzo.linea.interno",
        "short" : "Interno",
        "definition" : "Interno",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "string",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/string"]
          }
        ],
        "example" : [
          {
            "label" : "interno",
            "valueString" : "8b"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir-it",
            "map" : "Address.line.extension"
          }
        ]
      },
      {
        "id" : "Indirizzo.strutturaIndirizzo.linea.scala",
        "path" : "Indirizzo.strutturaIndirizzo.linea.scala",
        "short" : "Scala",
        "definition" : "Scala",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "string",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/string"]
          }
        ],
        "example" : [
          {
            "label" : "scala",
            "valueString" : "scala 2"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir-it",
            "map" : "Address.line.extension"
          }
        ]
      },
      {
        "id" : "Indirizzo.strutturaIndirizzo.cap",
        "path" : "Indirizzo.strutturaIndirizzo.cap",
        "short" : "Codice Avviamento Postale",
        "definition" : "Codice Avviamento Postale",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "string",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/string"]
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir-it",
            "map" : "Address.postalCode"
          }
        ]
      },
      {
        "id" : "Indirizzo.strutturaIndirizzo.localita",
        "path" : "Indirizzo.strutturaIndirizzo.localita",
        "short" : "Nome Località",
        "definition" : "Nome Località",
        "alias" : ["Frazione"],
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "string",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/string"]
          }
        ],
        "example" : [
          {
            "label" : "localita",
            "valueString" : "Il Poggetto"
          }
        ]
      },
      {
        "id" : "Indirizzo.strutturaIndirizzo.comune",
        "path" : "Indirizzo.strutturaIndirizzo.comune",
        "short" : "Nome comune",
        "definition" : "Nome comune",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "string",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/string"]
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir-it",
            "map" : "Address.city"
          }
        ]
      },
      {
        "id" : "Indirizzo.strutturaIndirizzo.codiceComune",
        "path" : "Indirizzo.strutturaIndirizzo.codiceComune",
        "short" : "Codice comune (e.g. ISTAT; Catasto)",
        "definition" : "Codice comune (e.g. ISTAT; Catasto)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/CodeableConcept"]
          }
        ],
        "example" : [
          {
            "label" : "codiceComune",
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.it/sid/istat-unitaAmministrativeTerritoriali",
                  "code" : "005005",
                  "display" : "Asti"
                },
                {
                  "system" : "http://terminology.hl7.it/sid/mef-ae-comuni",
                  "code" : "A479",
                  "display" : "Asti"
                }
              ]
            }
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir-it",
            "map" : "Address.city.extension('http://hl7.org/fhir/StructureDefinition/iso21090-SC-coding')"
          }
        ]
      },
      {
        "id" : "Indirizzo.strutturaIndirizzo.provincia",
        "path" : "Indirizzo.strutturaIndirizzo.provincia",
        "short" : "Nome Provincia",
        "definition" : "Nome Provincia",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "string",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/string"]
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir-it",
            "map" : "Address.district"
          }
        ]
      },
      {
        "id" : "Indirizzo.strutturaIndirizzo.codiceProvincia",
        "path" : "Indirizzo.strutturaIndirizzo.codiceProvincia",
        "short" : "Codice Provincia",
        "definition" : "Codice Provincia",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/CodeableConcept"]
          }
        ],
        "example" : [
          {
            "label" : "codiceIstatProvincia",
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.it/sid/istat-unitaAmministrativeTerritoriali",
                  "code" : "026",
                  "display" : "Treviso"
                }
              ]
            }
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir-it",
            "map" : "Address.district.extension('http://hl7.org/fhir/StructureDefinition/iso21090-SC-coding')"
          }
        ]
      },
      {
        "id" : "Indirizzo.strutturaIndirizzo.regione",
        "path" : "Indirizzo.strutturaIndirizzo.regione",
        "short" : "Nome Regione",
        "definition" : "Nome Regione",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "string",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/string"]
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir-it",
            "map" : "Address.state"
          }
        ]
      },
      {
        "id" : "Indirizzo.strutturaIndirizzo.codiceRegione",
        "path" : "Indirizzo.strutturaIndirizzo.codiceRegione",
        "short" : "Codice Regione",
        "definition" : "Codice Regione",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/CodeableConcept"]
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir-it",
            "map" : "Address.state.extension('http://hl7.org/fhir/StructureDefinition/iso21090-SC-coding')"
          }
        ]
      },
      {
        "id" : "Indirizzo.strutturaIndirizzo.stato",
        "path" : "Indirizzo.strutturaIndirizzo.stato",
        "short" : "Nome Stato",
        "definition" : "Nome Stato",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "string",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/string"]
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir-it",
            "map" : "Address.country"
          }
        ]
      },
      {
        "id" : "Indirizzo.strutturaIndirizzo.codiceStato",
        "path" : "Indirizzo.strutturaIndirizzo.codiceStato",
        "short" : "Codice Stato",
        "definition" : "Codice Stato",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/CodeableConcept"]
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir-it",
            "map" : "Address.country.extension('http://hl7.org/fhir/StructureDefinition/iso21090-SC-coding')"
          }
        ]
      }
    ]
  }
}

```
