# Coverage. Esempio di gestire delle esenzioni - HL7 Italia FHIR Implementation Guide (base) v0.1.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Coverage. Esempio di gestire delle esenzioni**

## Example Coverage: Coverage. Esempio di gestire delle esenzioni

**status**: Active

**type**: public healthcare

**beneficiary**: [DANTE ALIGHIERI (official) Male, DoB: 1971-05-01 ( http://hl7.it/sid/codiceFiscale#TSTPSN80A01D612A)](Patient-esempio-CF-residenza.md)

**payor**: [Organization AZIENDA U.S.L. VALLE D'AOSTA](Organization-asl-020101.md)

> **costToBeneficiary****value**:

### Exceptions

| | | |
| :--- | :--- | :--- |
| - | **Extension** | **Type** |
| * |  | E01 |




## Resource Content

```json
{
  "resourceType" : "Coverage",
  "id" : "EsempioEsenzione",
  "status" : "active",
  "type" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
        "code" : "PUBLICPOL"
      }
    ]
  },
  "beneficiary" : {
    "reference" : "Patient/esempio-CF-residenza"
  },
  "payor" : [
    {
      "reference" : "Organization/asl-020101"
    }
  ],
  "costToBeneficiary" : [
    {
      "valueMoney" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      },
      "exception" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.it/fhir/StructureDefinition/coverage-exceptionStatus",
              "valueCodeableConcept" : {
                "coding" : [
                  {
                    "system" : "http://terminology.hl7.org/CodeSystem/v3-ActStatus",
                    "code" : "active"
                  }
                ]
              }
            }
          ],
          "type" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.it/CodeSystem/minsan-esenzioni",
                "code" : "E01"
              }
            ]
          }
        }
      ]
    }
  ]
}

```
