# EHDSPatient to FHIR Patient Mapping - HL7 Europe Base and Core FHIR IG v2.0.0-ballot

* [**Table of Contents**](toc.md)
* **EHDSPatient to FHIR Patient Mapping**

## EHDSPatient to FHIR Patient Mapping

# EHDSPatient → PatientEuCore

**Ongoing alignment:**The Xt-EHR logical models are under active revision and continuous refinement. Updates from Xt-EHR will be progressively incorporated into this Implementation Guide to maintain alignment with the evolving EHDS specifications.

**Yellow row/cells:**In this ballot publication, some row/cells of the mapping table have been left in yellow to indicate areas requiring further review or refinement; including feedback from the Xt-EHR joint action (see note above). These highlights will be addressed in subsequent updates to ensure accuracy and completeness of the mappings.

### EHDSPatient → PatientEuCore

 This page explains how conceptual elements from the EHDS logical model are expressed in the corresponding FHIR PatientEuCore profile used by this Implementation Guide. 

**Mapping Context**
*  **Source logical model:** [EHDSPatient](https://www.xt-ehr.eu/fhir/models/StructureDefinition/EHDSPatient) 
*  **Target FHIR profile:** [PatientEuCore](StructureDefinition-patient-eu-core.md) 

| | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| Element | Description | Relation | Resource | Element | Description | Notes |
| personalIdentifier | An identifier of the patient that is unique within a defined scope. | equivalent | Patient | identifier | Patient identifiers. |  |
| name | Name associated with the patient/subject. | equivalent | Patient | name | A name associated with the patient. |  |
| dateOfBirth | Date of birth. | equivalent | Patient | birthDate | The date of birth for the patient. |  |
| administrativeGender | Administrative gender. | equivalent | Patient | gender | Administrative gender. |  |
| address | Mailing and home or office addresses. | equivalent | Patient | address | An address for the individual. |  |
| telecom | Telecommunication contact information. | equivalent | Patient | telecom | A contact detail for the patient. |  |
| maritalStatus | Marital (civil) status of a patient. | equivalent | Patient | maritalStatus | Marital (civil) status of a patient. |  |
| communicationLanguage | Language that can be used to communicate with the patient about their health. | equivalent | Patient | communication.language | Communication language. |  |

 Return to overview: [EHDS Logical Models → FHIR Profiles](modelmap.md) 

