# EHDSImmunisation to FHIR Immunization Mapping - HL7 Europe Base and Core FHIR IG v2.0.0-ballot

* [**Table of Contents**](toc.md)
* **EHDSImmunisation to FHIR Immunization Mapping**

## EHDSImmunisation to FHIR Immunization Mapping

# EHDSImmunisation → Immunization

**Ongoing alignment:**The Xt-EHR logical models are under active revision and continuous refinement. Updates from Xt-EHR will be progressively incorporated into this Implementation Guide to maintain alignment with the evolving EHDS specifications.

**Yellow row/cells:**In this ballot publication, some row/cells of the mapping table have been left in yellow to indicate areas requiring further review or refinement; including feedback from the Xt-EHR joint action (see note above). These highlights will be addressed in subsequent updates to ensure accuracy and completeness of the mappings.

### EHDSImmunisation → Immunization

 This page explains how conceptual elements from the EHDS logical model are expressed in the corresponding FHIR ImmunizationEuCore profile used by this Implementation Guide. 

**Mapping Context**
*  **Source logical model:** [EHDSImmunisation](https://www.xt-ehr.eu/fhir/models/StructureDefinition-EHDSImmunisation.html) 
*  **Target FHIR profile:** [ImmunizationEuCore](StructureDefinition-immunization-eu-core.md) 

| | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| Element | Description | Relation | Resource | Element | Description | Notes |
| header | Common header for all patient-related data. | related-to | Immunization | . | General metadata. | Dataset-level; not usually carried in Immunization as-is. |
| header.subject | Patient/subject this immunisation is about. | equivalent | Immunization | patient | Who received the vaccine. | Reference to Patient. |
| header.identifier | Business identifier for the object. | equivalent | Immunization | identifier | External identifier(s) for this Immunization event. | Copy over all identifiers if multiple. |
| header.authorship | Resource authoring details. | no-map | Immunization |  |  | there is a performer and a source of information not the author... |
| header.authorship.author[x] | Who authored/recorded this immunisation. | no-map | Immunization |  |  |  |
| header.authorship.datetime | Date/time the record was issued/recorded. | no-map | Immunization |  |  |  |
| header.lastUpdate | Last technical correction/update. | related-to | Immunization | meta.lastUpdated | When the resource version last changed. | The map applies only if it represents the technical update timestamp (Instant). |
| header.status | Indicates the current status of the immunisation event. | equivalent | Immunization | status | Indicates if the vaccination was given (completed, not-done). | Use`statusReason`in FHIR for "not done" reason when applicable. |
| header.statusReason[x] | Reason for the current status of the resource. | source-is-broader-than-target | Immunization | statusReason |  | The reason why a vaccine was not administered. |
| header.statusReason[x] | Reason for the current status of the resource. | source-is-broader-than-target | Immunization | reasonCode〔R4〕 |  | The reason why a vaccine was administered. |
| header.statusReason[x] | Reason for the current status of the resource. | source-is-broader-than-target | Immunization | reason.concept〔R5〕 |  | The reason why a vaccine was administered. |
| header.language | Language of the resource (IETF tag). | equivalent | Immunization | language | Language used in the resource. |  |
| dateTimeOfVaccination | Date/time administered. | equivalent | Immunization | occurrence[x] | When the vaccine was administered. | Usually`occurrenceDateTime`. |
| vaccine | Type of vaccine | equivalent | Immunization | vaccineCode | Vaccine that was administered. | CodeableConcept bound to the relevant vaccine type value set. |
| administeredProduct | Vaccine product administered. | equivalent | Immunization | extension:administeredProduct〔R4〕 | Product that was administered. | Use the standard extension in R4. |
| administeredProduct | Vaccine product administered. | equivalent | Immunization | administeredProduct〔R5〕 | Product that was administered. | Reference to`Medication`. |
| diseaseOrAgentTargeted | Disease or agent targeted by the vaccination. | equivalent | Immunization | protocolApplied.targetDisease | Disease that the vaccination targets. |  |
| doseNumber | Dose number within the series. | equivalent | Immunization | protocolApplied.doseNumber[x]〔R4〕 | Dose number within the series. | Integer in the model, Only string in R5; CodeableConcept in R6 |
| doseNumber | Dose number within the series. | equivalent | Immunization | protocolApplied.doseNumber〔R5〕 | Dose number within the series. | Integer in the model, Only string in R5; CodeableConcept in R6 |
| vaccineAdministrator | Who administered the vaccine. | equivalent | Immunization | performer:administeringCentreOrHp.actor | Who performed the immunization. | actor of type PractitionerRole or Practitioner. |
| administeringCentre | Centre/organisation administering the vaccine. | source-is-broader-than-target | Immunization | performer:administeringCentreOrHp.actor | Organization involved in administering the vaccine. | actor of type PractitionerRole or Practitioner. |
| nextVaccinationDate | Next scheduled vaccination date. | source-is-narrower-than-target | ImmunizationRecommendation | recommendation.dateCriterion.value | The date whose meaning is specified by dateCriterion.code. | No direct element in Immunization; use ImmunizationRecommendation for scheduling. |

 Return to overview: [EHDS Logical Models → FHIR Profiles](modelmap.md) 

