# EHDSCondition to FHIR Condition Mapping - HL7 Europe Base and Core FHIR IG v2.0.0-ballot

* [**Table of Contents**](toc.md)
* **EHDSCondition to FHIR Condition Mapping**

## EHDSCondition to FHIR Condition Mapping

# EHDSCondition → Condition

**Ongoing alignment:**The Xt-EHR logical models are under active revision and continuous refinement. Updates from Xt-EHR will be progressively incorporated into this Implementation Guide to maintain alignment with the evolving EHDS specifications.

**Yellow row/cells:**In this ballot publication, some row/cells of the mapping table have been left in yellow to indicate areas requiring further review or refinement; including feedback from the Xt-EHR joint action (see note above). These highlights will be addressed in subsequent updates to ensure accuracy and completeness of the mappings.

### EHDSCondition → Condition

 This page explains how conceptual elements from the EHDS logical model are expressed in the corresponding FHIR ConditionEuCore profile used by this Implementation Guide. 

**Mapping Context**
*  **Source logical model:** [EHDSCondition](https://www.xt-ehr.eu/fhir/models/StructureDefinition-EHDSCondition.html) 
*  **Target FHIR profile:** [ConditionEuCore](StructureDefinition-condition-eu-core.md) 

| | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| Element | Description | Relation | Resource | Element | Description | Notes |
| header | Common header for all patient-related data. | related-to | Condition | . | General metadata. | Dataset-level; not usually carried in Condition as-is. |
| header.subject | Patient/subject this condition is about. | equivalent | Condition | subject | Reference to the patient or subject of the condition. | Reference to Patient (or other subject). |
| header.identifier | Business identifier for the object. | equivalent | Condition | identifier | Business identifier for this condition. | Copy over all identifiers if multiple. |
| header.authorship | Resource authoring details. | related-to | Condition | recorder〔R4〕 | Who recorded the condition. | Condition has no generic "author"; use`recorder`in R4**This element is 1.. in the model 0.. in the profile** |
| header.authorship | Resource authoring details. | related-to | Condition | participant.actor〔R5〕 | Who recorded the condition. | Condition has no generic "author"; use`participant.actor`in R5**This element is 1.. in the model 0.. in the profile** |
| header.authorship.author[x] | Who created/issued the condition record. | equivalent | Condition | recorder〔R4〕 | Who recorded the condition. | Condition has no generic "author"; use`recorder`in R4**This element is 1.. in the model 0.. in the profile** |
| header.authorship.author[x] | Who created/issued the condition record. | equivalent | Condition | participant.actor〔R5〕 | Who recorded the condition. | Condition has no generic "author"; use`participant.actor`in R5**This element is 1.. in the model 0.. in the profile** |
| header.authorship.author[x] | Who created/issued the condition record. | equivalent | Condition | recorder | Who recorded the condition. | Can reference Practitioner, PractitionerRole, Patient, RelatedPerson (per profile).**This element is 1.. in the model 0.. in the profile** |
| header.authorship.datetime | Date/time the resource was issued. | equivalent | Condition | recordedDate | When the condition was recorded. | **This element is 1.. in the model 0.. in the profile** |
| header.lastUpdate | Last technical correction/update. | source-is-broader-than-target | Condition | meta.lastUpdated | When the resource version was last changed. | FHIR`meta.lastUpdated`is system-level; EHDS header may carry richer audit info. |
| header.status | Status of the dataset/resource (technical/administrative). | no map | Condition | - | - | Do not confuse with`Condition.clinicalStatus`or`verificationStatus`below. |
| header.statusReason[x] | Reason for current dataset status. | no map | Condition | - | - |  |
| header.language | Language of the resource (IETF tag). | equivalent | Condition | language | Language used in narrative/notes. |  |
| problem | Code identifying the condition, problem or diagnosis. | equivalent | Condition | code | Identification of the condition, problem, or diagnosis. | CodeableConcept. EHDS binds to ICD-10, SNOMED CT, ICD-O, Orphacode. |
| onsetDate | Onset date of a problem/condition. | equivalent | Condition | onsetDateTime | Estimated or actual date/time the condition started. | Map to`onsetDateTime`in FHIR. |
| endDate | The date or estimated date that the condition resolved or went into remission. | equivalent | Condition | abatementDateTime | When the condition abated or went into remission. | Use`abatementDateTime`; abatement may also be represented by clinicalStatus = resolved. |
| category | Category or categories of the problem (e.g. POA, HAC, other categorisations). | equivalent | Condition | category | Problem category (e.g. problem-list-item, encounter-diagnosis). | 0..* in both models; EHDS may use additional national/organisational codes. |
| problemStatus | Status of the condition/problem (active, resolved, inactive, ...). | equivalent | Condition | clinicalStatus | Current clinical status of the condition. | FHIR has a required VS for clinicalStatus; EHDS references HL7 Condition Clinical Status Codes. |
| resolutionCircumstances | Reason for which the status changed from current to inactive (free text if not represented elsewhere). | source-is-broader-than-target | Condition | note.text | Additional text about the condition. | FHIR Condition has no direct "resolution reason"; use`Condition.note` |
| severity | Subjective assessment of the severity of the condition. | equivalent | Condition | severity | Clinical severity of the condition. | CodeableConcept; HL7 / SNOMED CT value sets. |
| anatomicLocation | The anatomical location including laterality where this condition manifests itself. | source-is-broader-than-target | Condition | bodySite | Anatomical location(s) affected by the condition. | EHDS uses EHDSBodyStructure; map to one or more`Condition.bodySite`. Use referenced BodyStructure if profiling for more detail. |
| anatomicLocation | The anatomical location including laterality where this condition manifests itself. | equivalent | Condition | extension:bodySite | Anatomical location(s) affected by the condition. | EHDS uses EHDSBodyStructure; map to one or more`Condition.bodySite`. Use referenced BodyStructure if profiling for more detail. |
| stage | Stage/grade usually assessed formally using a specific staging/grading system. Multiple assessment systems could be used. | equivalent | Condition | stage | Simple summary of condition stage. | FHIR also has`stage.assessment`(Reference). For multiple staging systems, create multiple`Condition.stage`repetitions. |
| diagnosisAssertionStatus | Assertion about the certainty associated with a diagnosis. | equivalent | Condition | verificationStatus | Whether the condition is unconfirmed, provisional, confirmed, refuted, etc. | Both EHDS and FHIR refer to HL7 Condition Verification Status. |
| asserter | The asserter of the condition. | equivalent | Condition | asserter | Individual who asserted the condition. | Reference to Practitioner / PractitionerRole / Patient / RelatedPerson, depending on profile. |
| assertedDate | Date and time of the diagnosis assertion. | equivalent | Condition | extension:assertedDate | Date the condition record was first recorded. |  |
| specialistContact | Health Professional specifically related to the problem, as a preferred contact. | source-is-narrower-than-target | CareTeam | note.text | Who is involved | FHIR Condition has no native participant element. Suggest to use`Condition.note`to record in a textual form who should be contacted. When used, this information can also be derived from the`CareTeam`involved for the care of this Condition (referred in`CareTeam.reason`). |
| externalResource | External resource related to the problem (e.g. guidelines for a rare disease). | source-is-narrower-than-target | Condition | extension:relatedArtifact | Related artifacts such as additional documentation, justification, dependencies, bibliographic references, and predecessor and successor artifacts. |  |

 Return to overview: [EHDS Logical Models → FHIR Profiles](modelmap.md) 

