# Copyright - HL7 Europe Base and Core FHIR IG v2.0.0-ballot

* [**Table of Contents**](toc.md)
* **Copyright**

## Copyright

### Intellectual property statements

This publication includes IP covered under the following statements.

* [https://cms.npu-terminology.org/wp-content/uploads/2024/06/NPU-License-Terms-of-Use.pdf](https://cms.npu-terminology.org/wp-content/uploads/2024/06/NPU-License-Terms-of-Use.pdf)

* [Nomenclature for Properties and Units (NPU)](http://terminology.hl7.org/6.5.0/CodeSystem-NPU.html): [LaboratoryResultStandardEuVs](ValueSet-lab-obsCode-eu-lab.md) and [MedicalTestResultEuCore](StructureDefinition-medicalTestResult-eu-core.md)


* ISO maintains the copyright on the country codes, and controls its use carefully. For further details see the ISO 3166 web page: [https://www.iso.org/iso-3166-country-codes.html](https://www.iso.org/iso-3166-country-codes.html)

* [ISO 3166-1 Codes for the representation of names of countries and their subdivisions — Part 1: Country code](http://terminology.hl7.org/6.5.0/CodeSystem-ISO3166Part1.html): [AddressEu](StructureDefinition-Address-eu.md)


* The UCUM codes, UCUM table (regardless of format), and UCUM Specification are copyright 1999-2009, Regenstrief Institute, Inc. and the Unified Codes for Units of Measures (UCUM) Organization. All rights reserved. [https://ucum.org/trac/wiki/TermsOfUse](https://ucum.org/trac/wiki/TermsOfUse)

* [Unified Code for Units of Measure (UCUM)](http://hl7.org/fhir/uv/xver-r5.r4/0.0.1-snapshot-2/CodeSystem-v3-ucum.html): [Medication/01A-Cefuroxime1500GenericExplicit](Medication-01A-Cefuroxime1500GenericExplicit.md), [MedicationRequest/400C-prescription-cefuroxime-singleline](MedicationRequest-400C-prescription-cefuroxime-singleline.md), [MedicationStatement/example-medicationstatement-eucore](MedicationStatement-example-medicationstatement-eucore.md) and [Observation/763f7902-8103-4d10-8bd1-546a726d43ee](Observation-763f7902-8103-4d10-8bd1-546a726d43ee.md)


* This material contains content from [LOINC](http://loinc.org). LOINC is copyright © 1995-2020, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the [license](http://loinc.org/license). LOINC® is a registered United States trademark of Regenstrief Institute, Inc.

* [LOINC](http://terminology.hl7.org/6.5.0/CodeSystem-v3-loinc.html): [Composition/26032a57-083a-4ddf-b019-e566ae02f740](Composition-26032a57-083a-4ddf-b019-e566ae02f740.md), [CompositionEuCore](StructureDefinition-composition-eu-core.md)...Show 6 more,[DiagnosticReport/5679723c-4fae-4ba7-9f09-5438a827bfda](DiagnosticReport-5679723c-4fae-4ba7-9f09-5438a827bfda.md),[EhdsCategoriesEuVs](ValueSet-ehdsCategories-eu.md),[LaboratoryResultStandardEuVs](ValueSet-lab-obsCode-eu-lab.md),[MedicalTestResultEuCore](StructureDefinition-medicalTestResult-eu-core.md),[Observation/763f7902-8103-4d10-8bd1-546a726d43ee](Observation-763f7902-8103-4d10-8bd1-546a726d43ee.md)and[ServiceRequest/1d4cbcd1-e0d3-49b6-92d8-1893da8d08e1](ServiceRequest-1d4cbcd1-e0d3-49b6-92d8-1893da8d08e1.md)


* This material contains content that is copyright of SNOMED International. Implementers of these specifications must have the appropriate SNOMED CT Affiliate license - for more information contact [https://www.snomed.org/get-snomed](https://www.snomed.org/get-snomed) or [info@snomed.org](mailto:info@snomed.org).

* [SNOMED Clinical Terms&reg; (SNOMED CT&reg;)](http://hl7.org/fhir/R4/codesystem-snomedct.html): [AllergyIntolerance/allergyintolerance-eu-core-example](AllergyIntolerance-allergyintolerance-eu-core-example.md), [AllergyIntoleranceEuCore](StructureDefinition-allergyIntolerance-eu-core.md)...Show 25 more,[BodyStructure/example-body-structure-eu](BodyStructure-example-body-structure-eu.md),[BodyStructureEuCore](StructureDefinition-bodyStructure-eu-core.md),[Condition/condition-eu-core-example](Condition-condition-eu-core-example.md),[ConditionEuCore](StructureDefinition-condition-eu-core.md),[Flag/flag-eu-core-example](Flag-flag-eu-core-example.md),[Immunization/immunization-eu-core-example](Immunization-immunization-eu-core-example.md),[ImmunizationEuCore](StructureDefinition-immunization-eu-core.md),[Medication/01A-Cefuroxime1500GenericExplicit](Medication-01A-Cefuroxime1500GenericExplicit.md),[MedicationEuCore](StructureDefinition-medication-eu-core.md),[MedicationIntendedUseEuVs](ValueSet-medicationIntendedUse-eu.md),[MedicationRequest/400C-prescription-cefuroxime-singleline](MedicationRequest-400C-prescription-cefuroxime-singleline.md),[MedicationRequestEuCore](StructureDefinition-medicationRequest-eu-core.md),[MedicationStatement/example-medicationstatement-eucore](MedicationStatement-example-medicationstatement-eucore.md),[MedicationStatementEuCore](StructureDefinition-medicationStatement-eu-core.md),[Observation/763f7902-8103-4d10-8bd1-546a726d43ee](Observation-763f7902-8103-4d10-8bd1-546a726d43ee.md),[Patient/Patient-animal-example](Patient-Patient-animal-example.md),[PatientAnimalEuCore](StructureDefinition-patient-animal-eu-core.md),[PeriodsOfLifeEuVs](ValueSet-periodsOfLife-eu.md),[PractitionerRole/practitionerRole-eu-core-example](PractitionerRole-practitionerRole-eu-core-example.md),[Procedure/procedure-eu-core-example](Procedure-procedure-eu-core-example.md),[ProcedureEuCore](StructureDefinition-procedure-eu-core.md),[ServiceRequest/1d4cbcd1-e0d3-49b6-92d8-1893da8d08e1](ServiceRequest-1d4cbcd1-e0d3-49b6-92d8-1893da8d08e1.md),[SiteLateralityEuVs](ValueSet-siteLaterality-eu.md),[SiteQualifierEuVs](ValueSet-siteQualifier-eu.md)and[SpeciesTypesEuVs](ValueSet-speciesType-eu.md)


* This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: [https://terminology.hl7.org/license.html](https://terminology.hl7.org/license.html)

* [AllergyIntolerance Clinical Status Codes](http://terminology.hl7.org/7.0.1/CodeSystem-allergyintolerance-clinical.html): [AllergyIntolerance/allergyintolerance-eu-core-example](AllergyIntolerance-allergyintolerance-eu-core-example.md)
* [AllergyIntolerance Verification Status](http://terminology.hl7.org/7.0.1/CodeSystem-allergyintolerance-verification.html): [AllergyIntolerance/allergyintolerance-eu-core-example](AllergyIntolerance-allergyintolerance-eu-core-example.md)
* [Common Tags](http://terminology.hl7.org/7.0.1/CodeSystem-common-tags.html): [MedicationRequest/400C-prescription-cefuroxime-singleline](MedicationRequest-400C-prescription-cefuroxime-singleline.md)
* [Condition Category Codes](http://terminology.hl7.org/7.0.1/CodeSystem-condition-category.html): [Condition/condition-eu-core-example](Condition-condition-eu-core-example.md)
* [Condition Clinical Status Codes](http://terminology.hl7.org/7.0.1/CodeSystem-condition-clinical.html): [Condition/condition-eu-core-example](Condition-condition-eu-core-example.md) and [ConditionEuCore](StructureDefinition-condition-eu-core.md)
* [ConditionVerificationStatus](http://terminology.hl7.org/7.0.1/CodeSystem-condition-ver-status.html): [Condition/condition-eu-core-example](Condition-condition-eu-core-example.md) and [ConditionEuCore](StructureDefinition-condition-eu-core.md)
* [Flag Category](http://terminology.hl7.org/7.0.1/CodeSystem-flag-category.html): [Flag/flag-eu-core-example](Flag-flag-eu-core-example.md)
* [Observation Category Codes](http://terminology.hl7.org/7.0.1/CodeSystem-observation-category.html): [MedicalTestResultEuCore](StructureDefinition-medicalTestResult-eu-core.md) and [Observation/763f7902-8103-4d10-8bd1-546a726d43ee](Observation-763f7902-8103-4d10-8bd1-546a726d43ee.md)
* [Organization type](http://terminology.hl7.org/7.0.1/CodeSystem-organization-type.html): [Example Health Organization](Organization-organization-eu-core-example.md)
* [Observation Reference Range Meaning Codes](http://terminology.hl7.org/7.0.1/CodeSystem-referencerange-meaning.html): [Observation/763f7902-8103-4d10-8bd1-546a726d43ee](Observation-763f7902-8103-4d10-8bd1-546a726d43ee.md)
* [diagnosticServiceSectionId](http://terminology.hl7.org/7.0.1/CodeSystem-v2-0074.html): [DiagnosticReportEuCore](StructureDefinition-diagnosticReport-eu-core.md)
* [providerRole](http://terminology.hl7.org/7.0.1/CodeSystem-v2-0443.html): [Immunization/immunization-eu-core-example](Immunization-immunization-eu-core-example.md) and [ImmunizationEuCore](StructureDefinition-immunization-eu-core.md)
* [NullFlavor](http://terminology.hl7.org/7.0.1/CodeSystem-v3-NullFlavor.html): [ImmunizationEuCore](StructureDefinition-immunization-eu-core.md) and [PeriodsOfLifeEuVs](ValueSet-periodsOfLife-eu.md)
* [ObservationInterpretation](http://terminology.hl7.org/7.0.1/CodeSystem-v3-ObservationInterpretation.html): [Observation/763f7902-8103-4d10-8bd1-546a726d43ee](Observation-763f7902-8103-4d10-8bd1-546a726d43ee.md)


* Unless otherwise indicated, reproduction of material posted on Council of Europe websites, and reproduction of photographs for which the Council of Europe holds copyright – see legal notice \“photo credits\” – is authorised for private use and for informational and educational uses relating to the Council of Europe’s work. This authorisation is subject to the condition that the source be indicated and no charge made for reproduction. Persons wishing to make some other use than those specified above, including commercial use, of information and text posted on these sites are asked to apply for prior written authorisation to the Council of Europe, Directorate of Communication.

* [EDQM Standard Terms](http://tx.fhir.org/r4/ValueSet/edqm): [Medication/01A-Cefuroxime1500GenericExplicit](Medication-01A-Cefuroxime1500GenericExplicit.md) and [MedicationEuCore](StructureDefinition-medication-eu-core.md)


