# Laboratory Code - HL7 Europe Base and Core FHIR IG v2.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Laboratory Code**

## ValueSet: Laboratory Code 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/base/ValueSet/lab-obsCode-eu-lab | *Version*:2.0.0-ballot |
| Active as of 2025-12-22 | *Computable Name*:LaboratoryResultStandardEuVs |
| **Copyright/Legal**: This material contains content from LOINC (http://loinc.org). LOINC is copyright © 1995-2020, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the license at http://loinc.org/license. LOINC® is a registered United States trademark of Regenstrief Institute, Inc This material contains content from NPU Terminology (http://npu-terminology.org). NPU is copyright International Federation of Clinical Chemistry (IFCC) and International Union of Pure and Applied Chemistry (IUPAC) and is available at no cost under the license at https://www.labterm.dk/. | |

 
Laboratory observation codes. List of Laboratory observation codes containing LOINC and NPU. 

 **References** 

* [MedicalTestResult (EU core)](StructureDefinition-medicalTestResult-eu-core.md)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "lab-obsCode-eu-lab",
  "url" : "http://hl7.eu/fhir/base/ValueSet/lab-obsCode-eu-lab",
  "version" : "2.0.0-ballot",
  "name" : "LaboratoryResultStandardEuVs",
  "title" : "Laboratory Code",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-22T08:18:42+00:00",
  "publisher" : "HL7 Europe",
  "contact" : [
    {
      "name" : "HL7 Europe",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.eu"
        }
      ]
    }
  ],
  "description" : "Laboratory observation codes. List of Laboratory observation codes containing LOINC and NPU.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "copyright" : "This material contains content from LOINC (http://loinc.org). LOINC is copyright © 1995-2020, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the license at http://loinc.org/license. LOINC® is a registered United States trademark of Regenstrief Institute, Inc \nThis material contains content from NPU Terminology (http://npu-terminology.org). NPU is copyright International Federation of Clinical Chemistry (IFCC) and International Union of Pure and Applied Chemistry (IUPAC) and is available at no cost under the license at https://www.labterm.dk/.",
  "compose" : {
    "include" : [
      {
        "system" : "http://loinc.org"
      },
      {
        "system" : "http://npu-terminology.org"
      }
    ]
  }
}

```
