# Organization (EU core) - HL7 Europe Base and Core FHIR IG v2.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Organization (EU core)**

## Resource Profile: Organization (EU core) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/base/StructureDefinition/organization-eu-core | *Version*:2.0.0-ballot | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:OrganizationEuCore |
| **Copyright/Legal**: Copyright HL7 Europe. Licensed under creative commons public domain (CC0 1.0). | | |

 
This profile sets minimum expectations for the Organization resource common to most of the use cases. 

**Usages:**

* Refer to this Profile: [Composition (EU core)](StructureDefinition-composition-eu-core.md), [DiagnosticReport (EU core)](StructureDefinition-diagnosticReport-eu-core.md), [Immunization (EU core)](StructureDefinition-immunization-eu-core.md), [MedicalTestResult (EU core)](StructureDefinition-medicalTestResult-eu-core.md)...Show 5 more,[MedicationRequest (EU core)](StructureDefinition-medicationRequest-eu-core.md),[MedicationStatement (EU core)](StructureDefinition-medicationStatement-eu-core.md),[Organization (EU core)](StructureDefinition-organization-eu-core.md),[PractitionerRole (EU core)](StructureDefinition-practitionerRole-eu-core.md)and[Procedure (EU core)](StructureDefinition-procedure-eu-core.md)
* Examples for this Profile: [Example Health Organization](Organization-organization-eu-core-example.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.eu.base|current/StructureDefinition/organization-eu-core)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-organization-eu-core.csv), [Excel](StructureDefinition-organization-eu-core.xlsx), [Schematron](StructureDefinition-organization-eu-core.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "organization-eu-core",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-imposeProfile",
      "valueCanonical" : "http://hl7.org/fhir/uv/ips/StructureDefinition/Organization-uv-ips"
    }
  ],
  "url" : "http://hl7.eu/fhir/base/StructureDefinition/organization-eu-core",
  "version" : "2.0.0-ballot",
  "name" : "OrganizationEuCore",
  "title" : "Organization (EU core)",
  "status" : "active",
  "date" : "2025-12-22T08:18:42+00:00",
  "publisher" : "HL7 Europe",
  "contact" : [
    {
      "name" : "HL7 Europe",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.eu"
        }
      ]
    }
  ],
  "description" : "This profile sets minimum expectations for the Organization resource common to most of the use cases.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "copyright" : "Copyright HL7 Europe. Licensed under creative commons public domain (CC0 1.0).",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "servd",
      "uri" : "http://www.omg.org/spec/ServD/1.0/",
      "name" : "ServD"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Organization",
  "baseDefinition" : "http://hl7.eu/fhir/base/StructureDefinition/organization-eu",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Organization",
        "path" : "Organization"
      },
      {
        "id" : "Organization.name",
        "path" : "Organization.name",
        "min" : 1
      },
      {
        "id" : "Organization.partOf",
        "path" : "Organization.partOf",
        "type" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-hierarchy",
                "valueBoolean" : true
              }
            ],
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/base/StructureDefinition/organization-eu-core"
            ]
          }
        ]
      }
    ]
  }
}

```
