# Composition (EU core) - HL7 Europe Base and Core FHIR IG v2.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Composition (EU core)**

## Resource Profile: Composition (EU core) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/base/StructureDefinition/composition-eu-core | *Version*:2.0.0-ballot | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:CompositionEuCore |
| **Copyright/Legal**: Copyright HL7 Europe. Licensed under creative commons public domain (CC0 1.0). | | |

 
This profile sets minimum expectations for the Composition resource for commonly used EHDS documents. 

 
This profile constrains the Composition resource for the purpose of this guide. 

**Usages:**

* Refer to this Profile: [DiagnosticReport (EU core)](StructureDefinition-diagnosticReport-eu-core.md)
* Examples for this Profile: [Composition/26032a57-083a-4ddf-b019-e566ae02f740](Composition-26032a57-083a-4ddf-b019-e566ae02f740.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.eu.base|current/StructureDefinition/composition-eu-core)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-composition-eu-core.csv), [Excel](StructureDefinition-composition-eu-core.xlsx), [Schematron](StructureDefinition-composition-eu-core.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "composition-eu-core",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "http://hl7.eu/fhir/base/StructureDefinition/composition-eu-core",
  "version" : "2.0.0-ballot",
  "name" : "CompositionEuCore",
  "title" : "Composition (EU core)",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-22T08:18:42+00:00",
  "publisher" : "HL7 Europe",
  "contact" : [
    {
      "name" : "HL7 Europe",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.eu"
        }
      ]
    }
  ],
  "description" : "This profile sets minimum expectations for the Composition resource for commonly used EHDS documents.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "purpose" : "This profile constrains the Composition resource for the purpose of this guide.",
  "copyright" : "Copyright HL7 Europe. Licensed under creative commons public domain (CC0 1.0).",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    },
    {
      "identity" : "fhirdocumentreference",
      "uri" : "http://hl7.org/fhir/documentreference",
      "name" : "FHIR DocumentReference"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Composition",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Composition",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Composition",
        "path" : "Composition"
      },
      {
        "id" : "Composition.extension",
        "path" : "Composition.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Composition.extension:version",
        "path" : "Composition.extension",
        "sliceName" : "version",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/5.0/StructureDefinition/extension-Composition.version"
            ]
          }
        ]
      },
      {
        "id" : "Composition.extension:version.extension",
        "path" : "Composition.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Composition.extension:informationRecipient",
        "path" : "Composition.extension",
        "sliceName" : "informationRecipient",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.eu/fhir/StructureDefinition/information-recipient"
            ]
          }
        ]
      },
      {
        "id" : "Composition.extension:informationRecipient.value[x]",
        "path" : "Composition.extension.value[x]",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/base/StructureDefinition/practitioner-eu-core",
              "http://hl7.eu/fhir/base/StructureDefinition/practitionerRole-eu-core",
              "http://hl7.eu/fhir/base/StructureDefinition/organization-eu-core",
              "http://hl7.org/fhir/StructureDefinition/Device",
              "http://hl7.eu/fhir/base/StructureDefinition/patient-eu-core",
              "http://hl7.org/fhir/StructureDefinition/RelatedPerson"
            ]
          }
        ]
      },
      {
        "id" : "Composition.extension:diagnosticReport",
        "path" : "Composition.extension",
        "sliceName" : "diagnosticReport",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.eu/fhir/extensions/StructureDefinition/composition-diagnosticReportReference"
            ]
          }
        ]
      },
      {
        "id" : "Composition.identifier",
        "path" : "Composition.identifier",
        "short" : "Report identifier",
        "definition" : "Identifiers assigned to this report by the performer or other systems. Should remain stable across versions of the report.",
        "min" : 1
      },
      {
        "id" : "Composition.type",
        "path" : "Composition.type",
        "short" : "Type of document/report (e.g. imaging report LOINC)"
      },
      {
        "id" : "Composition.category",
        "path" : "Composition.category",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "short" : "Document Category"
      },
      {
        "id" : "Composition.category:ehds-category",
        "path" : "Composition.category",
        "sliceName" : "ehds-category",
        "short" : "EHDS Priority Category",
        "min" : 0,
        "max" : "*",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.eu/fhir/base/ValueSet/ehdsCategories-eu"
        }
      },
      {
        "id" : "Composition.subject",
        "path" : "Composition.subject",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/base/StructureDefinition/patient-eu-core",
              "http://hl7.org/fhir/StructureDefinition/Group",
              "http://hl7.eu/fhir/base/StructureDefinition/location-eu-core",
              "http://hl7.org/fhir/StructureDefinition/Device"
            ]
          }
        ]
      },
      {
        "id" : "Composition.author",
        "path" : "Composition.author",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/base/StructureDefinition/practitioner-eu-core",
              "http://hl7.eu/fhir/base/StructureDefinition/practitionerRole-eu-core",
              "http://hl7.eu/fhir/base/StructureDefinition/organization-eu-core",
              "http://hl7.org/fhir/StructureDefinition/Device",
              "http://hl7.eu/fhir/base/StructureDefinition/patient-eu-core",
              "http://hl7.org/fhir/StructureDefinition/RelatedPerson"
            ]
          }
        ]
      },
      {
        "id" : "Composition.attester",
        "path" : "Composition.attester",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "mode"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Composition.attester.party",
        "path" : "Composition.attester.party",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/base/StructureDefinition/patient-eu-core",
              "http://hl7.org/fhir/StructureDefinition/RelatedPerson",
              "http://hl7.eu/fhir/base/StructureDefinition/practitioner-eu-core",
              "http://hl7.eu/fhir/base/StructureDefinition/practitionerRole-eu-core",
              "http://hl7.eu/fhir/base/StructureDefinition/organization-eu-core"
            ]
          }
        ]
      },
      {
        "id" : "Composition.attester:legalAuthenticator",
        "path" : "Composition.attester",
        "sliceName" : "legalAuthenticator",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Composition.attester:legalAuthenticator.mode",
        "path" : "Composition.attester.mode",
        "patternCode" : "legal"
      },
      {
        "id" : "Composition.attester:legalAuthenticator.time",
        "path" : "Composition.attester.time",
        "min" : 1
      },
      {
        "id" : "Composition.attester:legalAuthenticator.party",
        "path" : "Composition.attester.party",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/base/StructureDefinition/practitionerRole-eu-core",
              "http://hl7.eu/fhir/base/StructureDefinition/practitioner-eu-core"
            ]
          }
        ]
      },
      {
        "id" : "Composition.attester:resultValidator",
        "path" : "Composition.attester",
        "sliceName" : "resultValidator",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Composition.attester:resultValidator.mode",
        "path" : "Composition.attester.mode",
        "patternCode" : "professional"
      },
      {
        "id" : "Composition.attester:resultValidator.time",
        "path" : "Composition.attester.time",
        "min" : 1
      },
      {
        "id" : "Composition.attester:resultValidator.party",
        "path" : "Composition.attester.party",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/base/StructureDefinition/practitionerRole-eu-core",
              "http://hl7.eu/fhir/base/StructureDefinition/practitioner-eu-core"
            ]
          }
        ]
      },
      {
        "id" : "Composition.custodian",
        "path" : "Composition.custodian",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/base/StructureDefinition/organization-eu-core"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section.extension",
        "path" : "Composition.section.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Composition.section.extension:section-note",
        "path" : "Composition.section.extension",
        "sliceName" : "section-note",
        "short" : "Additional notes that apply to the section (but not to specific resource).",
        "definition" : "Additional notes that apply to the section (but not to specific resource).",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/note"]
          }
        ]
      },
      {
        "id" : "Composition.section.title",
        "path" : "Composition.section.title",
        "min" : 1
      },
      {
        "id" : "Composition.section.code",
        "path" : "Composition.section.code",
        "min" : 1
      },
      {
        "id" : "Composition.section.text",
        "path" : "Composition.section.text",
        "min" : 1
      },
      {
        "id" : "Composition.section.emptyReason",
        "path" : "Composition.section.emptyReason",
        "short" : "Empty reason"
      }
    ]
  }
}

```
