# DiagnosticReport Example - HL7 Europe Base and Core FHIR IG v2.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **DiagnosticReport Example**

## Example DiagnosticReport: DiagnosticReport Example

Profile: [DiagnosticReport (EU core)](StructureDefinition-diagnosticReport-eu-core.md)

## Laboratory report (Chemistry studies (set) ) 

| | |
| :--- | :--- |
| Subject | John Doe Male, DoB: 1980-01-01 |
| Identifier | `http://example.org/composition-ids`/c030702.TSTSMN63A01F205H.20220325112426.TSS1Tkju |

**Report Details**

* **Code**: [Urea (U) [Moles/Vol]](Observation-763f7902-8103-4d10-8bd1-546a726d43ee.md)
  * **Value**: 310 mmol/L(Details: UCUM codemmol/L = 'mmol/L')
  * **Reference Range**: Normal Range: 67 mmol/L - 580 mmol/L
  * **Flags**: Final,Significantly low
  * **When For**: 2023-03-27 11:24:26+0100



## Resource Content

```json
{
  "resourceType" : "DiagnosticReport",
  "id" : "5679723c-4fae-4ba7-9f09-5438a827bfda",
  "meta" : {
    "profile" : [
      "http://hl7.eu/fhir/base/StructureDefinition/diagnosticReport-eu-core"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-DiagnosticReport.composition",
      "valueReference" : {
        "reference" : "Composition/26032a57-083a-4ddf-b019-e566ae02f740"
      }
    }
  ],
  "identifier" : [
    {
      "system" : "http://example.org/composition-ids",
      "value" : "c030702.TSTSMN63A01F205H.20220325112426.TSS1Tkju"
    }
  ],
  "basedOn" : [
    {
      "reference" : "ServiceRequest/1d4cbcd1-e0d3-49b6-92d8-1893da8d08e1"
    }
  ],
  "status" : "registered",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://loinc.org",
          "code" : "18719-5",
          "display" : "Chemistry studies (set)"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "11502-2",
        "display" : "Laboratory report"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/patient-eu-core-example"
  },
  "specimen" : [
    {
      "display" : "Urine specimen"
    }
  ],
  "result" : [
    {
      "reference" : "Observation/763f7902-8103-4d10-8bd1-546a726d43ee"
    }
  ]
}

```
