# EHDSProcedure to FHIR Procedure Mapping - HL7 Europe Base and Core FHIR IG v2.0.0-ballot

* [**Table of Contents**](toc.md)
* **EHDSProcedure to FHIR Procedure Mapping**

## EHDSProcedure to FHIR Procedure Mapping

**Ongoing alignment:**The Xt-EHR logical models are under active revision and continuous refinement. Updates from Xt-EHR will be progressively incorporated into this Implementation Guide to maintain alignment with the evolving EHDS specifications.

**Yellow row/cells:**In this ballot publication, some row/cells of the mapping table have been left in yellow to indicate areas requiring further review or refinement; including feedback from the Xt-EHR joint action (see note above). These highlights will be addressed in subsequent updates to ensure accuracy and completeness of the mappings.

### EHDSProcedure → Procedure

 This page explains how conceptual elements from the EHDS logical model are expressed in the corresponding FHIR ProcedureEuCore profile used by this Implementation Guide. 

**Mapping Context**
*  **Source logical model:** [EHDSProcedure](https://www.xt-ehr.eu/fhir/models/StructureDefinition-EHDSProcedure.html) 
*  **Target FHIR profile:** [ProcedureEuCore](StructureDefinition-procedure-eu-core.md) 

| | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| Element | Description | Relation | Resource | Element | Description | Notes |
| header | Common header for all patient-related data. | related-to | Procedure | . | General metadata. | Dataset-level; not usually carried in Procedure as-is. |
| header.subject | Patient/subject the procedure is about. | equivalent | Procedure | subject | Who the procedure was performed on. | Reference to Patient (or other subject) as in FHIR Procedure.subject. |
| header.identifier | Business identifier for the object. | equivalent | Procedure | identifier | Business identifier for this procedure. | Copy all identifiers if multiple exist. |
| header.authorship | Resource authoring / provenance details. | related-to | Procedure | recorder | Who recorded the procedure. | Procedure has`recorder`and`asserter`, not a generic "author".1.. in the model 0.. in the profile |
| header.authorship.author[x] | Who created/issued the record. | equivalent | Procedure | recorder | Who recorded the procedure. | 1.. in the model 0.. in the profile |
| header.authorship.datetime | Date/time the resource was issued. | equivalent | Procedure | extension:recorded〔R4〕 | Date when the procedure was recorded | FHIR R5 Procedure supports`recorded`; pre-adopted this element in R4.1.. in the model 0.. in the profile. |
| header.authorship.datetime | Date/time the resource was issued. | equivalent | Procedure | recorded〔R5〕 | Date when the procedure was recorded | FHIR R5 Procedure supports`recorded`; pre-adopted this element in R4.1.. in the model 0.. in the profileTO BE CHECKED |
| header.lastUpdate | Last technical correction/update. | source-is-broader-than-target | Procedure | meta.lastUpdated | Last system update timestamp. | Waiting for Xt-EHR feedback |
| header.status | Technical/administrative dataset status. | no map | Procedure | - | - | Waiting for Xt-EHR feedback |
| header.statusReason[x] | Reason for current dataset status. | no map | Procedure | - | - | Waiting for Xt-EHR feedback |
| header.language | Language of the resource (IETF tag). | equivalent | Procedure | language | Language used in text/narrative. |  |
| code | Code identifying the procedure. | equivalent | Procedure | code | Procedure code. |  |
| date[x] | Date and time of the procedure or interval of its performance. | equivalent | Procedure | performed[x]〔R4〕 | When the procedure was performed. | Use`performedDateTime`or`performedPeriod`according to actual data type.`performed[x]`used in R4,`occurrence[x]`used in R5 |
| date[x] | Date and time of the procedure or interval of its performance. | equivalent | Procedure | occurrence[x]〔R5〕 | When the procedure was performed. | Use`occurrenceDateTime`or`occurrencePeriod`according to actual data type.`performed[x]`used in R4,`occurrence[x]`used in R5 |
| performer | An actor who performed the procedure. | equivalent | Procedure | performer | Who performed the procedure and in what role. | FHIR Procedure.performer.actor → Practitioner / PractitionerRole / Organization; add role if available. |
| bodySite | Procedure target body site; may include laterality. | equivalent | Procedure | bodySite | Target body site. | Map EHDSBodyStructure → one or more`Procedure.bodySite`; laterality as qualifier. |
| reason[x] | The reason why the procedure was performed (code or reference). | equivalent | Procedure | reasonCode / reasonReference〔R4〕 | Indication/justification for the procedure. | In R4, codes go to`reasonCode`; references (Condition / Observation / Procedure) go to`reasonReference`. |
| reason[x] | The reason why the procedure was performed (code or reference). | equivalent | Procedure | reason〔R5〕 | Indication/justification for the procedure. | In R5 use the CodeableReference`reason`. |
| outcome | The outcome of the procedure – did it resolve the reasons? | equivalent | Procedure | outcome | The result of the procedure. | CodeableConcept; EHDS prefers SNOMED CT. |
| complication | Any complications during or immediately after the procedure. | equivalent | Procedure | complication / complicationDetail〔R4〕 | Complication(s) following the procedure. | In R4 codes go to`complication`; reference (Condition) in`complicationDetail`. |
| complication | Any complications during or immediately after the procedure. | equivalent | Procedure | complication〔R5〕 | Complication(s) following the procedure. | In R5 use the CodeableReference`complication`. |
| deviceUsed | Device used to perform the procedure. | equivalent | Procedure | usedCode / usedReference〔R4〕 | Device that was used during the procedure. | In R4`usedCode`only if you have no Device instance,`usedReference`if you refer a Device. |
| deviceUsed | Device used to perform the procedure. | equivalent | Procedure | used〔R5〕 | Device that was used during the procedure. | In R5 use the CodeableReference`used`. |
| focalDevice | Device that is the focus of the procedure (implanted, removed, calibrated, etc.). | equivalent | Procedure | focalDevice.manipulated | Manipulated/targeted device during the procedure. | Matches FHIR Procedure.focalDevice exactly. |
| note | Additional information about the procedure. | equivalent | Procedure | note | Comments about the procedure. | EHDS has 0..1 string; FHIR allows 0..* Annotation → map to one Annotation entry. |

 Return to overview: [EHDS Logical Models → FHIR Profiles](modelmap.md) 

