# EHDSMedication to FHIR Medication Mapping - HL7 Europe Base and Core FHIR IG v2.0.0-ballot

* [**Table of Contents**](toc.md)
* **EHDSMedication to FHIR Medication Mapping**

## EHDSMedication to FHIR Medication Mapping

# EHDSMedication → Medication

**Ongoing alignment:**The Xt-EHR logical models are under active revision and continuous refinement. Updates from Xt-EHR will be progressively incorporated into this Implementation Guide to maintain alignment with the evolving EHDS specifications.

**Yellow row/cells:**In this ballot publication, some row/cells of the mapping table have been left in yellow to indicate areas requiring further review or refinement; including feedback from the Xt-EHR joint action (see note above). These highlights will be addressed in subsequent updates to ensure accuracy and completeness of the mappings.

### EHDSMedication → Medication

 This page explains how conceptual elements from the EHDS logical model are expressed in the corresponding FHIR MedicationEuCore and OrganizationEuCore profiles used by this Implementation Guide. 

**Mapping Context**
*  **Source logical model:** [EHDSMedication](https://www.xt-ehr.eu/fhir/models/StructureDefinition-EHDSMedication.html) 
*  **Target FHIR profiles:** [MedicationEuCore](StructureDefinition-medication-eu-core.md), [OrganizationEuCore](StructureDefinition-organization-eu-core.md) 

The model supports prescribed/dispensed medication and can represent both generic (virtual) products and branded (real) products.

| | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| Element | Description | Relation | Resource | Element | Description | Notes |
| identifyingCodeCodeableConcept | Identifier or code for the product (virtual/branded/package). | equivalent | Medication | code | Code that identifies this medication. |  |
| identifyingCodeIdentifier | Identifier for the product (virtual/branded/package). | equivalent | Medication | identifier | Business identifiers for the medication entry. | Use multiple identifiers if needed; avoid conflicting meanings. |
| classification | Classification (e.g. ATC; narcotic/psychotropic; orphan drug). | equivalent | Medication | extension:classification | Classifications of the product, e.g ATC, narcotic/psychotropic, orphan drug, etc |  |
| productName | Name of the product (full/invented/other). | equivalent | Medication | extension:productName | Text representation of the medication name. | Official name of branded medicinal product. |
| marketingAuthorisationHolder | Marketing authorisation holder / manufacturer. | equivalent | Medication | manufacturer〔R4〕 | Manufacturer of the item. | Reference to`Organization`. |
| marketingAuthorisationHolder | Marketing authorisation holder / manufacturer. | equivalent | Medication | marketingAuthorizationHolder〔R5〕 | Organization that has authorization to market medication. | Reference to`Organization`. |
| marketingAuthorisationHolder.organisationName | Name of the MAH/manufacturing organisation. | equivalent | Organization | name | Name used for the organization. | Populate the referenced Organization's`name`. |
| marketingAuthorisationHolder.organisationIdentifier | Identifier of the MAH/manufacturing organisation. | equivalent | Organization | identifier | Identifies this organization across multiple systems |  |
| doseForm | Dose form(s) on a product level. | equivalent | Medication | form | Dose form of the medication. |  |
| packSize | Overall amount of product in one package. | related-to | Medication | amount〔R4〕 | Amount of the medication in the package. | R4`amount`is a Ratio; in R5`totalVolume`. |
| packSize | Overall amount of product in one package. | related-to | Medication | totalVolume〔R5〕 | When the specified product code does not infer a package size, this is the specific amount of drug in the product. | R4`amount`is a Ratio; in R5`totalVolume` |
| item | A medication item (components in a combination pack). | equivalent | Medication | ingredient.item | A particular constituent of interest in the product. | An item - included in a product - is represented by a Medication resource referenced by the`ingredient.item`(see the example at https://hl7.eu/fhir/mpd-r5/Medication-02A-ClotrimazoleCanifugCremolum.html). If the item is the product, the item is the Medication itself. |
| item.doseForm | Dose form of the manufactured item. | equivalent | Medication | doseForm | Dose Form | See note above about*item* |
| item.ingredient | Ingredients of the item. | equivalent | Medication | ingredient | Medication ingredients. | Replicate per-item ingredients into`ingredient`. See note above about*item* |
| item.ingredient.isActive | Marks if the ingredient is active. | equivalent | Medication | ingredient.isActive | Is this an active ingredient. | Replicate per-item ingredients into`ingredient`. See note above about*item* |
| item.ingredient.substance | Substance. | equivalent | Medication | ingredient.itemCodeableConcept | The substance of the ingredient. | Replicate per-item ingredients into`ingredient`. See note above about*item* |
| item.ingredient.strengthInfo.strength | Strength of the substance. | equivalent | Medication | ingredient.strengthRatio | Quantity of ingredient present. | Replicate per-item ingredients into`ingredient`. See note above about*item* |
| item.ingredient.strengthInfo.basisOfStrengthSubstance | Substance the strength refers to (if different). | equivalent | Medication | ingredient.strength[x].extension:basisOfStrengthSubstance | Substance the strength refers to (if different). | Replicate per-item ingredients into`ingredient`. See note above about*item* |
| item.unitOfPresentation | Unit of presentation for the manufactured item. | equivalent | Medication | extension:unitOfPresentation | Unit of presentation | See note above about*item* |
| item.containedQuantity | Quantity for liquids (e.g., 3ml / 1 vial). | equivalent | Medication | extension:sizeOfItem | Size of one item (for example, in a pack of 5 vials, this would represent the size of 1 vial). | See note above about*item* |
| item.amount | Number of such manufactured items in this product. | equivalent | Medication | amount〔R4〕 | Amount of the medication in the package. | See note above about*item* |
| item.amount | Number of such manufactured items in this product. | equivalent | Medication | totalVolume〔R5〕 | When the specified product code does not infer a package size, this is the specific amount of drug in the product. | See note above about*item* |
| item.packageType | Type of package of the medication item. | equivalent | Medication | extension:packageType | Type of packaging. | See note above about*item* |
| device | Administration device included in the product. | equivalent | Medication | extension:device | Device |  |
| device.deviceQuantity | Number of such devices. | equivalent | Medication | extension:device.extension:quantity |  |  |
| device.device[x] | Device coded (codeable concept or reference). | equivalent | Medication | extension:device.extension:device.value[x] |  |  |
| characteristic | Other features of the product. | equivalent | Medication | extension:characteristic | Characteristics of the medication. |  |
| characteristic.type | Type of characteristic. | equivalent | Medication | extension:characteristic.extension:type | Type of characteristic. |  |
| characteristic.value[x] | Value of the characteristic. | equivalent | Medication | extension:characteristic.extension:value | Value of the characteristic. | Supports boolean, CodeableConcept, string, Quantity, dateTime, integer, decimal, Ratio in R5 |
| batch.lotNumber | Batch identifier of the medicinal product. | equivalent | Medication | batch.lotNumber | Lot number of a particular batch. | Traceability / pharmacovigilance. |
| batch.expirationDate | Batch expiration date of the medicinal product. | equivalent | Medication | batch.expirationDate | When the batch expires. |  |

 Return to overview: [EHDS Logical Models → FHIR Profiles](modelmap.md) 

