# EHDSAllergyIntolerance to FHIR AllergyIntolerance Mapping - HL7 Europe Base and Core FHIR IG v2.0.0-ballot

* [**Table of Contents**](toc.md)
* **EHDSAllergyIntolerance to FHIR AllergyIntolerance Mapping**

## EHDSAllergyIntolerance to FHIR AllergyIntolerance Mapping

# EHDSAllergyIntolerance → AllergyIntolerance

**Ongoing alignment:**The Xt-EHR logical models are under active revision and continuous refinement. Updates from Xt-EHR will be progressively incorporated into this Implementation Guide to maintain alignment with the evolving EHDS specifications.

**Yellow row/cells:**In this ballot publication, some row/cells of the mapping table have been left in yellow to indicate areas requiring further review or refinement; including feedback from the Xt-EHR joint action (see note above). These highlights will be addressed in subsequent updates to ensure accuracy and completeness of the mappings.

### EHDSAllergyIntolerance → AllergyIntolerance

 This page explains how conceptual elements from the EHDS logical model are expressed in the corresponding FHIR AllergyIntoleranceEuCore profile used by this Implementation Guide. 

**Mapping Context**
*  **Source logical model:** [EHDSAllergyIntolerance](https://www.xt-ehr.eu/fhir/models/StructureDefinition-EHDSAllergyIntolerance.html) 
*  **Target FHIR profile:** [AllergyIntoleranceEuCore](StructureDefinition-allergyIntolerance-eu-core.md) 

| | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| Element | Description | Relation | Resource | Element | Description | Notes |
| header | Common header for all patient-related data. | related-to | AllergyIntolerance | . | General metadata. | Dataset-level; not usually carried in AllergyIntolerance as-is. |
| header.subject | Patient/subject this alert is about. | equivalent | AllergyIntolerance | subject | Reference to the patient or subject of the allergy/intolerance. | Reference to Patient (or other subject). |
| header.identifier | Business identifier for the object. | equivalent | AllergyIntolerance | identifier | Business identifier for this allergy. | Copy over all identifiers if multiple. |
| header.authorship | Resource authoring details | related-to | AllergyIntolerance | recorder | Author of the allergy/intolerance record. | Can reference Device, Organization, Patient, Practitioner, or PractitionerRole.1.. in the model 0.. in the profile |
| header.authorship.author[x] | Who created/issued the alert. | equivalent | AllergyIntolerance | recorder | Who recorded the sensitivity. | Can reference Device, Organization, Patient, Practitioner, or PractitionerRole.1.. in the model 0.. in the profile |
| header.authorship.datetime | Date/time the resource was issued. | equivalent | AllergyIntolerance | recordedDate | When the allergy/intolerance was recorded. | 1.. in the model 0.. in the profile |
| header.lastUpdate | Last technical correction/update. | related-to | AllergyIntolerance | meta.lastUpdated | When the resource version last changed | The map applies only in case it represents when the resource was last updated. It is an Instant (i.e. YYYY-MM-DDThh:mm:ss.sss+zz:zz ) |
| header.status | Status of the dataset/resource. | no map | AllergyIntolerance |  |  | Suggested to be removed see[Review and Align Use of header.status and header.statusReason[x]](https://github.com/Xt-EHR/xt-ehr-common/issues/363) |
| header.statusReason[x] | Reason for current dataset status. | no map | AllergyIntolerance |  |  | Suggested to be removed see[Review and Align Use of header.status and header.statusReason[x]](https://github.com/Xt-EHR/xt-ehr-common/issues/363) |
| header.language | Language of the resource (IETF tag). | equivalent | AllergyIntolerance | language | Language used in the flag text. |  |
| agentOrAllergen | A specific allergen or other agent/substance (drug, food, chemical agent, etc.) to which the patient has an adverse reaction propensity. | equivalent | AllergyIntolerance | code | Concept that identifies the substance, product, or agent responsible. | CodeableConcept. Bound in EHDS to eHDSI value sets; in FHIR usually VS: AllergyIntolerance Substance/Product. |
| typeOfPropensity | Describes whether the condition refers to an allergy, intolerance, or unknown class. | equivalent | AllergyIntolerance | type | Allergy vs intolerance. | Maps to`AllergyIntolerance.type`(allergy | intolerance | ...). Value sets: eHDSIAdverseEventType / HL7. |
| description | Textual description of the allergy or intolerance. | source-is-broader-than-target | AllergyIntolerance | note.text | Additional narrative about the allergy/intolerance. | The mapping applies if the text represents additional information collected about the allergy.FHIR doesn't have a single free-text "description" element; use`AllergyIntolerance.note`(0..*). Could also populate`text.div`if it refer to a textual description of the whole resource. |
| criticality | Estimate of the potential clinical harm, or seriousness, of a reaction. | equivalent | AllergyIntolerance | criticality | Estimate of potential clinical harm. | ValueSets in EHDS reference eHDSICriticality; FHIR has its own required VS. |
| certainty | Assertion about the certainty associated with the propensity (diagnostic/clinical evidence). | equivalent | AllergyIntolerance | verificationStatus | Clinical verification status of the allergy/intolerance. | EHDS name "certainty" ≈ FHIR "verificationStatus" (confirmed / refuted / unconfirmed). |
| status | Current status of the allergy or intolerance (active, in remission, resolved, etc.). | equivalent | AllergyIntolerance | clinicalStatus | Clinical status of the allergy/intolerance. | EHDS "status" → FHIR "clinicalStatus". Both point to the clinical/temporal lifecycle. |
| onsetDate | When the allergy or intolerance was identified. | equivalent | AllergyIntolerance | onset[x] | When the allergy/intolerance was identified or first became relevant. | FHIR supports multiple datatypes; here you have dateTime → map to`onsetDateTime`. |
| endDate | Date of resolution of the allergy (when it was deemed no longer necessary to track). | equivalent | AllergyIntolerance | extension:abatement | Date and/or time of the last known occurrence of a reaction. |  |
| reaction | Adverse Reaction Events linked to exposure to substance. | equivalent | AllergyIntolerance | reaction | Details about each adverse reaction event. | 0..* in both models. |
| reaction.manifestation | Description of the clinical manifestation of the allergic reaction (e.g. anaphylactic shock, angioedema). | equivalent | AllergyIntolerance | reaction.manifestation | Clinical symptoms and/or signs that are observed during the reaction. | CodeableConcept; EHDS allows multiple; FHIR reaction.manifestation is 1..* CodeableConcept. |
| reaction.date | Date and time of allergy manifestation. | no-map | AllergyIntolerance |  |  | The difference between reaction.date and reaction.onsetDate is not clear no mapped for the time being |
| reaction.severity | Severity of the clinical manifestation. | equivalent | AllergyIntolerance | reaction.severity | Mild / moderate / severe. | FHIR has required VS; EHDS references eHDSISeverity. |
| reaction.onsetDate | Date of the observation of the reaction. | equivalent | AllergyIntolerance | reaction.onset | When the reaction occurred. | EHDS distinguishes "date of observation"; FHIR has one`reaction.onset`use that. |

 Return to overview: [EHDS Logical Models → FHIR Profiles](modelmap.md) 

