# hl7.fhir.eu.base#2.0.0-ballot: HL7 Europe Base and Core FHIR IG

## Pages

* [Home](index.md)
* [EHDSDocument to FHIR DiagnosticReport Mapping](map-ehdsdocument-report.md)
* [EHDSAddress to FHIR Address Mapping](map-ehdsaddress.md)
* [Model Map](modelmap.md)
* [EHDSProcedure to FHIR Procedure Mapping](map-ehdsprocedure.md)
* [EHDSPatientAnimal to FHIR Patient (Animal) Mapping](map-ehdspatientanimal.md)
* [EHDSImmunisation to FHIR Immunization Mapping](map-ehdsimmunisation.md)
* [EHDSObservation to FHIR Observation Mapping](map-ehdsobservation.md)
* [Handling Missing Data](missing-data.md)
* [EHDSOrganisation to FHIR Organization Mapping](map-ehdsorganisation.md)
* [EHDSAllergyIntolerance to FHIR AllergyIntolerance Mapping](map-ehdsallergyintolerance.md)
* [EHDSBodyStructure to FHIR BodyStructure Mapping](map-ehdsbodystructure.md)
* [EHDSDocument to FHIR Composition Mapping](map-ehdsdocument.md)
* [Cross-version Analysis](crossversionanalysis.md)
* [Change Log](changes.md)
* [Dependencies](dependencies.md)
* [EHDSMedication to FHIR Medication Mapping](map-ehdsmedication.md)
* [Copyright](copyright.md)
* [EHDSAlert to FHIR Flag Mapping](map-ehdsalert.md)
* [Introduction](introduction.md)
* [Logical Models](logicalmodels.md)
* [EHDSHealthProfessional to FHIR PractitionerRole, Practitioner Mapping](map-ehdshealthprofessional.md)
* [Known/Open Issues](knownissues.md)
* [Authors and Contributors](authors.md)
* [EHDSLocation to FHIR Location Mapping](map-ehdslocation.md)
* [EHDSMedicationStatement to FHIR MedicationStatement Mapping](map-ehdsmedicationstatement.md)
* [EHDSPatient to FHIR Patient Mapping](map-ehdspatient.md)
* [EHDSHumanName to FHIR HumanName Mapping](map-ehdshumanname.md)
* [EHDSMedicationprescription to FHIR MedicationRequest Mapping](map-ehdsmedicationprescription.md)
* [Artifacts Summary](artifacts.md)
* [Downloads](downloads.md)
* [EHDSCondition to FHIR Condition Mapping](map-ehdscondition.md)
* [EHDSTelecom to FHIR ContactPoint Mapping](map-ehdstelecom.md)

## Resources

### ValueSets

* [EHDS Categories](ValueSet-ehdsCategories-eu.md)
* [Laboratory Code](ValueSet-lab-obsCode-eu-lab.md)
* [Medication Intended Use](ValueSet-medicationIntendedUse-eu.md)
* [Periods of Life](ValueSet-periodsOfLife-eu.md)
* [Body Structure Laterality](ValueSet-siteLaterality-eu.md)
* [Body Structure Qualifier](ValueSet-siteQualifier-eu.md)
* [Types of species](ValueSet-speciesType-eu.md)

### Complex-type Profiles

* [Address (EU)](StructureDefinition-Address-eu.md)

### Resource Profiles

* [Allergy Intolerance (EU core)](StructureDefinition-allergyIntolerance-eu-core.md)
* [BodyStructure (EU core)](StructureDefinition-bodyStructure-eu-core.md)
* [Composition (EU core)](StructureDefinition-composition-eu-core.md)
* [Condition (EU core)](StructureDefinition-condition-eu-core.md)
* [DiagnosticReport (EU core)](StructureDefinition-diagnosticReport-eu-core.md)
* [Flag (EU core)](StructureDefinition-flag-eu-core.md)
* [Immunization (EU core)](StructureDefinition-immunization-eu-core.md)
* [Location (EU core)](StructureDefinition-location-eu-core.md)
* [MedicalTestResult (EU core)](StructureDefinition-medicalTestResult-eu-core.md)
* [Medication (EU core)](StructureDefinition-medication-eu-core.md)
* [MedicationRequest (EU core)](StructureDefinition-medicationRequest-eu-core.md)
* [MedicationStatement (EU core)](StructureDefinition-medicationStatement-eu-core.md)
* [Organization (EU core)](StructureDefinition-organization-eu-core.md)
* [Organization (EU base)](StructureDefinition-organization-eu.md)
* [Patient: Animal (EU core)](StructureDefinition-patient-animal-eu-core.md)
* [Patient (EU core)](StructureDefinition-patient-eu-core.md)
* [Patient (EU base)](StructureDefinition-patient-eu.md)
* [Practitioner (EU core)](StructureDefinition-practitioner-eu-core.md)
* [Practitioner (EU base)](StructureDefinition-practitioner-eu.md)
* [PractitionerRole (EU core)](StructureDefinition-practitionerRole-eu-core.md)
* [PractitionerRole (EU base)](StructureDefinition-practitionerRole-eu.md)
* [Procedure (EU core)](StructureDefinition-procedure-eu-core.md)

### ImplementationGuides

* [HL7 Europe Base and Core FHIR IG](index.md)

### Examples

* [allergyintolerance-eu-core-example (AllergyIntolerance)](AllergyIntolerance-allergyintolerance-eu-core-example.md)
* [example-body-structure-eu (BodyStructure)](BodyStructure-example-body-structure-eu.md)
* [Laboratorní zpráva (Composition)](Composition-26032a57-083a-4ddf-b019-e566ae02f740.md)
* [condition-eu-core-example (Condition)](Condition-condition-eu-core-example.md)
* [5679723c-4fae-4ba7-9f09-5438a827bfda (DiagnosticReport)](DiagnosticReport-5679723c-4fae-4ba7-9f09-5438a827bfda.md)
* [flag-eu-core-example (Flag)](Flag-flag-eu-core-example.md)
* [immunization-eu-core-example (Immunization)](Immunization-immunization-eu-core-example.md)
* [Best Location (Location)](Location-example-location.md)
* [01A-Cefuroxime1500GenericExplicit (Medication)](Medication-01A-Cefuroxime1500GenericExplicit.md)
* [400C-prescription-cefuroxime-singleline (MedicationRequest)](MedicationRequest-400C-prescription-cefuroxime-singleline.md)
* [example-medicationstatement-eucore (MedicationStatement)](MedicationStatement-example-medicationstatement-eucore.md)
* [763f7902-8103-4d10-8bd1-546a726d43ee (Observation)](Observation-763f7902-8103-4d10-8bd1-546a726d43ee.md)
* [Example Health Organization (Organization)](Organization-organization-eu-core-example.md)
* [Patient-animal-example (Patient)](Patient-Patient-animal-example.md)
* [patient-eu-core-example (Patient)](Patient-patient-eu-core-example.md)
* [practitioner-eu-core-example (Practitioner)](Practitioner-practitioner-eu-core-example.md)
* [practitionerRole-eu-core-example (PractitionerRole)](PractitionerRole-practitionerRole-eu-core-example.md)
* [procedure-eu-core-example (Procedure)](Procedure-procedure-eu-core-example.md)
* [1d4cbcd1-e0d3-49b6-92d8-1893da8d08e1 (ServiceRequest)](ServiceRequest-1d4cbcd1-e0d3-49b6-92d8-1893da8d08e1.md)
