# Patient: Animal (EU core) - HL7 Europe Base and Core FHIR IG v2.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Patient: Animal (EU core)**

## Resource Profile: Patient: Animal (EU core) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/base/StructureDefinition/patient-animal-eu-core | *Version*:2.0.0-ballot | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:PatientAnimalEuCore |
| **Copyright/Legal**: Copyright HL7 Europe. Licensed under creative commons public domain (CC0 1.0). | | |

 
This profile defines how to represent an Animal as subject of care in FHIR for the purpose of this guide. This is used to identify the species when a specimen is collected from an animal 

**Usages:**

* Refer to this Profile: [DiagnosticReport (EU core)](StructureDefinition-diagnosticReport-eu-core.md)
* Examples for this Profile: [Patient/Patient-animal-example](Patient-Patient-animal-example.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.eu.base|current/StructureDefinition/patient-animal-eu-core)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-patient-animal-eu-core.csv), [Excel](StructureDefinition-patient-animal-eu-core.xlsx), [Schematron](StructureDefinition-patient-animal-eu-core.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "patient-animal-eu-core",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use"
    }
  ],
  "url" : "http://hl7.eu/fhir/base/StructureDefinition/patient-animal-eu-core",
  "version" : "2.0.0-ballot",
  "name" : "PatientAnimalEuCore",
  "title" : "Patient: Animal (EU core)",
  "status" : "active",
  "date" : "2025-12-22T08:18:42+00:00",
  "publisher" : "HL7 Europe",
  "contact" : [
    {
      "name" : "HL7 Europe",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.eu"
        }
      ]
    }
  ],
  "description" : "This profile defines how to represent an Animal as subject of care in FHIR for the purpose of this guide.\nThis is used to identify the species when a specimen is collected from an animal",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "copyright" : "Copyright HL7 Europe. Licensed under creative commons public domain (CC0 1.0).",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "loinc",
      "uri" : "http://loinc.org",
      "name" : "LOINC code for the element"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Patient",
  "baseDefinition" : "http://hl7.eu/fhir/base/StructureDefinition/patient-eu",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Patient",
        "path" : "Patient",
        "short" : "Information about an animal receiving health care services"
      },
      {
        "id" : "Patient.extension",
        "path" : "Patient.extension",
        "min" : 1
      },
      {
        "id" : "Patient.extension:patient-animal",
        "path" : "Patient.extension",
        "sliceName" : "patient-animal",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/patient-animal"]
          }
        ]
      },
      {
        "id" : "Patient.extension:patient-animal.extension:species",
        "path" : "Patient.extension.extension",
        "sliceName" : "species"
      },
      {
        "id" : "Patient.extension:patient-animal.extension:species.value[x]",
        "path" : "Patient.extension.extension.value[x]",
        "binding" : {
          "strength" : "example",
          "valueSet" : "http://hl7.eu/fhir/base/ValueSet/speciesType-eu"
        }
      },
      {
        "id" : "Patient.extension:recordedSexOrGender",
        "path" : "Patient.extension",
        "sliceName" : "recordedSexOrGender",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/StructureDefinition/individual-recordedSexOrGender"
            ]
          }
        ]
      },
      {
        "id" : "Patient.identifier",
        "path" : "Patient.identifier",
        "short" : "Animal identifier"
      },
      {
        "id" : "Patient.telecom",
        "path" : "Patient.telecom",
        "short" : "Use contact.telecom",
        "comment" : "Animals do not have phones, their contacts do. Contact.telecom should be used.",
        "max" : "0"
      },
      {
        "id" : "Patient.deceased[x]",
        "path" : "Patient.deceased[x]",
        "short" : "Deceased status"
      },
      {
        "id" : "Patient.maritalStatus",
        "path" : "Patient.maritalStatus",
        "max" : "0"
      },
      {
        "id" : "Patient.communication",
        "path" : "Patient.communication",
        "max" : "0"
      }
    ]
  }
}

```
