# Immunization (EU core) - HL7 Europe Base and Core FHIR IG v2.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Immunization (EU core)**

## Resource Profile: Immunization (EU core) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/base/StructureDefinition/immunization-eu-core | *Version*:2.0.0-ballot | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:ImmunizationEuCore |
| **Copyright/Legal**: Copyright HL7 Europe. Licensed under creative commons public domain (CC0 1.0). | | |

 
This profile sets minimum expectations for the Immunization resource common to most of the use cases. 

 
This profile constrains the Immunization resource for the purpose of this guide. 

**Usages:**

* Examples for this Profile: [Immunization/immunization-eu-core-example](Immunization-immunization-eu-core-example.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.eu.base|current/StructureDefinition/immunization-eu-core)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-immunization-eu-core.csv), [Excel](StructureDefinition-immunization-eu-core.xlsx), [Schematron](StructureDefinition-immunization-eu-core.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "immunization-eu-core",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "http://hl7.eu/fhir/base/StructureDefinition/immunization-eu-core",
  "version" : "2.0.0-ballot",
  "name" : "ImmunizationEuCore",
  "title" : "Immunization (EU core)",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-22T08:18:42+00:00",
  "publisher" : "HL7 Europe",
  "contact" : [
    {
      "name" : "HL7 Europe",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.eu"
        }
      ]
    }
  ],
  "description" : "This profile sets minimum expectations for the Immunization resource common to most of the use cases.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "purpose" : "This profile constrains the Immunization resource for the purpose of this guide.",
  "copyright" : "Copyright HL7 Europe. Licensed under creative commons public domain (CC0 1.0).",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Immunization",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Immunization",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Immunization",
        "path" : "Immunization"
      },
      {
        "id" : "Immunization.extension",
        "path" : "Immunization.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Immunization.extension:administeredProduct",
        "path" : "Immunization.extension",
        "sliceName" : "administeredProduct",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/5.0/StructureDefinition/extension-Immunization.administeredProduct"
            ]
          }
        ]
      },
      {
        "id" : "Immunization.extension:administeredProduct.extension:reference",
        "path" : "Immunization.extension.extension",
        "sliceName" : "reference"
      },
      {
        "id" : "Immunization.extension:administeredProduct.extension:reference.extension",
        "path" : "Immunization.extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Immunization.extension:administeredProduct.extension:reference.value[x]",
        "path" : "Immunization.extension.extension.value[x]",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/base/StructureDefinition/medication-eu-core"
            ]
          }
        ]
      },
      {
        "id" : "Immunization.extension:administeredProduct.value[x]",
        "path" : "Immunization.extension.value[x]",
        "max" : "0"
      },
      {
        "id" : "Immunization.status",
        "path" : "Immunization.status",
        "short" : "Immunization status."
      },
      {
        "id" : "Immunization.statusReason",
        "path" : "Immunization.statusReason",
        "short" : "Reason for not performing."
      },
      {
        "id" : "Immunization.vaccineCode",
        "path" : "Immunization.vaccineCode",
        "binding" : {
          "extension" : [
            {
              "extension" : [
                {
                  "url" : "purpose",
                  "valueCode" : "candidate"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://hl7.org/fhir/uv/ips/ValueSet/vaccines-whoatc-uv-ips"
                },
                {
                  "url" : "documentation",
                  "valueMarkdown" : "Additional conformance binding to a vaccines value set from the WHO ATC code system for use in specific jurisdictional or other contexts where use of the ATC terminology is preferred."
                },
                {
                  "url" : "shortDoco",
                  "valueString" : "For when WHO ATC code system is preferred"
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            },
            {
              "extension" : [
                {
                  "url" : "purpose",
                  "valueCode" : "candidate"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://terminology.ehdsi.eu/ValueSet/eHDSIVaccine"
                },
                {
                  "url" : "documentation",
                  "valueMarkdown" : "Additional conformance binding to the cross-border vaccines value set."
                },
                {
                  "url" : "shortDoco",
                  "valueString" : "For EU cross-border use"
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            }
          ],
          "strength" : "preferred",
          "description" : "The type of vaccine for particular disease or diseases against which the patient has been immunised, or a code for absent/unknown immunization.",
          "valueSet" : "http://hl7.org/fhir/uv/ips/ValueSet/vaccines-uv-ips"
        }
      },
      {
        "id" : "Immunization.patient",
        "path" : "Immunization.patient",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/base/StructureDefinition/patient-eu-core"
            ]
          }
        ]
      },
      {
        "id" : "Immunization.occurrence[x]",
        "path" : "Immunization.occurrence[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "short" : "Date of vaccination"
      },
      {
        "id" : "Immunization.occurrence[x]:occurrenceDateTime",
        "path" : "Immunization.occurrence[x]",
        "sliceName" : "occurrenceDateTime",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "Immunization.occurrence[x]:occurrenceDateTime.extension",
        "path" : "Immunization.occurrence[x].extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Immunization.occurrence[x]:occurrenceDateTime.extension:periodOfLife",
        "path" : "Immunization.occurrence[x].extension",
        "sliceName" : "periodOfLife",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.eu/fhir/extensions/StructureDefinition/periods-of-life"
            ]
          }
        ]
      },
      {
        "id" : "Immunization.occurrence[x]:occurrenceDateTime.extension:periodOfLife.value[x]",
        "path" : "Immunization.occurrence[x].extension.value[x]",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.eu/fhir/base/ValueSet/periodsOfLife-eu"
        }
      },
      {
        "id" : "Immunization.location",
        "path" : "Immunization.location",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/base/StructureDefinition/location-eu-core"
            ]
          }
        ]
      },
      {
        "id" : "Immunization.manufacturer",
        "path" : "Immunization.manufacturer",
        "short" : "Vaccine manufacturer/MAH"
      },
      {
        "id" : "Immunization.lotNumber",
        "path" : "Immunization.lotNumber",
        "short" : "Batch/lot number"
      },
      {
        "id" : "Immunization.performer",
        "path" : "Immunization.performer",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "$this.function"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Immunization.performer:administeringCentreOrHp",
        "path" : "Immunization.performer",
        "sliceName" : "administeringCentreOrHp",
        "short" : "Administering centre",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Immunization.performer:administeringCentreOrHp.function",
        "path" : "Immunization.performer.function",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v2-0443",
              "code" : "AP"
            }
          ]
        }
      },
      {
        "id" : "Immunization.performer:administeringCentreOrHp.actor",
        "path" : "Immunization.performer.actor",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/base/StructureDefinition/organization-eu-core",
              "http://hl7.eu/fhir/base/StructureDefinition/practitionerRole-eu-core",
              "http://hl7.eu/fhir/base/StructureDefinition/practitioner-eu-core"
            ]
          }
        ]
      },
      {
        "id" : "Immunization.reasonCode",
        "path" : "Immunization.reasonCode",
        "short" : "Reasons for the administration."
      },
      {
        "id" : "Immunization.protocolApplied.targetDisease",
        "path" : "Immunization.protocolApplied.targetDisease",
        "binding" : {
          "extension" : [
            {
              "extension" : [
                {
                  "url" : "purpose",
                  "valueCode" : "candidate"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://terminology.ehdsi.eu/ValueSet/eHDSIIllnessandDisorder"
                },
                {
                  "url" : "documentation",
                  "valueMarkdown" : "Additional conformance binding to a diseases value set for use in specific jurisdictional or for cross-border settings."
                },
                {
                  "url" : "shortDoco",
                  "valueString" : "For when WHO ATC code system is preferred"
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            }
          ],
          "strength" : "preferred",
          "description" : "The diseases against which the patient has been immunised",
          "valueSet" : "http://hl7.org/fhir/uv/ips/ValueSet/target-diseases-uv-ips"
        }
      },
      {
        "id" : "Immunization.protocolApplied.doseNumber[x]",
        "path" : "Immunization.protocolApplied.doseNumber[x]",
        "short" : "Dose Number"
      },
      {
        "id" : "Immunization.protocolApplied.seriesDoses[x]",
        "path" : "Immunization.protocolApplied.seriesDoses[x]",
        "short" : "Number of doses"
      }
    ]
  }
}

```
