# Procedure Example - HL7 Europe Base and Core FHIR IG v2.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Procedure Example**

## Example Procedure: Procedure Example

Profile: [Procedure (EU core)](StructureDefinition-procedure-eu-core.md)

**status**: Completed

**code**: Appendectomy

**subject**: [John Doe Male, DoB: 1980-01-01](Patient-patient-eu-core-example.md)

**performed**: 2023-04-15

### Performers

| | |
| :--- | :--- |
| - | **Actor** |
| * | [PractitionerRole General practice (specialty)](PractitionerRole-practitionerRole-eu-core-example.md) |

**bodySite**: Appendix structure

**note**: 

> 

Laparoscopic procedure with no complications.




## Resource Content

```json
{
  "resourceType" : "Procedure",
  "id" : "procedure-eu-core-example",
  "meta" : {
    "profile" : [
      "http://hl7.eu/fhir/base/StructureDefinition/procedure-eu-core"
    ]
  },
  "status" : "completed",
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "80146002",
        "display" : "Appendectomy"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/patient-eu-core-example"
  },
  "performedDateTime" : "2023-04-15",
  "performer" : [
    {
      "actor" : {
        "reference" : "PractitionerRole/practitionerRole-eu-core-example"
      }
    }
  ],
  "bodySite" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "66754008",
          "display" : "Appendix structure"
        }
      ]
    }
  ],
  "note" : [
    {
      "text" : "Laparoscopic procedure with no complications."
    }
  ]
}

```
