# Animal Patient Example - HL7 Europe Base and Core FHIR IG v2.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Animal Patient Example**

## Example Patient: Animal Patient Example

Profile: [Patient: Animal (EU core)](StructureDefinition-patient-animal-eu-core.md)

Anonymous Patient (no stated gender), DoB Unknown

-------

| | |
| :--- | :--- |
| Patient Animal: | * species: Domestic cat
 |



## Resource Content

```json
{
  "resourceType" : "Patient",
  "id" : "Patient-animal-example",
  "meta" : {
    "profile" : [
      "http://hl7.eu/fhir/base/StructureDefinition/patient-animal-eu-core"
    ]
  },
  "extension" : [
    {
      "extension" : [
        {
          "url" : "species",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://snomed.info/sct",
                "code" : "448169003",
                "display" : "Domestic cat"
              }
            ]
          }
        }
      ],
      "url" : "http://hl7.org/fhir/StructureDefinition/patient-animal"
    }
  ]
}

```
