# hl7.fhir.be.drp#1.0.0: Digital Referral Prescription Implementation Guide

## Pages

* [Home](index.md)
* [Guidance](guidance.md)
* [Downloads](downloads.md)
* [Artifacts Summary](artifacts.md)
* [Changes](changes.md)

## Resources

### CodeSystems

* [BeCSAnnex81StatusReason](CodeSystem-be-cs-annex81-status-reason.md)
* [DRP Diabetic Education Type](CodeSystem-be-cs-diabetic-education-type.md)
* [DRP Generic Care Types](CodeSystem-be-cs-generic-care-types.md)
* [DRP Glycemia Measurement Timing](CodeSystem-be-cs-glycemia-measurement-timing.md)
* [DRP Note Types](CodeSystem-be-cs-note-types.md)
* [DRP Prescription Type](CodeSystem-be-cs-prescription-type.md)
* [DRP Session Types](CodeSystem-be-cs-session-types.md)
* [BeTempRequestedServiceDetail](CodeSystem-be-cs-temp-requested-service-detail.md)
* [BeTempRequestedService](CodeSystem-be-cs-temp-requested-service.md)
* [BePrescriptionStatusReason](CodeSystem-be-prescription-status-reason.md)
* [BeTreatmentStatusReason](CodeSystem-be-treatment-status-reason.md)

### ValueSets

* [BeVSAnnex81ReasonCode](ValueSet-be-vs-annex-81-reason-code.md)
* [DRP Annex 81 Care Requested](ValueSet-be-vs-annex81-care-requested.md)
* [DRP Annex 81 Medical Problem](ValueSet-be-vs-annex81-medical-problem.md)
* [DRP Annex 81 Nursing Diagnosis](ValueSet-be-vs-annex81-nursing-diagnosis.md)
* [BeVSAnnex81StatusReason](ValueSet-be-vs-annex81-status-reason.md)
* [DRP Annex 81 Technical Type](ValueSet-be-vs-annex81-technical-type.md)
* [DRP Body Laterality](ValueSet-be-vs-body-laterality.md)
* [DRP Body Site](ValueSet-be-vs-body-site.md)
* [DRP Body Topography](ValueSet-be-vs-body-topography.md)
* [Body Site](ValueSet-be-vs-bodysite-nursing.md)
* [DRP Categories of Care](ValueSet-be-vs-categories-of-care.md)
* [DRP Diabetes Education Identifier](ValueSet-be-vs-diabetes-education-identifier.md)
* [DRP Education Type With Trajectory](ValueSet-be-vs-education-type-with-trajectory.md)
* [DRP Education Type Without Trajectory](ValueSet-be-vs-education-type-without-trajectory.md)
* [DRP Educator Type](ValueSet-be-vs-educator-type.md)
* [DRP Glycemia Measurement Time](ValueSet-be-vs-glycemia-measurement-time.md)
* [DRP Note Type](ValueSet-be-vs-note-type.md)
* [DRP Nursing Care Requested](ValueSet-be-vs-nursing-care-requested.md)
* [DRP Nursing Prescription Technical Type](ValueSet-be-vs-nursing-prescription-technical-type.md)
* [DRP Parameter Type](ValueSet-be-vs-parameter-type.md)
* [BeVSPerformerTaskStatusReason](ValueSet-be-vs-performer-task-status-reason.md)
* [BeVSPrescriptionStatusReason](ValueSet-be-vs-prescription-status-reason.md)
* [DRP Prescription Type](ValueSet-be-vs-prescription-type.md)
* [BeReferralCategory](ValueSet-be-vs-referral-category.md)
* [BeVSRequestIntent](ValueSet-be-vs-request-intent.md)
* [BeVSRequestedServicesNurseDetail](ValueSet-be-vs-requested-services-nurse-detail.md)
* [BeVSRequestedServicesNurse](ValueSet-be-vs-requested-services-nurse.md)
* [DRP Sample Substance Type](ValueSet-be-vs-sample-substance-type.md)
* [DRP Session Type Extended](ValueSet-be-vs-session-type-extended.md)
* [DRP Session Type](ValueSet-be-vs-session-type.md)
* [BeVSTaskIntent](ValueSet-be-vs-task-intent.md)
* [BeVSTreatmentStatusReason](ValueSet-be-vs-treatment-status-reason.md)

### Logicals

* [BeModelAnnex81](StructureDefinition-BeModelAnnex81.md)
* [BeModelAssignment](StructureDefinition-BeModelAssignment.md)
* [BeModelNursingPrescription](StructureDefinition-BeModelNursingPrescription.md)
* [BeModelOrganisationClaim](StructureDefinition-BeModelOrganisationClaim.md)
* [BeModelReferralPrescription](StructureDefinition-BeModelReferralPrescription.md)
* [BeModelTreatmentStatus](StructureDefinition-BeModelTreatmentStatus.md)

### Resource Profiles

* [BeAnnex81](StructureDefinition-be-annex-81.md)
* [BeOrganizationTask](StructureDefinition-be-organization-task.md)
* [BePerformerTask](StructureDefinition-be-performer-task.md)
* [BeReferralServiceRequestNursing](StructureDefinition-be-referral-servicerequest-nursing.md)
* [BeReferralServiceRequest](StructureDefinition-be-referral-servicerequest.md)
* [BeReferralTask](StructureDefinition-be-referral-task.md)

### Extensions

* [BeFeedbackToPrescriber](StructureDefinition-be-ext-feedback-to-prescriber.md)
* [BeLatestEndDate](StructureDefinition-be-ext-latest-end-date.md)
* [BePerformerType](StructureDefinition-be-ext-performer-type.md)
* [BePSSInfo](StructureDefinition-be-ext-pss-info.md)
* [BeRelevantInfo](StructureDefinition-be-ext-relevant-info.md)
* [BeValidityPeriod](StructureDefinition-be-ext-validity-period.md)

### GraphDefinitions

* [full-referral-prescription](GraphDefinition-full-referral-prescription.md)

### ImplementationGuides

* [Digital Referral Prescription Implementation Guide](index.md)

### NamingSystems

* [BeNsUhmepShort](NamingSystem-be-ns-uhmep-short.md)
* [BeUnadressedHealthMessageExchangePlatform](NamingSystem-be-ns-uhmep.md)

### OperationDefinitions

* [BeOpApproveAnnex81](OperationDefinition-be-op-approve-annex81.md)
* [BeOpRejectAnnex81](OperationDefinition-be-op-reject-annex81.md)

### Parameters

* [terminology-expansion](Parameters-terminology-expansion.md)

### SearchParameters

* [statusReason](SearchParameter-be-sp-serviceRequest-statusReason.md)

### Tasks

* [example01-care02-colon-cleansing-performer-task](Task-example01-care02-colon-cleansing-performer-task.md)
* [example01-care02-colon-cleansing-referral-task](Task-example01-care02-colon-cleansing-referral-task.md)
* [performer-task-1-uc5a-1](Task-performer-task-1-uc5a-1.md)
* [referral-task-uc5a-1](Task-referral-task-uc5a-1.md)
* [referral-task](Task-referral-task.md)
* [ucgh222p12-1-2-1](Task-ucgh222p12-1-2-1.md)
* [ucgh222p12-1-2](Task-ucgh222p12-1-2.md)
* [ucgh222p12-2-2-1](Task-ucgh222p12-2-2-1.md)
* [ucgh222p12-2-2-2](Task-ucgh222p12-2-2-2.md)
* [ucgh222p12-2-2](Task-ucgh222p12-2-2.md)

### Examples

* [Requester1 (Practitioner)](Practitioner-Requester1.md)
* [practitioner2 (Practitioner)](Practitioner-practitioner2.md)
* [DOCTOR-10829059004 (PractitionerRole)](PractitionerRole-DOCTOR-10829059004.md)
* [DOCTOR-12009390800 (PractitionerRole)](PractitionerRole-DOCTOR-12009390800.md)
* [NURSE-45094508408 (PractitionerRole)](PractitionerRole-NURSE-45094508408.md)
* [example01-care02-colon-cleansing (ServiceRequest)](ServiceRequest-example01-care02-colon-cleansing.md)
* [example02-referralprescription-nursing-digestive-system-care (ServiceRequest)](ServiceRequest-example02-referralprescription-nursing-digestive-system-care.md)
* [example03-referralprescription-nursing-compressiontherapy (ServiceRequest)](ServiceRequest-example03-referralprescription-nursing-compressiontherapy.md)
* [example04-referralprescription-nursing-bladder-care (ServiceRequest)](ServiceRequest-example04-referralprescription-nursing-bladder-care.md)
* [example05-referralprescription-nursing-digestive-system-care (ServiceRequest)](ServiceRequest-example05-referralprescription-nursing-digestive-system-care.md)
* [example06-referralprescription-nursing-compression-therapy (ServiceRequest)](ServiceRequest-example06-referralprescription-nursing-compression-therapy.md)
* [example09-referralprescription-nursing-woundcare (ServiceRequest)](ServiceRequest-example09-referralprescription-nursing-woundcare.md)
* [example12-referralprescription-nursing-annex81 (ServiceRequest)](ServiceRequest-example12-referralprescription-nursing-annex81.md)
* [example16-referralprescription-nursing-bladder-care (ServiceRequest)](ServiceRequest-example16-referralprescription-nursing-bladder-care.md)
* [example24-referralprescription-nursing-non-reimbursable (ServiceRequest)](ServiceRequest-example24-referralprescription-nursing-non-reimbursable.md)
* [example26-referralprescription-nursing-other (ServiceRequest)](ServiceRequest-example26-referralprescription-nursing-other.md)
* [example32-referralprescription-nursing-chronical-psychiatric (ServiceRequest)](ServiceRequest-example32-referralprescription-nursing-chronical-psychiatric.md)
* [referralprescription-nursing-example2-digestive-system-care (ServiceRequest)](ServiceRequest-referralprescription-nursing-example2-digestive-system-care.md)
* [referralprescription-nursing-example3-compression-therapy (ServiceRequest)](ServiceRequest-referralprescription-nursing-example3-compression-therapy.md)
* [referralprescription-nursing-example5-digestive-system-care (ServiceRequest)](ServiceRequest-referralprescription-nursing-example5-digestive-system-care.md)
* [referralprescription-nursing-example6-compression-therapy (ServiceRequest)](ServiceRequest-referralprescription-nursing-example6-compression-therapy.md)
* [uc5a-1 (ServiceRequest)](ServiceRequest-uc5a-1.md)
* [ucgh222p12-1 (ServiceRequest)](ServiceRequest-ucgh222p12-1.md)
* [ucgh222p12-2 (ServiceRequest)](ServiceRequest-ucgh222p12-2.md)
* [ucgh222p12-3 (ServiceRequest)](ServiceRequest-ucgh222p12-3.md)
* [ucgh241p110-1 (ServiceRequest)](ServiceRequest-ucgh241p110-1.md)
* [ucgh241p111-1 (ServiceRequest)](ServiceRequest-ucgh241p111-1.md)
* [ucgh241p15-1 (ServiceRequest)](ServiceRequest-ucgh241p15-1.md)
* [ucgh241p16-1 (ServiceRequest)](ServiceRequest-ucgh241p16-1.md)
* [ucgh241p17-1 (ServiceRequest)](ServiceRequest-ucgh241p17-1.md)
* [ucgh241p18-1 (ServiceRequest)](ServiceRequest-ucgh241p18-1.md)
* [ucgh241p19-1 (ServiceRequest)](ServiceRequest-ucgh241p19-1.md)
