# Home - Digital Referral Prescription Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* **Home**

## Home

| | |
| :--- | :--- |
| *Official URL*:https://www.ehealth.fgov.be/standards/fhir/drp/ImplementationGuide/hl7.fhir.be.drp | *Version*:1.0.0 |
| Active as of 2025-09-26 | *Computable Name*:DigitalReferralPrescription |

This is the HL7 Belgium FHIR Implementation Guide for the [Referral prescription workgroup](https://wiki.hl7belgium.org/index.php?title=Procedure_Referral_Workgroup).
 General guidance is available on the [Guidance page](guidance.md)

> **This implementation guide contains only demonstrative example for terminology resources.**ValueSets and CodeSystems in this ImplementationGuide are provided as examples only. The actual ValueSets and CodeSystems will be made available from a terminology package and can then be consulted in the FHIR terminology ecosystem. 

### Content

This publication contains the specifications related to the referral prescription areas and is structured in the following content sections:

**Background:**
 Information about the HL7 Belgium specifications, or what you should know to be able to best navigate and use these specifications. Contains a general introduction to the publication structure and content, the artefact types, common privacy and security specifications and the official HL7 FHIR release that this specification is based upon.

**Functional Description:**
 Functional content, more relevant for business or functional analysts, as well as health professionals. Contains the context around these specifications (relevant projects, legal and implementation aspects), the interoperability actors and transactions, and especially the use cases that have been considered in the specification and the logical data models - the functional (i.e. non-technical) data sets that are used in data exchange.

**Detailed Specifications:**
 The actual technical specifications - the FHIR conformance resources that are defined in this specification - profiles, data types, capability statements. This is targeted at (technical) implementers.

**Terminology:**
 The vocabulary resources - Code Systems and value sets, that support semantic interoperability. These resources promote the use of standard, controlled terminologies (e.g. SNOMED-CT) and define internal codes for Belgium, e.g. official codes for Civil Status).

**Implementation:**
 Content, Tools and resources to help in implementation - test data (example resources), currently available test servers, and other tools to validate the compatibility between systems and these specifications.

There is also an overview of the projects and motivation for the specifications.

-------

### Navigation

This implementation guide uses the FHIR web-based publication. This allows easy navigation between the Belgium-specific portion of the implementation guide and the resources, data types, value sets and other specification components leveraged from the FHIR core specification. This approach also allows implementers to easily navigate to the information needed to perform a task.

The top menu allows quick navigation to the different sections, and a [Table of Contents](toc.md) is provided with the entire content of this Implementation Guide. (Be aware that some pages have multiple tabs).

-------

### Intellectual Property Considerations

While this implementation guide and the underlying FHIR are licensed as public domain, this guide includes examples making use of terminologies such as LOINC, SNOMED CT and others which have more restrictive licensing requirements. Implementers should make themselves familiar with licensing and any other constraints of terminologies, questionnaires, and other components used as part of their implementation process. In some cases, licensing requirements may limit the systems that data captured using certain questionnaires may be shared with.

-------

### Disclaimer

The specification herewith documented is a first working specification. Implementers are requested to provide feedback on its implementation.

