# Home - Medication v1.1.0

* [**Table of Contents**](toc.md)
* **Home**

## Home

| | |
| :--- | :--- |
| *Official URL*:https://www.ehealth.fgov.be/standards/fhir/medication/ImplementationGuide/hl7.fhir.be.medication | *Version*:1.1.0 |
| Active as of 2025-09-26 | *Computable Name*:Medication |

This is the specification for the Medication CareSet, developed by the HL7 Belgium community. It includes the following parts:

* Medication Dispense
* Medication Line
* Medication Prescription

### Use of MUST, SHOULD, MAY

The key words “MUST”, “MUST NOT”, “REQUIRED”, “SHALL”, “SHALL NOT”, “SHOULD”, “SHOULD NOT”, “RECOMMENDED”, “MAY”, and “OPTIONAL” in this document are to be interpreted as described in RFC 2119:

1. **MUST**, or the terms**“REQUIRED”**or**“SHALL”**, mean that the definition is an absolute requirement of the specification.
1. **MUST NOT**, or the phrase**“SHALL NOT”**, mean that the definition is an absolute prohibition of the specification.
1. **SHOULD**, or the adjective**“RECOMMENDED”**, mean that there may exist valid reasons in particular circumstances to ignore a particular item, but the full implications must be understood and carefully weighed before choosing a different course.
1. **SHOULD NOT**, or the phrase**“NOT RECOMMENDED”**mean that there may exist valid reasons in particular circumstances when the particular behaviour is acceptable or even useful, but the full implications should be understood and the case carefully weighed before implementing any behaviour described with this label.
1. **MAY**, or the adjective**“OPTIONAL”**, mean that an item is truly optional. One vendor may choose to include the item because a particular marketplace requires it or because the vendor feels that it enhances the product while another vendor may omit the same item. An implementation which does not include a particular option MUST be prepared to interoperate with another implementation which does include the option, though perhaps with reduced functionality. In the same vein an implementation which does include a particular option MUST be prepared to interoperate with another implementation which does not include the option (except, of course, for the feature the option provides.)

### Must Support

Unless otherwise stated, the following criteria apply to elements marked as “Must Support” in this Implementation Guide:

#### For technical profiles

**Systems supporting the profile MUST NOT ignore the element**.

* Systems receiving or consuming a resource instance: 
* MUST be able to process the element’s content when it is present
* MUST process the content according to the rules defined for the profile
* MUST NOT fail when the value is not present.
 
* Systems sending or creating a resource instance 
* SHOULD populate the element when the information is available
* MUST populate the element according to the rules defined for the profile
 

#### For Logical Models

* **Functional Analysis MUST consider the data element as defined** 
* “Must Support” elements that are used in an implementation MUST inherit the behaviour and constraints defined for the data element
* “Must Support” elements not needed in a particular implementation MAY be excluded from implementation but such exclusion MUST be described
 
* **Derived implementations SHOULD inherit the field’s “Must Support” flag**

### Dependencies

This IG Contains the following dependencies on other IGs.





### Cross Version Analysis

This is an R4 IG. None of the features it uses are changed in R4B, so it can be used as is with R4B systems. Packages for both [R4 (hl7.fhir.be.medication.r4)](package.r4.tgz) and [R4B (hl7.fhir.be.medication.r4b)](package.r4b.tgz) are available. 

### Global Profiles

*There are no Global profiles defined*

### Intellectual Property

This publication includes IP covered under the following statements.

* ISO maintains the copyright on the country codes, and controls its use carefully. For further details see the ISO 3166 web page: [https://www.iso.org/iso-3166-country-codes.html](https://www.iso.org/iso-3166-country-codes.html)

* [ISO 3166-1 Codes for the representation of names of countries and their subdivisions — Part 1: Country code](http://terminology.hl7.org/6.0.2/CodeSystem-ISO3166Part1.html): [BasedOnMedicationLine](StructureDefinition-BasedOnMedicationLine.md), [BeDosage](StructureDefinition-BeDosage.md)...Show 37 more,[BeExtAdherenceStatus](StructureDefinition-BeExtAdherenceStatus.md),[BeExtInstructionsForReimbursement](StructureDefinition-BeExtInstructionsForReimbursement.md),[BeExtMedicationLineRegistrationStatus](StructureDefinition-BeExtMedicationLineRegistrationStatus.md),[BeExtMedicationType](StructureDefinition-BeExtMedicationType.md),[BeExtOffLabel](StructureDefinition-BeExtOffLabel.md),[BeExtRecordedDate](StructureDefinition-BeExtRecordedDate.md),[BeExtRecorder](StructureDefinition-BeExtRecorder.md),[BeMedicationDispense](StructureDefinition-BeMedicationDispense.md),[BeMedicationExposureCategory](StructureDefinition-BeMedicationExposureCategory.md),[BeMedicationExposureIntentVS](ValueSet-BeMedicationExposureIntentVS.md),[BeMedicationLine](StructureDefinition-BeMedicationLine.md),[BeMedicationLineAdherenceStatus](CodeSystem-BeMedicationLineAdherenceStatus.md),[BeMedicationLineAdherenceStatusReason](CodeSystem-BeMedicationLineAdherenceStatusReason.md),[BeMedicationLineAdherenceStatusReasonVS](ValueSet-BeMedicationLineAdherenceStatusReasonVS.md),[BeMedicationLineAdherenceStatusVS](ValueSet-BeMedicationLineAdherenceStatusVS.md),[BeMedicationLineOriginType](CodeSystem-BeMedicationLineOriginType.md),[BeMedicationLineOriginTypeVS](ValueSet-BeMedicationLineOriginTypeVS.md),[BeMedicationLineRegistrationStatus](CodeSystem-BeMedicationLineRegistrationStatus.md),[BeMedicationLineRegistrationStatusVS](ValueSet-BeMedicationLineRegistrationStatusVS.md),[BeMedicationPrescription](StructureDefinition-BeMedicationPrescription.md),[BeMedicationPrescriptionStatusVS](ValueSet-BeMedicationPrescriptionStatusVS.md),[BeMedicationRequestReimbursementType](CodeSystem-BeMedicationRequestReimbursementType.md),[BeMedicationRequestReimbursementTypeVS](ValueSet-BeMedicationRequestReimbursementTypeVS.md),[BeMedicationType](CodeSystem-BeMedicationType.md),[BeMedicationTypeVS](ValueSet-BeMedicationTypeVS.md),[BeModelDosagingInformation](StructureDefinition-BeModelDosagingInformation.md),[BeModelMedication](StructureDefinition-BeModelMedication.md),[BeModelMedicationDispense](StructureDefinition-BeModelMedicationDispense.md),[BeModelMedicationPrescription](StructureDefinition-BeModelMedicationPrescription.md),[BeNSCNK](NamingSystem-be-ns-cnk-codes.md),[BeNSCTIExtended](NamingSystem-be-ns-cti-extended-code.md),[BeNSPrescriptions](NamingSystem-be-ns-prescription-ids.md),[BeNSProductPackage](NamingSystem-be-ns-product-package-type.md),[BeRouteOfAdministrationVS](ValueSet-BeRouteOfAdministrationVS.md),[DispenserTypes](ValueSet-be-vs-dispenser-types.md),[Medication](index.md)and[MedicationLine](StructureDefinition-BeModelMedicationLine.md)


* The UCUM codes, UCUM table (regardless of format), and UCUM Specification are copyright 1999-2009, Regenstrief Institute, Inc. and the Unified Codes for Units of Measures (UCUM) Organization. All rights reserved. [https://ucum.org/trac/wiki/TermsOfUse](https://ucum.org/trac/wiki/TermsOfUse)

* [Unified Code for Units of Measure (UCUM)](http://terminology.hl7.org/6.0.2/CodeSystem-v3-ucum.html): [MedicationDispense/example-dispense-hospital](MedicationDispense-example-dispense-hospital.md)


* This material contains content that is copyright of SNOMED International. Implementers of these specifications must have the appropriate SNOMED CT Affiliate license - for more information contact [https://www.snomed.org/get-snomed](https://www.snomed.org/get-snomed) or [info@snomed.org](mailto:info@snomed.org).

* [SNOMED Clinical Terms&reg; (SNOMED CT&reg;)](http://hl7.org/fhir/R4/codesystem-snomedct.html): [BeDosage](StructureDefinition-BeDosage.md), [BeMedicationDispense](StructureDefinition-BeMedicationDispense.md)...Show 5 more,[BeMedicationExposureCategory](StructureDefinition-BeMedicationExposureCategory.md),[BeMedicationExposureIntentVS](ValueSet-BeMedicationExposureIntentVS.md),[BeModelDosagingInformation](StructureDefinition-BeModelDosagingInformation.md),[BeRouteOfAdministrationVS](ValueSet-BeRouteOfAdministrationVS.md)and[MedicationLine](StructureDefinition-BeModelMedicationLine.md)


