# Artifacts Summary - Your User Friendly Name for MyContentIG Here v0.5.3

* [**Table of Contents**](toc.md)
* **Artifacts Summary**

## Artifacts Summary

This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### Knowledge Artifacts: Activity Definitions 

These define activities that can be performed as part of content in this implementation guide.

| | |
| :--- | :--- |
| [Daily Apple Activity](ActivityDefinition-DailyAppleActivity.md) | Activity to provide an apple daily |

### Knowledge Artifacts: Plan Definitions 

These define workflows, rules, strategies, or protocols as part of content in this implementation guide.

| | |
| :--- | :--- |
| [Daily Apple Recommendation](PlanDefinition-DailyAppleRecommendation.md) | An apple a day keeps the doctor away |

### Knowledge Artifacts: Measure 

These define measures as part of content in this implementation guide.

| | |
| :--- | :--- |
| [Core Clinical Data Elements for the Hybrid Hospital-Wide (All-Condition, All-Procedure) Risk-Standardized Mortality Measure (HWM) FHIR Example](Measure-HybridHospitalWideMortalityFHIRExample.md) | This logic is intended to extract electronic clinical data. This is not an electronic clinical quality measure and this logic will not produce measure results. Instead, it will produce a file containing the data that CMS will link with administrative claims to risk adjust the Hybrid HWM outcome measure. It is designed to extract the first resulted set of vital signs and basic laboratory results obtained from encounters for adult Medicare Fee-For-Service patients admitted to acute care short stay hospitals. |
| [Discharged on Antithrombotic Therapy FHIR Example](Measure-DischargedonAntithromboticTherapyFHIRExample.md) | Ischemic stroke patients prescribed or continuing to take antithrombotic therapy at hospital discharge |
| [HIV Viral Suppression FHIR Example](Measure-HIVViralSuppressionFHIRExample.md) | Percentage of patients, regardless of age, diagnosed with HIV prior to or during the first 90 days of the measurement period, with an eligible encounter in the first 240 days of the measurement period, whose last HIV viral load test result was less than 200 copies/mL during the measurement period |
| [HR Example CV (Measure Name in Details Tab of MADiE UI)](Measure-HRExampleCVMeasure.md) | **Description Section of Details Tab in MADiE UI*** Free text.
* Character limit not determined.
**QDM equivalent: Description** |
| [HR Example Cohort (Measure Name in Details Tab of MADiE UI)](Measure-HRExampleCohortMeasure.md) | **Description Section of Details Tab in MADiE UI*** Free text.
* Character limit not determined.
**QDM equivalent: Description** |
| [HR Example Proportion (Measure Name in Details Tab of MADiE UI)](Measure-HRExampleProportionMeasure.md) | **Description Section of Details Tab in MADiE UI*** Free text.
* Character limit not determined.
**QDM equivalent: Description** |
| [HR Example Ratio (Measure Name in Details Tab of MADiE UI)](Measure-HRExampleRatioMeasure.md) | **Description Section of Details Tab in MADiE UI*** Free text.
* Character limit not determined.
**QDM equivalent: Description** |
| [Questionnaire Measure Example](Measure-QuestionnaireMeasureExample.md) | Example measure illustrating a continuous variable measure calculating scores from multiple questionnaires |

### Knowledge Artifacts: Libraries 

These define logic, asset collections and other libraries as part of content in this implementation guide.

| |
| :--- |
| [CQMCommonExample](Library-CQMCommonExample.md) |
| [DailyAppleLogic](Library-DailyAppleLogic.md) |
| [DependencyExample](Library-DependencyExample.md) |
| [DischargedonAntithromboticTherapyFHIRExample](Library-DischargedonAntithromboticTherapyFHIRExample.md) |
| [ExtensionAndSlicingExample](Library-ExtensionAndSlicingExample.md) |
| [FHIRHelpers](Library-FHIRHelpers.md) |
| [FirstExample](Library-FirstExample.md) |
| [HIVViralSuppressionFHIRExample](Library-HIVViralSuppressionFHIRExample.md) |
| [HRExampleCVMeasureCQLLibrary](Library-HRExampleCVMeasureCQLLibrary.md) |
| [HRExampleCohortMeasureCQLLibrary](Library-HRExampleCohortMeasureCQLLibrary.md) |
| [HRExampleProportionMeasureCQLLibrary](Library-HRExampleProportionMeasureCQLLibrary.md) |
| [HRExampleRatioMeasureCQLLibrary](Library-HRExampleRatioMeasureCQLLibrary.md) |
| [HybridHospitalWideMortalityFHIRExample](Library-HybridHospitalWideMortalityFHIRExample.md) |
| [PHQ9LogicExample](Library-PHQ9LogicExample.md) |
| [QICoreCommonExample](Library-QICoreCommonExample.md) |
| [QuestionnaireMeasureExample](Library-QuestionnaireMeasureExample.md) |
| [RetrieveExample](Library-RetrieveExample.md) |
| [SupplementalDataElementsExample](Library-SupplementalDataElementsExample.md) |
| [TJCOverallExample](Library-TJCOverallExample.md) |

### Structures: Questionnaires 

These define forms used by systems conforming to this implementation guide to capture or expose data to end users.

| |
| :--- |
| [Patient Health Questionnaire (PHQ-9)](Questionnaire-phq-9-questionnaire.md) |

### Other 

These are resources that are used within this implementation guide that do not fit into one of the other categories.

| | |
| :--- | :--- |
| [CQF Tooling](Device-cqf-tooling.md) | CQF Tooling used in the generation of this IG |
| [Input Expansion Parameters](Parameters-manifest.md) | The input expansion parameters resource for this implementation guide, specifying SNOMED Edition. This resource will be contained within the published implementation guide with all pinned references. |

