# Discharged on Antithrombotic Therapy FHIR Example - Your User Friendly Name for MyContentIG Here v0.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Discharged on Antithrombotic Therapy FHIR Example**

## Measure: Discharged on Antithrombotic Therapy FHIR Example 

| | |
| :--- | :--- |
| *Official URL*:http://somewhere.org/fhir/uv/mycontentig/Measure/DischargedonAntithromboticTherapyFHIRExample | *Version*:0.5.3 |
| Draft as of 2025-09-30 | *Computable Name*:DischargedonAntithromboticTherapyFHIRExample |
| *Other Identifiers:*Short Name (use: usual, ), UUID:4f57e4a2-097b-45f8-9c85-91b35ea92dc1 (use: official, ), UUID:e0b5379f-4b9c-4177-a530-d744fa95d080 (use: official, ), Publisher (use: official, ) | |
| **Usage:**Clinical Venue: EH | |
| **Copyright/Legal**: Measure specifications are in the Public DomainLOINC(R) copyright 2004-2022 Regenstrief Institute, Inc. This material contains SNOMED Clinical Terms(R) (SNOMED CT[R]) copyright 2004-2022 International Health Terminology Standards Development Organisation. ICD-10 copyright 2021 World Health Organization. All Rights Reserved. | |

 
Ischemic stroke patients prescribed or continuing to take antithrombotic therapy at hospital discharge 

 
UNKNOWN 

* Metadata: Title
  * ?: Discharged on Antithrombotic Therapy FHIR Example
* Metadata: Version
  * ?: 0.5.3
* Metadata: Short Name
  * ?: CMS104FHIR
* Metadata: GUID (Version Independent)
  * ?: urn:uuid:4f57e4a2-097b-45f8-9c85-91b35ea92dc1
* Metadata: GUID (Version Specific)
  * ?: urn:uuid:e0b5379f-4b9c-4177-a530-d744fa95d080
* Metadata: CMS Identifier
  * ?: 104FHIR
* Metadata: Effective Period
  * ?: 2024-01-01 through 2024-12-31
* Metadata: Approval Date
  * ?: 2023-08-01
* Metadata: Last Review Date
  * ?: 2023-08-01
* Metadata: Status
  * ?: Draft
* Metadata: Use Context
  * ?: venue from[http://terminology.hl7.org/CodeSystem/usage-context-type](http://terminology.hl7.org/7.0.0/CodeSystem-usage-context-type.html)= EH
* Metadata: Jurisdiction
  * ?: 001 from[http://unstats.un.org/unsd/methods/m49/m49.htm](http://unstats.un.org/unsd/methods/m49/m49.htm)
* Metadata: Steward (Publisher)
  * ?: HL7 International - [Some] Work Group
* Metadata: Developer
  * ?: The Joint Commission
* Metadata: Description
  * ?: Ischemic stroke patients prescribed or continuing to take antithrombotic therapy at hospital discharge
* Metadata: Copyright
  * ?: Measure specifications are in the Public DomainLOINC(R) copyright 2004-2022 Regenstrief Institute, Inc. This material contains SNOMED Clinical Terms(R) (SNOMED CT[R]) copyright 2004-2022 International Health Terminology Standards Development Organisation. ICD-10 copyright 2021 World Health Organization. All Rights Reserved.
* Metadata: Disclaimer
  * ?: These performance measures are not clinical guidelines and do not establish a standard of medical care, and have not been tested for all potential applications. The measures and specifications are provided without warranty.
* Metadata: Rationale
  * ?: The effectiveness of antithrombotic agents in reducing stroke mortality, stroke-related morbidity and recurrence rates has been studied in several large clinical trials. While the use of these agents for patients with acute ischemic stroke and transient ischemic attacks continues to be the subject of study, substantial evidence is available from completed studies. Data at this time suggest that antithrombotic therapy should be prescribed at discharge following acute ischemic stroke to reduce stroke mortality and morbidity as long as no contraindications exist.or patients with a stroke due to a cardioembolic source (e.g. atrial fibrillation, mechanical heart valve), warfarin is recommended unless contraindicated. In recent years, novel oral anticoagulant agents (NOACs) have been developed and approved by the U.S. Food and Drug Administration (FDA) for stroke prevention, and may be considered as an alternative to warfarin for select patients. Anticoagulation therapy is not generally recommended for secondary stroke prevention in patients presumed to have a non-cardioembolic stroke. Anticoagulants at doses to prevent venous thromboembolism are insufficient antithrombotic therapy to prevent recurrent ischemic stroke or transient ischemic attack (TIA).
* Metadata: Clinical Recommendation Statement
  * ?: Clinical trial results suggest that antithrombotic therapy should be prescribed at discharge following acute ischemic stroke to reduce stroke mortality and morbidity as long as no contraindications exist
* Metadata: Guidance (Usage)
  * ?: The "Nonelective Inpatient Encounter" value set intends to capture all non-scheduled hospitalizations. This value set is a subset of the "Inpatient encounter" value set, excluding concepts that specifically refer to elective hospital admissions. Non-elective admissions include emergency, urgent and unplanned admissions. The "MedicationRequest" datatype refers to the discharge medication list and is intended to express medications ordered for post-discharge use. The denominator population includes patients with inpatient hospitalizations and patients from Acute Hospital Care at Home programs, who are treated and billed as inpatients but receive care in their home. This eCQM is an episode-based measure. An episode is defined as each inpatient hospitalization or encounter that ends during the measurement period. This FHIR-based measure has been derived from the QDM-based measure: CMS104v12. Please refer to the HL7 QI-Core Implementation Guide (http://hl7.org/fhir/us/qicore/index.html) for more information on QI-Core and mapping recommendations from QDM to QI-Core 4.1.1 (http://hl7.org/fhir/us/qicore/qdm-to-qicore.html).
* Metadata: Measure Group (Rate) (ID: 64403d17d4d7050edabb0562)
* Metadata: Basis
  * ?: Encounter
* Metadata: Scoring
  * ?: Proportion
* Metadata: Type
  * ?: Process
* Metadata: Initial Population
  * ?: **ID**: 937BAF2A-D36A-4EE5-B2B2-762A0FE04502**Description**:Inpatient hospitalizations for patients age 18 and older, discharged from inpatient care (non-elective admissions) with a principal diagnosis of ischemic or hemorrhagic stroke and a length of stay less than or equal to 120 days that ends during the measurement period**Criteria**:[Initial Population](#64403d17d4d7050edabb0562-937BAF2A-D36A-4EE5-B2B2-762A0FE04502)
* Metadata: Denominator
  * ?: **ID**: 302C1DCC-7FE6-41EF-A94E-FDAE24B7BB1B**Description**:Inpatient hospitalizations for patients with a principal diagnosis of Ischemic stroke**Criteria**:[Denominator](#64403d17d4d7050edabb0562-302C1DCC-7FE6-41EF-A94E-FDAE24B7BB1B)
* Metadata: Denominator Exclusion
  * ?: **ID**: 4B649804-9C55-4949-8CE0-01B462CAA74C**Description**:- Inpatient hospitalizations for patients admitted for elective carotid intervention. This exclusion is implicitly modeled by only including non-elective hospitalizations. - Inpatient hospitalizations for patients discharged to another hospital - Inpatient hospitalizations for patients who left against medical advice - Inpatient hospitalizations for patients who expired - Inpatient hospitalizations for patients discharged to home for hospice care - Inpatient hospitalizations for patients discharged to a health care facility for hospice care - Inpatient hospitalizations for patients with comfort measures documented**Criteria**:[Denominator Exclusions](#64403d17d4d7050edabb0562-4B649804-9C55-4949-8CE0-01B462CAA74C)
* Metadata: Denominator Exception
  * ?: **ID**: 516A3DD0-69B0-49EF-BBD3-12809CDC843E**Description**:- Inpatient hospitalizations for patients with a documented reason for not prescribing antithrombotic therapy at discharge. - Inpatient hospitalizations for patients who receive Prasugrel as an antithrombotic therapy at discharge.**Criteria**:[Denominator Exceptions](#64403d17d4d7050edabb0562-516A3DD0-69B0-49EF-BBD3-12809CDC843E)
* Metadata: Numerator
  * ?: **ID**: 99961E3A-EFC4-4858-A3EE-F7F1D5B222FB**Description**:Inpatient hospitalizations for patients prescribed or continuing to take antithrombotic therapy at hospital discharge**Criteria**:[Numerator](#64403d17d4d7050edabb0562-99961E3A-EFC4-4858-A3EE-F7F1D5B222FB)
* Metadata: Numerator Exclusion
  * ?: **ID**: 5f33f3ea-6ffb-4897-85dd-872dd7ac55b8**Description**: No description provided
* Metadata: Supplemental Data Guidance Guidance
  * ?: Patient's Ethnicity: Hispanic or Latino Not Hispanic or Latino Patient's Payer: Categories of types of health care payer entities as defined by the US Public Health Data Consortium SOP code system Patient's Race: Native Hawaiian or Other Pacific Islander Asian American Indian or Alaska Native Other Race White Black or African American Patient's Sex: Gender identity restricted to only Male and Female used in administrative situations requiring a restriction to these two categories.
* Metadata: Supplemental Data Elements
* Metadata: Supplemental Data Element
  * ?: **ID**: sde-ethnicity**Usage Code**:Supplemental Data**Description**: SDE Ethnicity**Logic Definition**:[SDE Ethnicity](#dischargedonantithrombotictherapyfhirexample-sde-ethnicity)
* Metadata: Supplemental Data Element
  * ?: **ID**: sde-payer**Usage Code**:Supplemental Data**Description**: SDE Payer**Logic Definition**:[SDE Payer](#dischargedonantithrombotictherapyfhirexample-sde-payer)
* Metadata: Supplemental Data Element
  * ?: **ID**: sde-race**Usage Code**:Supplemental Data**Description**: SDE Race**Logic Definition**:[SDE Race](#dischargedonantithrombotictherapyfhirexample-sde-race)
* Metadata: Supplemental Data Element
  * ?: **ID**: sde-sex**Usage Code**:Supplemental Data**Description**: SDE Sex**Logic Definition**:[SDE Sex](#dischargedonantithrombotictherapyfhirexample-sde-sex)
* Metadata: Measure Logic
* Metadata: Primary Library
  * ?: [DischargedonAntithromboticTherapyFHIRExample](Library-DischargedonAntithromboticTherapyFHIRExample.md)
* Metadata: Contents
  * ?: **[Population Criteria](#population-criteria)****[Logic Definitions](#definitions)****[Terminology](#terminology)****[Dependencies](#dependencies)****[Data Requirements](#data-requirements)****[Parameters](#parameters)**
* Metadata: Population Criteria
* Metadata: Measure Group (Rate) (ID: 64403d17d4d7050edabb0562)
* Metadata: Initial Population
* Metadata: ````define "Initial Population": TJC."Encounter with Principal Diagnosis and Age"````[**Definition**](#dischargedonantithrombotictherapyfhirexample-initial-population)
* Metadata: Denominator
* Metadata: ````define "Denominator": TJC."Ischemic Stroke Encounter"````[**Definition**](#dischargedonantithrombotictherapyfhirexample-denominator)
* Metadata: Denominator Exclusion
* Metadata: ````define "Denominator Exclusions": TJC."Ischemic Stroke Encounters with Discharge Disposition" union "Encounter with Comfort Measures during Hospitalization for Patients with Documented Ischemic Stroke"````[**Definition**](#dischargedonantithrombotictherapyfhirexample-denominator-exclusions)
* Metadata: Denominator Exception
* Metadata: ````define "Denominator Exceptions": "Encounter with Documented Reason for No Antithrombotic At Discharge" union "Encounter with Pharmacological Contraindications for Antithrombotic Therapy at Discharge"````[**Definition**](#dischargedonantithrombotictherapyfhirexample-denominator-exceptions)
* Metadata: Numerator
* Metadata: ````define "Numerator": TJC."Ischemic Stroke Encounter" IschemicStrokeEncounter with ["MedicationRequest": "Antithrombotic Therapy for Ischemic Stroke"] DischargeAntithrombotic such that DischargeAntithrombotic.authoredOn during IschemicStrokeEncounter.period````[**Definition**](#dischargedonantithrombotictherapyfhirexample-numerator)
* Metadata: Logic Definitions
* Metadata: Logic Definition
  * ?: **Library Name:**TJCOverallExample
* Metadata: ````define "Non Elective Inpatient Encounter": ["Encounter": "Nonelective Inpatient Encounter"] NonElectiveEncounter where NonElectiveEncounter.period ends during day of "Measurement Period"````
* Metadata: Logic Definition
  * ?: **Library Name:**TJCOverallExample
* Metadata: ````define "All Stroke Encounter": "Non Elective Inpatient Encounter" NonElectiveEncounter let ConditionCode: NonElectiveEncounter.principalDiagnosis().code where ( ConditionCode in "Hemorrhagic Stroke" or ConditionCode in "Ischemic Stroke" )````
* Metadata: Logic Definition
  * ?: **Library Name:**TJCOverallExample
* Metadata: ````define "Encounter with Principal Diagnosis and Age": "All Stroke Encounter" AllStrokeEncounter where AgeInYearsAt(date from start of AllStrokeEncounter.period ) >= 18````
* Metadata: Logic Definition
  * ?: **Library Name:**TJCOverallExample
* Metadata: ````define "Ischemic Stroke Encounter": "Encounter with Principal Diagnosis and Age" EncounterWithAge where EncounterWithAge.principalDiagnosis().code in "Ischemic Stroke"````
* Metadata: Logic Definition
  * ?: **Library Name:**TJCOverallExample
* Metadata: ````define "Ischemic Stroke Encounters with Discharge Disposition": "Ischemic Stroke Encounter" IschemicStrokeEncounter let DischDisp: IschemicStrokeEncounter.hospitalization.dischargeDisposition where DischDisp in "Discharge To Acute Care Facility" or DischDisp in "Left Against Medical Advice" or DischDisp in "Patient Expired" or DischDisp in "Discharged to Home for Hospice Care" or DischDisp in "Discharged to Health Care Facility for Hospice Care"````
* Metadata: Logic Definition
  * ?: **Library Name:**TJCOverallExample
* Metadata: ````define "Intervention Comfort Measures": ( ["ServiceRequest": code in "Comfort Measures"] SR where SR.status in { 'active', 'completed', 'on-hold' } and SR.intent in { 'order', 'original-order', 'reflex-order', 'filler-order', 'instance-order' } and SR.doNotPerform is not true ) union ( ["Procedure": "Comfort Measures"] InterventionPerformed where InterventionPerformed.status in { 'completed', 'in-progress' } )````
* Metadata: Logic Definition
  * ?: **Library Name:**SupplementalDataElementsExample
* Metadata: ````define "SDE Sex": case when Patient.gender = 'male' then Code { code: 'M', system: 'http://hl7.org/fhir/v3/AdministrativeGender', display: 'Male' } when Patient.gender = 'female' then Code { code: 'F', system: 'http://hl7.org/fhir/v3/AdministrativeGender', display: 'Female' } else null end````
* Metadata: Logic Definition
  * ?: **Library Name:**SupplementalDataElementsExample
* Metadata: ````define "SDE Payer": [Coverage: type in "Payer Type"] Payer return { code: Payer.type, period: Payer.period }````
* Metadata: Logic Definition
  * ?: **Library Name:**SupplementalDataElementsExample
* Metadata: ````define "SDE Ethnicity": Patient.ethnicity E return Tuple { codes: { E.ombCategory } union E.detailed, display: E.text }````
* Metadata: Logic Definition
  * ?: **Library Name:**SupplementalDataElementsExample
* Metadata: ````define "SDE Race": Patient.race R return Tuple { codes: R.ombCategory union R.detailed, display: R.text }````
* Metadata: Logic Definition
  * ?: **Library Name:**DischargedonAntithromboticTherapyFHIRExample
* Metadata: ````define "SDE Sex": SDE."SDE Sex"````
* Metadata: Logic Definition
  * ?: **Library Name:**DischargedonAntithromboticTherapyFHIRExample
* Metadata: ````define "Numerator": TJC."Ischemic Stroke Encounter" IschemicStrokeEncounter with ["MedicationRequest": "Antithrombotic Therapy for Ischemic Stroke"] DischargeAntithrombotic such that DischargeAntithrombotic.authoredOn during IschemicStrokeEncounter.period````
* Metadata: Logic Definition
  * ?: **Library Name:**DischargedonAntithromboticTherapyFHIRExample
* Metadata: ````define "Denominator": TJC."Ischemic Stroke Encounter"````
* Metadata: Logic Definition
  * ?: **Library Name:**DischargedonAntithromboticTherapyFHIRExample
* Metadata: ````define "SDE Payer": SDE."SDE Payer"````
* Metadata: Logic Definition
  * ?: **Library Name:**DischargedonAntithromboticTherapyFHIRExample
* Metadata: ````define "Initial Population": TJC."Encounter with Principal Diagnosis and Age"````
* Metadata: Logic Definition
  * ?: **Library Name:**DischargedonAntithromboticTherapyFHIRExample
* Metadata: ````define "SDE Ethnicity": SDE."SDE Ethnicity"````
* Metadata: Logic Definition
  * ?: **Library Name:**DischargedonAntithromboticTherapyFHIRExample
* Metadata: ````define "Encounter with Comfort Measures during Hospitalization for Patients with Documented Ischemic Stroke": "Denominator" Encounter with TJC."Intervention Comfort Measures" ComfortMeasure such that Coalesce(start of ComfortMeasure.performed.toInterval(), ComfortMeasure.authoredOn) during Encounter.hospitalizationWithObservation ( )````
* Metadata: Logic Definition
  * ?: **Library Name:**DischargedonAntithromboticTherapyFHIRExample
* Metadata: ````define "Denominator Exclusions": TJC."Ischemic Stroke Encounters with Discharge Disposition" union "Encounter with Comfort Measures during Hospitalization for Patients with Documented Ischemic Stroke"````
* Metadata: Logic Definition
  * ?: **Library Name:**DischargedonAntithromboticTherapyFHIRExample
* Metadata: ````define "SDE Race": SDE."SDE Race"````
* Metadata: Logic Definition
  * ?: **Library Name:**DischargedonAntithromboticTherapyFHIRExample
* Metadata: ````define "Reason for Not Giving Antithrombotic at Discharge": ["MedicationNotRequested": "Antithrombotic Therapy for Ischemic Stroke"] NoAntithromboticDischarge where ( NoAntithromboticDischarge.reasonCode in "Medical Reason For Not Providing Treatment" or NoAntithromboticDischarge.reasonCode in "Patient Refusal" ) and ( NoAntithromboticDischarge.isCommunity ( ) or NoAntithromboticDischarge.isDischarge ( ) ) and NoAntithromboticDischarge.intent in { 'order', 'original-order', 'reflex-order', 'filler-order', 'instance-order' }````
* Metadata: Logic Definition
  * ?: **Library Name:**DischargedonAntithromboticTherapyFHIRExample
* Metadata: ````define "Encounter with Documented Reason for No Antithrombotic At Discharge": TJC."Ischemic Stroke Encounter" IschemicStrokeEncounter with "Reason for Not Giving Antithrombotic at Discharge" NoDischargeAntithrombotic such that NoDischargeAntithrombotic.authoredOn during IschemicStrokeEncounter.period````
* Metadata: Logic Definition
  * ?: **Library Name:**DischargedonAntithromboticTherapyFHIRExample
* Metadata: ````define "Pharmacological Contraindications for Antithrombotic Therapy at Discharge": ["MedicationRequest": "Pharmacological Contraindications For Antithrombotic Therapy"] Pharmacological where ( Pharmacological.isCommunity ( ) or Pharmacological.isDischarge ( ) ) and Pharmacological.status in { 'active', 'completed' } and Pharmacological.intent in { 'order', 'original-order', 'reflex-order', 'filler-order', 'instance-order' } and Pharmacological.doNotPerform is not true````
* Metadata: Logic Definition
  * ?: **Library Name:**DischargedonAntithromboticTherapyFHIRExample
* Metadata: ````define "Encounter with Pharmacological Contraindications for Antithrombotic Therapy at Discharge": TJC."Ischemic Stroke Encounter" IschemicStrokeEncounter with "Pharmacological Contraindications for Antithrombotic Therapy at Discharge" DischargePharmacological such that DischargePharmacological.authoredOn during IschemicStrokeEncounter.period````
* Metadata: Logic Definition
  * ?: **Library Name:**DischargedonAntithromboticTherapyFHIRExample
* Metadata: ````define "Denominator Exceptions": "Encounter with Documented Reason for No Antithrombotic At Discharge" union "Encounter with Pharmacological Contraindications for Antithrombotic Therapy at Discharge"````
* Metadata: Logic Definition
  * ?: **Library Name:**CQMCommonExample
* Metadata: ````/* @description: Returns the condition that is specified as the principal diagnosis for the encounter */ define fluent function principalDiagnosis(Encounter Encounter ): singleton from ((Encounter.diagnosis D where D.rank = 1) PD return singleton from ([Condition] C where C.id = PD.condition.reference.getId()) )````
* Metadata: Logic Definition
  * ?: **Library Name:**CQMCommonExample
* Metadata: ````/* @description: Hospitalization with Observation returns the total interval from the start of any immediately prior emergency department visit through the observation visit to the discharge of the given encounter */ define fluent function hospitalizationWithObservation(TheEncounter Encounter ): TheEncounter Visit let ObsVisit: Last([Encounter: "Observation Services"] LastObs where LastObs.status = 'finished' and LastObs.period ends 1 hour or less on or before start of Visit.period sort by end of period ), VisitStart: Coalesce(start of ObsVisit.period, start of Visit.period), EDVisit: Last([Encounter: "Emergency Department Visit"] LastED where LastED.status = 'finished' and LastED.period ends 1 hour or less on or before VisitStart sort by end of period ) return Interval[Coalesce(start of EDVisit.period, VisitStart), end of Visit.period]````
* Metadata: Logic Definition
  * ?: **Library Name:**FHIRHelpers
* Metadata: ````define function ToInterval(period FHIR.Period): if period is null then null else if period."start" is null then Interval(period."start".value, period."end".value] else Interval[period."start".value, period."end".value]````
* Metadata: Logic Definition
  * ?: **Library Name:**FHIRHelpers
* Metadata: ````define function ToString(value uri): value.value````
* Metadata: Logic Definition
  * ?: **Library Name:**FHIRHelpers
* Metadata: ````define function ToCode(coding FHIR.Coding): if coding is null then null else System.Code { code: coding.code.value, system: coding.system.value, version: coding.version.value, display: coding.display.value }````
* Metadata: Logic Definition
  * ?: **Library Name:**FHIRHelpers
* Metadata: ````define function ToConcept(concept FHIR.CodeableConcept): if concept is null then null else System.Concept { codes: concept.coding C return ToCode(C), display: concept.text.value }````
* Metadata: Logic Definition
  * ?: **Library Name:**QICoreCommonExample
* Metadata: ````/* @description: Returns the tail of the given uri (i.e. everything after the last slash in the URI). @comment: This function can be used to determine the logical id of a given resource. It can be used in a single-server environment to trace references. However, this function does not attempt to resolve or distinguish the base of the given url, and so cannot be used safely in multi-server environments. */ define fluent function getId(uri String): Last(Split(uri, '/'))````
* Metadata: Logic Definition
  * ?: **Library Name:**QICoreCommonExample
* Metadata: ````/* @description: Returns true if the given MedicationRequest has a category of Community */ define fluent function isCommunity(medicationRequest MedicationNotRequested): exists (medicationRequest.category C where C ~ Community )````
* Metadata: Logic Definition
  * ?: **Library Name:**QICoreCommonExample
* Metadata: ````/* @description: Returns true if the given MedicationRequest has a category of Discharge */ define fluent function isDischarge(medicationRequest MedicationNotRequested): exists (medicationRequest.category C where C ~ Discharge )````
* Metadata: Logic Definition
  * ?: **Library Name:**QICoreCommonExample
* Metadata: ````/* @description: Returns true if the given MedicationRequest has a category of Community */ define fluent function isCommunity(medicationRequest MedicationRequest): exists (medicationRequest.category C where C ~ Community )````
* Metadata: Logic Definition
  * ?: **Library Name:**QICoreCommonExample
* Metadata: ````/* @description: Returns true if the given MedicationRequest has a category of Discharge */ define fluent function isDischarge(medicationRequest MedicationRequest): exists (medicationRequest.category C where C ~ Discharge )````
* Metadata: Terminology
* Metadata: Code System
  * ?: **Description**: Code system MedicationRequestCategory**Resource**:[MedicationRequest Category Codes](http://terminology.hl7.org/7.0.0/CodeSystem-medicationrequest-category.html)**Canonical URL**:http://terminology.hl7.org/CodeSystem/medicationrequest-category
* Metadata: Value Set
  * ?: **Description**: Value set Nonelective Inpatient Encounter**Resource**:[Non-Elective Inpatient Encounter](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.3.117.1.7.1.424/expansion)**Canonical URL**:http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.117.1.7.1.424
* Metadata: Value Set
  * ?: **Description**: Value set Hemorrhagic Stroke**Resource**:[Hemorrhagic Stroke](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.3.117.1.7.1.212/expansion)**Canonical URL**:http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.117.1.7.1.212
* Metadata: Value Set
  * ?: **Description**: Value set Ischemic Stroke**Resource**:[Ischemic Stroke](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.3.117.1.7.1.247/expansion)**Canonical URL**:http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.117.1.7.1.247
* Metadata: Value Set
  * ?: **Description**: Value set Antithrombotic Therapy for Ischemic Stroke**Resource**:[Antithrombotic Therapy](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1110.62/expansion)**Canonical URL**:http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1110.62
* Metadata: Value Set
  * ?: **Description**: Value set Payer Type**Resource**:[Payer](https://vsac.nlm.nih.gov/valueset/2.16.840.1.114222.4.11.3591/expansion)**Canonical URL**:http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.114222.4.11.3591
* Metadata: Value Set
  * ?: **Description**: Value set Discharge To Acute Care Facility**Resource**:[Discharge To Acute Care Facility](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.3.117.1.7.1.87/expansion)**Canonical URL**:http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.117.1.7.1.87
* Metadata: Value Set
  * ?: **Description**: Value set Left Against Medical Advice**Resource**:[Left Against Medical Advice](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.3.117.1.7.1.308/expansion)**Canonical URL**:http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.117.1.7.1.308
* Metadata: Value Set
  * ?: **Description**: Value set Patient Expired**Resource**:[Patient Expired](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.3.117.1.7.1.309/expansion)**Canonical URL**:http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.117.1.7.1.309
* Metadata: Value Set
  * ?: **Description**: Value set Discharged to Home for Hospice Care**Resource**:[Discharged to Home for Hospice Care](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.3.117.1.7.1.209/expansion)**Canonical URL**:http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.117.1.7.1.209
* Metadata: Value Set
  * ?: **Description**: Value set Discharged to Health Care Facility for Hospice Care**Resource**:[Discharged to Health Care Facility for Hospice Care](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.3.117.1.7.1.207/expansion)**Canonical URL**:http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.117.1.7.1.207
* Metadata: Value Set
  * ?: **Description**: Value set Comfort Measures**Resource**:[Comfort Measures](https://vsac.nlm.nih.gov/valueset/1.3.6.1.4.1.33895.1.3.0.45/expansion)**Canonical URL**:http://cts.nlm.nih.gov/fhir/ValueSet/1.3.6.1.4.1.33895.1.3.0.45
* Metadata: Value Set
  * ?: **Description**: Value set Observation Services**Resource**:[Observation Services](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1111.143/expansion)**Canonical URL**:http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1111.143
* Metadata: Value Set
  * ?: **Description**: Value set Emergency Department Visit**Resource**:[Emergency Department Visit](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.3.117.1.7.1.292/expansion)**Canonical URL**:http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.117.1.7.1.292
* Metadata: Value Set
  * ?: **Description**: Value set Medical Reason For Not Providing Treatment**Resource**:[Medical Reason](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.3.117.1.7.1.473/expansion)**Canonical URL**:http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.117.1.7.1.473
* Metadata: Value Set
  * ?: **Description**: Value set Patient Refusal**Resource**:[Patient Refusal](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.3.117.1.7.1.93/expansion)**Canonical URL**:http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.117.1.7.1.93
* Metadata: Value Set
  * ?: **Description**: Value set Pharmacological Contraindications For Antithrombotic Therapy**Resource**:[Pharmacological Contraindications For Antithrombotic Therapy](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1110.52/expansion)**Canonical URL**:http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1110.52
* Metadata: Direct Reference Code
  * ?: **Display**: Community**Code**: community**System**:http://terminology.hl7.org/CodeSystem/medicationrequest-category
* Metadata: Direct Reference Code
  * ?: **Display**: Discharge**Code**: discharge**System**:http://terminology.hl7.org/CodeSystem/medicationrequest-category
* Metadata: Dependencies
* Metadata: Dependency
  * ?: **Description**: Library SDE**Resource**:[SupplementalDataElementsExample](Library-SupplementalDataElementsExample.md)**Canonical URL**:http://somewhere.org/fhir/uv/mycontentig/Library/SupplementalDataElementsExample
* Metadata: Dependency
  * ?: **Description**: Library TJC**Resource**:[TJCOverallExample](Library-TJCOverallExample.md)**Canonical URL**:http://somewhere.org/fhir/uv/mycontentig/Library/TJCOverallExample
* Metadata: Dependency
  * ?: **Description**: Library FHIRHelpers**Resource**:`http://somewhere.org/fhir/uv/mycontentig/Library/FHIRHelpers|4.0.1`**Canonical URL**:http://somewhere.org/fhir/uv/mycontentig/Library/FHIRHelpers|4.0.1
* Metadata: Dependency
  * ?: **Description**: Library CQMCommon**Resource**:[CQMCommonExample](Library-CQMCommonExample.md)**Canonical URL**:http://somewhere.org/fhir/uv/mycontentig/Library/CQMCommonExample
* Metadata: Dependency
  * ?: **Description**: Library QICoreCommon**Resource**:[QICoreCommonExample](Library-QICoreCommonExample.md)**Canonical URL**:http://somewhere.org/fhir/uv/mycontentig/Library/QICoreCommonExample
* Metadata: Data Requirements
* Metadata: Data Requirement
  * ?: **Type**: Patient**Profile(s)**:[QICore Patient](http://hl7.org/fhir/us/qicore/STU5/StructureDefinition-qicore-patient.html)**Must Support Elements**: url, extension
* Metadata: Data Requirement
  * ?: **Type**: Encounter**Profile(s)**:[QICore Encounter](http://hl7.org/fhir/us/qicore/STU5/StructureDefinition-qicore-encounter.html)**Must Support Elements**: type, period, rank, rank.value, condition, condition.reference, condition.reference.value, hospitalization, hospitalization.dischargeDisposition**Code Filter(s)**:**Path**: type**ValueSet**:[Non-Elective Inpatient Encounter](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.3.117.1.7.1.424/expansion)
* Metadata: Data Requirement
  * ?: **Type**: Encounter**Profile(s)**:[QICore Encounter](http://hl7.org/fhir/us/qicore/STU5/StructureDefinition-qicore-encounter.html)**Must Support Elements**: type, status, status.value, period, rank, rank.value, condition, condition.reference, condition.reference.value, hospitalization, hospitalization.dischargeDisposition**Code Filter(s)**:**Path**: type**ValueSet**:[Observation Services](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1111.143/expansion)
* Metadata: Data Requirement
  * ?: **Type**: Encounter**Profile(s)**:[QICore Encounter](http://hl7.org/fhir/us/qicore/STU5/StructureDefinition-qicore-encounter.html)**Must Support Elements**: type, status, status.value, period, rank, rank.value, condition, condition.reference, condition.reference.value, hospitalization, hospitalization.dischargeDisposition**Code Filter(s)**:**Path**: type**ValueSet**:[Emergency Department Visit](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.3.117.1.7.1.292/expansion)
* Metadata: Data Requirement
  * ?: **Type**: Condition**Profile(s)**:`http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-condition`**Must Support Elements**: id, id.value
* Metadata: Data Requirement
  * ?: **Type**: MedicationRequest**Profile(s)**:[QICore MedicationRequest](http://hl7.org/fhir/us/qicore/STU5/StructureDefinition-qicore-medicationrequest.html)**Must Support Elements**: medication, authoredOn, authoredOn.value, status, status.value, intent, intent.value, doNotPerform, doNotPerform.value**Code Filter(s)**:**Path**: medication**ValueSet**:[Antithrombotic Therapy](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1110.62/expansion)
* Metadata: Data Requirement
  * ?: **Type**: MedicationRequest**Profile(s)**:[QICore MedicationRequest](http://hl7.org/fhir/us/qicore/STU5/StructureDefinition-qicore-medicationrequest.html)**Must Support Elements**: medication, authoredOn, authoredOn.value, status, status.value, intent, intent.value, doNotPerform, doNotPerform.value**Code Filter(s)**:**Path**: medication**ValueSet**:[Pharmacological Contraindications For Antithrombotic Therapy](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1110.52/expansion)
* Metadata: Data Requirement
  * ?: **Type**: MedicationRequest**Profile(s)**:[QICore MedicationRequest](http://hl7.org/fhir/us/qicore/STU5/StructureDefinition-qicore-medicationrequest.html)**Must Support Elements**: medication.reference.value, authoredOn, authoredOn.value, status, status.value, intent, intent.value, doNotPerform, doNotPerform.value
* Metadata: Data Requirement
  * ?: **Type**: Medication**Profile(s)**:[QICore Medication](http://hl7.org/fhir/us/qicore/STU5/StructureDefinition-qicore-medication.html)**Must Support Elements**: id.value, code
* Metadata: Data Requirement
  * ?: **Type**: Coverage**Profile(s)**:[QICore Coverage](http://hl7.org/fhir/us/qicore/STU5/StructureDefinition-qicore-coverage.html)**Must Support Elements**: type, period**Code Filter(s)**:**Path**: type**ValueSet**:[Payer](https://vsac.nlm.nih.gov/valueset/2.16.840.1.114222.4.11.3591/expansion)
* Metadata: Data Requirement
  * ?: **Type**: ServiceRequest**Profile(s)**:[QICore ServiceRequest](http://hl7.org/fhir/us/qicore/STU5/StructureDefinition-qicore-servicerequest.html)**Must Support Elements**: code, status, status.value, intent, intent.value, doNotPerform, doNotPerform.value**Code Filter(s)**:**Path**: code**ValueSet**:[Comfort Measures](https://vsac.nlm.nih.gov/valueset/1.3.6.1.4.1.33895.1.3.0.45/expansion)
* Metadata: Data Requirement
  * ?: **Type**: Procedure**Profile(s)**:[QICore Procedure](http://hl7.org/fhir/us/qicore/STU5/StructureDefinition-qicore-procedure.html)**Must Support Elements**: code, status, status.value**Code Filter(s)**:**Path**: code**ValueSet**:[Comfort Measures](https://vsac.nlm.nih.gov/valueset/1.3.6.1.4.1.33895.1.3.0.45/expansion)
* Metadata: Data Requirement
  * ?: **Type**: MedicationRequest**Profile(s)**:`http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-mednotrequested`**Must Support Elements**: medication, reasonCode, intent, intent.value, authoredOn, authoredOn.value**Code Filter(s)**:**Path**: medication**ValueSet**:[Antithrombotic Therapy](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1110.62/expansion)
* Metadata: Parameters
* Metadata: 
  * ?: 
| | | | | |
| :--- | :--- | :--- | :--- | :--- |
| **Name** | **Use** | **Card.** | **Type** | **Documentation** |
| Measurement Period | In | 0..1 | Period |  |
| SDE Sex | Out | 0..1 | Coding |  |
| Numerator | Out | 0..* | Resource |  |
| Denominator | Out | 0..* | Resource |  |
| SDE Payer | Out | 0..* | Resource |  |
| Initial Population | Out | 0..* | Resource |  |
| SDE Ethnicity | Out | 0..1 | Resource |  |
| Denominator Exclusions | Out | 0..* | Resource |  |
| SDE Race | Out | 0..1 | Resource |  |
| Denominator Exceptions | Out | 0..* | Resource |  |

* Metadata: Generated using version 0.5.3 of the sample-content-ig Liquid templates



## Resource Content

```json
{
  "resourceType" : "Measure",
  "id" : "DischargedonAntithromboticTherapyFHIRExample",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/computable-measure-cqfm"
    ]
  },
  "contained" : [
    {
      "resourceType" : "Library",
      "id" : "effective-data-requirements",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-directReferenceCode",
          "valueCoding" : {
            "system" : "http://terminology.hl7.org/CodeSystem/medicationrequest-category",
            "code" : "community",
            "display" : "Community"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-directReferenceCode",
          "valueCoding" : {
            "system" : "http://terminology.hl7.org/CodeSystem/medicationrequest-category",
            "code" : "discharge",
            "display" : "Discharge"
          }
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "SupplementalDataElementsExample"
            },
            {
              "url" : "name",
              "valueString" : "SDE Sex"
            },
            {
              "url" : "statement",
              "valueString" : "define \"SDE Sex\":\n  case\n      when Patient.gender = 'male' then Code { code: 'M', system: 'http://hl7.org/fhir/v3/AdministrativeGender', display: 'Male' }\n      when Patient.gender = 'female' then Code { code: 'F', system: 'http://hl7.org/fhir/v3/AdministrativeGender', display: 'Female' }\n      else null\n    end"
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 0
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "DischargedonAntithromboticTherapyFHIRExample"
            },
            {
              "url" : "name",
              "valueString" : "SDE Sex"
            },
            {
              "url" : "statement",
              "valueString" : "define \"SDE Sex\":\n  SDE.\"SDE Sex\""
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 1
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "TJCOverallExample"
            },
            {
              "url" : "name",
              "valueString" : "Non Elective Inpatient Encounter"
            },
            {
              "url" : "statement",
              "valueString" : "define \"Non Elective Inpatient Encounter\":\n  [\"Encounter\": \"Nonelective Inpatient Encounter\"] NonElectiveEncounter\n        where NonElectiveEncounter.period ends during day of \"Measurement Period\""
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 2
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "TJCOverallExample"
            },
            {
              "url" : "name",
              "valueString" : "All Stroke Encounter"
            },
            {
              "url" : "statement",
              "valueString" : "define \"All Stroke Encounter\":\n  \"Non Elective Inpatient Encounter\" NonElectiveEncounter\n  let ConditionCode: NonElectiveEncounter.principalDiagnosis().code\n    where ( ConditionCode in \"Hemorrhagic Stroke\"\n       or   ConditionCode in \"Ischemic Stroke\" )"
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 3
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "TJCOverallExample"
            },
            {
              "url" : "name",
              "valueString" : "Encounter with Principal Diagnosis and Age"
            },
            {
              "url" : "statement",
              "valueString" : "define \"Encounter with Principal Diagnosis and Age\":\n  \"All Stroke Encounter\" AllStrokeEncounter\n    where AgeInYearsAt(date from start of AllStrokeEncounter.period ) >= 18"
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 4
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "TJCOverallExample"
            },
            {
              "url" : "name",
              "valueString" : "Ischemic Stroke Encounter"
            },
            {
              "url" : "statement",
              "valueString" : "define \"Ischemic Stroke Encounter\":\n  \"Encounter with Principal Diagnosis and Age\" EncounterWithAge\n    where EncounterWithAge.principalDiagnosis().code in \"Ischemic Stroke\""
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 5
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "DischargedonAntithromboticTherapyFHIRExample"
            },
            {
              "url" : "name",
              "valueString" : "Numerator"
            },
            {
              "url" : "statement",
              "valueString" : "define \"Numerator\":\n  TJC.\"Ischemic Stroke Encounter\" IschemicStrokeEncounter\n    with [\"MedicationRequest\": \"Antithrombotic Therapy for Ischemic Stroke\"] DischargeAntithrombotic\n      such that DischargeAntithrombotic.authoredOn during IschemicStrokeEncounter.period"
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 6
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "DischargedonAntithromboticTherapyFHIRExample"
            },
            {
              "url" : "name",
              "valueString" : "Denominator"
            },
            {
              "url" : "statement",
              "valueString" : "define \"Denominator\":\n  TJC.\"Ischemic Stroke Encounter\""
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 7
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "SupplementalDataElementsExample"
            },
            {
              "url" : "name",
              "valueString" : "SDE Payer"
            },
            {
              "url" : "statement",
              "valueString" : "define \"SDE Payer\":\n  [Coverage: type in \"Payer Type\"] Payer\n    return {\n      code: Payer.type,\n      period: Payer.period\n    }"
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 8
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "DischargedonAntithromboticTherapyFHIRExample"
            },
            {
              "url" : "name",
              "valueString" : "SDE Payer"
            },
            {
              "url" : "statement",
              "valueString" : "define \"SDE Payer\":\n  SDE.\"SDE Payer\""
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 9
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "DischargedonAntithromboticTherapyFHIRExample"
            },
            {
              "url" : "name",
              "valueString" : "Initial Population"
            },
            {
              "url" : "statement",
              "valueString" : "define \"Initial Population\":\n  TJC.\"Encounter with Principal Diagnosis and Age\""
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 10
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "SupplementalDataElementsExample"
            },
            {
              "url" : "name",
              "valueString" : "SDE Ethnicity"
            },
            {
              "url" : "statement",
              "valueString" : "define \"SDE Ethnicity\":\n  Patient.ethnicity E\n    return Tuple {\n      codes: { E.ombCategory } union E.detailed,\n      display: E.text\n    }"
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 11
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "DischargedonAntithromboticTherapyFHIRExample"
            },
            {
              "url" : "name",
              "valueString" : "SDE Ethnicity"
            },
            {
              "url" : "statement",
              "valueString" : "define \"SDE Ethnicity\":\n  SDE.\"SDE Ethnicity\""
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 12
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "TJCOverallExample"
            },
            {
              "url" : "name",
              "valueString" : "Ischemic Stroke Encounters with Discharge Disposition"
            },
            {
              "url" : "statement",
              "valueString" : "define \"Ischemic Stroke Encounters with Discharge Disposition\":\n  \"Ischemic Stroke Encounter\" IschemicStrokeEncounter\n  let DischDisp: IschemicStrokeEncounter.hospitalization.dischargeDisposition\n  \twhere  DischDisp in \"Discharge To Acute Care Facility\"\n\t\tor DischDisp in \"Left Against Medical Advice\"\n\t\tor DischDisp in \"Patient Expired\"\n\t\tor DischDisp in \"Discharged to Home for Hospice Care\"\n\t\tor DischDisp in \"Discharged to Health Care Facility for Hospice Care\""
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 13
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "TJCOverallExample"
            },
            {
              "url" : "name",
              "valueString" : "Intervention Comfort Measures"
            },
            {
              "url" : "statement",
              "valueString" : "define \"Intervention Comfort Measures\":\n  ( [\"ServiceRequest\": code in \"Comfort Measures\"] SR\n    where SR.status in { 'active', 'completed', 'on-hold' }\n      and SR.intent in { 'order', 'original-order', 'reflex-order', 'filler-order', 'instance-order' }\n      and SR.doNotPerform is not true\n  )  \n  union ( [\"Procedure\": \"Comfort Measures\"] InterventionPerformed\n        where InterventionPerformed.status in { 'completed', 'in-progress' }\n  )"
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 14
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "DischargedonAntithromboticTherapyFHIRExample"
            },
            {
              "url" : "name",
              "valueString" : "Encounter with Comfort Measures during Hospitalization for Patients with Documented Ischemic Stroke"
            },
            {
              "url" : "statement",
              "valueString" : "define \"Encounter with Comfort Measures during Hospitalization for Patients with Documented Ischemic Stroke\":\n  \"Denominator\" Encounter\n    with TJC.\"Intervention Comfort Measures\" ComfortMeasure\n      such that Coalesce(start of ComfortMeasure.performed.toInterval(), ComfortMeasure.authoredOn) during Encounter.hospitalizationWithObservation ( )"
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 15
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "DischargedonAntithromboticTherapyFHIRExample"
            },
            {
              "url" : "name",
              "valueString" : "Denominator Exclusions"
            },
            {
              "url" : "statement",
              "valueString" : "define \"Denominator Exclusions\":\n  TJC.\"Ischemic Stroke Encounters with Discharge Disposition\"\n    union \"Encounter with Comfort Measures during Hospitalization for Patients with Documented Ischemic Stroke\""
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 16
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "SupplementalDataElementsExample"
            },
            {
              "url" : "name",
              "valueString" : "SDE Race"
            },
            {
              "url" : "statement",
              "valueString" : "define \"SDE Race\":\n  Patient.race R\n    return Tuple {\n      codes: R.ombCategory union R.detailed,\n      display: R.text\n    }"
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 17
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "DischargedonAntithromboticTherapyFHIRExample"
            },
            {
              "url" : "name",
              "valueString" : "SDE Race"
            },
            {
              "url" : "statement",
              "valueString" : "define \"SDE Race\":\n  SDE.\"SDE Race\""
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 18
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "DischargedonAntithromboticTherapyFHIRExample"
            },
            {
              "url" : "name",
              "valueString" : "Reason for Not Giving Antithrombotic at Discharge"
            },
            {
              "url" : "statement",
              "valueString" : "define \"Reason for Not Giving Antithrombotic at Discharge\":\n  [\"MedicationNotRequested\": \"Antithrombotic Therapy for Ischemic Stroke\"] NoAntithromboticDischarge\n    where ( NoAntithromboticDischarge.reasonCode in \"Medical Reason For Not Providing Treatment\"\n        or NoAntithromboticDischarge.reasonCode in \"Patient Refusal\"\n    )\n      and ( NoAntithromboticDischarge.isCommunity ( )\n          or NoAntithromboticDischarge.isDischarge ( )\n      )\n      and NoAntithromboticDischarge.intent in { 'order', 'original-order', 'reflex-order', 'filler-order', 'instance-order' }"
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 19
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "DischargedonAntithromboticTherapyFHIRExample"
            },
            {
              "url" : "name",
              "valueString" : "Encounter with Documented Reason for No Antithrombotic At Discharge"
            },
            {
              "url" : "statement",
              "valueString" : "define \"Encounter with Documented Reason for No Antithrombotic At Discharge\":\n  TJC.\"Ischemic Stroke Encounter\" IschemicStrokeEncounter\n    with \"Reason for Not Giving Antithrombotic at Discharge\" NoDischargeAntithrombotic\n      such that NoDischargeAntithrombotic.authoredOn during IschemicStrokeEncounter.period"
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 20
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "DischargedonAntithromboticTherapyFHIRExample"
            },
            {
              "url" : "name",
              "valueString" : "Pharmacological Contraindications for Antithrombotic Therapy at Discharge"
            },
            {
              "url" : "statement",
              "valueString" : "define \"Pharmacological Contraindications for Antithrombotic Therapy at Discharge\":\n  [\"MedicationRequest\": \"Pharmacological Contraindications For Antithrombotic Therapy\"] Pharmacological\n    where ( Pharmacological.isCommunity ( )\n        or Pharmacological.isDischarge ( )\n    )\n      and Pharmacological.status in { 'active', 'completed' }\n      and Pharmacological.intent in { 'order', 'original-order', 'reflex-order', 'filler-order', 'instance-order' }\n      and Pharmacological.doNotPerform is not true"
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 21
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "DischargedonAntithromboticTherapyFHIRExample"
            },
            {
              "url" : "name",
              "valueString" : "Encounter with Pharmacological Contraindications for Antithrombotic Therapy at Discharge"
            },
            {
              "url" : "statement",
              "valueString" : "define \"Encounter with Pharmacological Contraindications for Antithrombotic Therapy at Discharge\":\n  TJC.\"Ischemic Stroke Encounter\" IschemicStrokeEncounter\n    with \"Pharmacological Contraindications for Antithrombotic Therapy at Discharge\" DischargePharmacological\n      such that DischargePharmacological.authoredOn during IschemicStrokeEncounter.period"
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 22
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "DischargedonAntithromboticTherapyFHIRExample"
            },
            {
              "url" : "name",
              "valueString" : "Denominator Exceptions"
            },
            {
              "url" : "statement",
              "valueString" : "define \"Denominator Exceptions\":\n  \"Encounter with Documented Reason for No Antithrombotic At Discharge\"\n    union \"Encounter with Pharmacological Contraindications for Antithrombotic Therapy at Discharge\""
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 23
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "FHIRHelpers"
            },
            {
              "url" : "name",
              "valueString" : "ToInterval"
            },
            {
              "url" : "statement",
              "valueString" : "define function ToInterval(period FHIR.Period):\n    if period is null then\n        null\n    else\n        if period.\"start\" is null then\n            Interval(period.\"start\".value, period.\"end\".value]\n        else\n            Interval[period.\"start\".value, period.\"end\".value]"
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 24
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "CQMCommonExample"
            },
            {
              "url" : "name",
              "valueString" : "principalDiagnosis"
            },
            {
              "url" : "statement",
              "valueString" : "/*\n@description: Returns the condition that is specified as the principal diagnosis for the encounter\n*/\ndefine fluent function principalDiagnosis(Encounter Encounter ):\n\tsingleton from ((Encounter.diagnosis D where D.rank = 1) PD\n      return singleton from ([Condition] C where C.id = PD.condition.reference.getId())\n\t)"
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 25
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "QICoreCommonExample"
            },
            {
              "url" : "name",
              "valueString" : "getId"
            },
            {
              "url" : "statement",
              "valueString" : "/*\n@description: Returns the tail of the given uri (i.e. everything after the last slash in the URI).\n@comment: This function can be used to determine the logical id of a given resource. It can be used in\na single-server environment to trace references. However, this function does not attempt to resolve\nor distinguish the base of the given url, and so cannot be used safely in multi-server environments.\n*/\ndefine fluent function getId(uri String):\n  Last(Split(uri, '/'))"
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 26
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "FHIRHelpers"
            },
            {
              "url" : "name",
              "valueString" : "ToString"
            },
            {
              "url" : "statement",
              "valueString" : "define function ToString(value uri): value.value"
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 27
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "FHIRHelpers"
            },
            {
              "url" : "name",
              "valueString" : "ToCode"
            },
            {
              "url" : "statement",
              "valueString" : "define function ToCode(coding FHIR.Coding):\n    if coding is null then\n        null\n    else\n        System.Code {\n          code: coding.code.value,\n          system: coding.system.value,\n          version: coding.version.value,\n          display: coding.display.value\n        }"
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 28
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "CQMCommonExample"
            },
            {
              "url" : "name",
              "valueString" : "hospitalizationWithObservation"
            },
            {
              "url" : "statement",
              "valueString" : "/*\n@description: Hospitalization with Observation returns the total interval from the start of any immediately prior emergency department visit through the observation visit to the discharge of the given encounter\n*/\ndefine fluent function hospitalizationWithObservation(TheEncounter Encounter ):\n  TheEncounter Visit\n  \t\tlet ObsVisit: Last([Encounter: \"Observation Services\"] LastObs\n  \t\t\t\twhere LastObs.status = 'finished'\n            and LastObs.period ends 1 hour or less on or before start of Visit.period\n  \t\t\t\tsort by end of period\n  \t\t\t),\n  \t\t\tVisitStart: Coalesce(start of ObsVisit.period, start of Visit.period),\n  \t\t\tEDVisit: Last([Encounter: \"Emergency Department Visit\"] LastED\n  \t\t\t\twhere LastED.status = 'finished'\n            and LastED.period ends 1 hour or less on or before VisitStart\n  \t\t\t\tsort by end of period\n  \t\t\t)\n  \t\treturn Interval[Coalesce(start of EDVisit.period, VisitStart), end of Visit.period]"
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 29
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "FHIRHelpers"
            },
            {
              "url" : "name",
              "valueString" : "ToConcept"
            },
            {
              "url" : "statement",
              "valueString" : "define function ToConcept(concept FHIR.CodeableConcept):\n    if concept is null then\n        null\n    else\n        System.Concept {\n            codes: concept.coding C return ToCode(C),\n            display: concept.text.value\n        }"
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 30
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "QICoreCommonExample"
            },
            {
              "url" : "name",
              "valueString" : "isCommunity"
            },
            {
              "url" : "statement",
              "valueString" : "/*\n@description: Returns true if the given MedicationRequest has a category of Community\n*/\ndefine fluent function isCommunity(medicationRequest MedicationNotRequested):\n  exists (medicationRequest.category C\n    where C ~ Community\n  )"
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 31
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "QICoreCommonExample"
            },
            {
              "url" : "name",
              "valueString" : "isDischarge"
            },
            {
              "url" : "statement",
              "valueString" : "/*\n@description: Returns true if the given MedicationRequest has a category of Discharge\n*/\ndefine fluent function isDischarge(medicationRequest MedicationNotRequested):\n  exists (medicationRequest.category C\n    where C ~ Discharge\n  )"
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 32
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "QICoreCommonExample"
            },
            {
              "url" : "name",
              "valueString" : "isCommunity"
            },
            {
              "url" : "statement",
              "valueString" : "/*\n@description: Returns true if the given MedicationRequest has a category of Community\n*/\ndefine fluent function isCommunity(medicationRequest MedicationRequest):\n  exists (medicationRequest.category C\n    where C ~ Community\n  )"
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 33
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        },
        {
          "extension" : [
            {
              "url" : "libraryName",
              "valueString" : "QICoreCommonExample"
            },
            {
              "url" : "name",
              "valueString" : "isDischarge"
            },
            {
              "url" : "statement",
              "valueString" : "/*\n@description: Returns true if the given MedicationRequest has a category of Discharge\n*/\ndefine fluent function isDischarge(medicationRequest MedicationRequest):\n  exists (medicationRequest.category C\n    where C ~ Discharge\n  )"
            },
            {
              "url" : "displaySequence",
              "valueInteger" : 34
            }
          ],
          "url" : "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"
        }
      ],
      "name" : "EffectiveDataRequirements",
      "status" : "active",
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/library-type",
            "code" : "module-definition"
          }
        ]
      },
      "relatedArtifact" : [
        {
          "type" : "depends-on",
          "display" : "Library SDE",
          "resource" : "http://somewhere.org/fhir/uv/mycontentig/Library/SupplementalDataElementsExample"
        },
        {
          "type" : "depends-on",
          "display" : "Library TJC",
          "resource" : "http://somewhere.org/fhir/uv/mycontentig/Library/TJCOverallExample"
        },
        {
          "type" : "depends-on",
          "display" : "Library FHIRHelpers",
          "resource" : "http://somewhere.org/fhir/uv/mycontentig/Library/FHIRHelpers|4.0.1"
        },
        {
          "type" : "depends-on",
          "display" : "Library CQMCommon",
          "resource" : "http://somewhere.org/fhir/uv/mycontentig/Library/CQMCommonExample"
        },
        {
          "type" : "depends-on",
          "display" : "Library QICoreCommon",
          "resource" : "http://somewhere.org/fhir/uv/mycontentig/Library/QICoreCommonExample"
        },
        {
          "type" : "depends-on",
          "display" : "Code system MedicationRequestCategory",
          "resource" : "http://terminology.hl7.org/CodeSystem/medicationrequest-category"
        },
        {
          "type" : "depends-on",
          "display" : "Value set Nonelective Inpatient Encounter",
          "resource" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.117.1.7.1.424"
        },
        {
          "type" : "depends-on",
          "display" : "Value set Hemorrhagic Stroke",
          "resource" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.117.1.7.1.212"
        },
        {
          "type" : "depends-on",
          "display" : "Value set Ischemic Stroke",
          "resource" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.117.1.7.1.247"
        },
        {
          "type" : "depends-on",
          "display" : "Value set Antithrombotic Therapy for Ischemic Stroke",
          "resource" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1110.62"
        },
        {
          "type" : "depends-on",
          "display" : "Value set Payer Type",
          "resource" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.114222.4.11.3591"
        },
        {
          "type" : "depends-on",
          "display" : "Value set Discharge To Acute Care Facility",
          "resource" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.117.1.7.1.87"
        },
        {
          "type" : "depends-on",
          "display" : "Value set Left Against Medical Advice",
          "resource" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.117.1.7.1.308"
        },
        {
          "type" : "depends-on",
          "display" : "Value set Patient Expired",
          "resource" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.117.1.7.1.309"
        },
        {
          "type" : "depends-on",
          "display" : "Value set Discharged to Home for Hospice Care",
          "resource" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.117.1.7.1.209"
        },
        {
          "type" : "depends-on",
          "display" : "Value set Discharged to Health Care Facility for Hospice Care",
          "resource" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.117.1.7.1.207"
        },
        {
          "type" : "depends-on",
          "display" : "Value set Comfort Measures",
          "resource" : "http://cts.nlm.nih.gov/fhir/ValueSet/1.3.6.1.4.1.33895.1.3.0.45"
        },
        {
          "type" : "depends-on",
          "display" : "Value set Observation Services",
          "resource" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1111.143"
        },
        {
          "type" : "depends-on",
          "display" : "Value set Emergency Department Visit",
          "resource" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.117.1.7.1.292"
        },
        {
          "type" : "depends-on",
          "display" : "Value set Medical Reason For Not Providing Treatment",
          "resource" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.117.1.7.1.473"
        },
        {
          "type" : "depends-on",
          "display" : "Value set Patient Refusal",
          "resource" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.117.1.7.1.93"
        },
        {
          "type" : "depends-on",
          "display" : "Value set Pharmacological Contraindications For Antithrombotic Therapy",
          "resource" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1110.52"
        }
      ],
      "parameter" : [
        {
          "name" : "Measurement Period",
          "use" : "in",
          "min" : 0,
          "max" : "1",
          "type" : "Period"
        },
        {
          "name" : "SDE Sex",
          "use" : "out",
          "min" : 0,
          "max" : "1",
          "type" : "Coding"
        },
        {
          "name" : "Numerator",
          "use" : "out",
          "min" : 0,
          "max" : "*",
          "type" : "Resource"
        },
        {
          "name" : "Denominator",
          "use" : "out",
          "min" : 0,
          "max" : "*",
          "type" : "Resource"
        },
        {
          "name" : "SDE Payer",
          "use" : "out",
          "min" : 0,
          "max" : "*",
          "type" : "Resource"
        },
        {
          "name" : "Initial Population",
          "use" : "out",
          "min" : 0,
          "max" : "*",
          "type" : "Resource"
        },
        {
          "name" : "SDE Ethnicity",
          "use" : "out",
          "min" : 0,
          "max" : "1",
          "type" : "Resource"
        },
        {
          "name" : "Denominator Exclusions",
          "use" : "out",
          "min" : 0,
          "max" : "*",
          "type" : "Resource"
        },
        {
          "name" : "SDE Race",
          "use" : "out",
          "min" : 0,
          "max" : "1",
          "type" : "Resource"
        },
        {
          "name" : "Denominator Exceptions",
          "use" : "out",
          "min" : 0,
          "max" : "*",
          "type" : "Resource"
        }
      ],
      "dataRequirement" : [
        {
          "type" : "Patient",
          "profile" : [
            "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-patient"
          ],
          "mustSupport" : ["url", "extension"]
        },
        {
          "type" : "Encounter",
          "profile" : [
            "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-encounter"
          ],
          "mustSupport" : [
            "type",
            "period",
            "rank",
            "rank.value",
            "condition",
            "condition.reference",
            "condition.reference.value",
            "hospitalization",
            "hospitalization.dischargeDisposition"
          ],
          "codeFilter" : [
            {
              "path" : "type",
              "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.117.1.7.1.424"
            }
          ]
        },
        {
          "type" : "Encounter",
          "profile" : [
            "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-encounter"
          ],
          "mustSupport" : [
            "type",
            "status",
            "status.value",
            "period",
            "rank",
            "rank.value",
            "condition",
            "condition.reference",
            "condition.reference.value",
            "hospitalization",
            "hospitalization.dischargeDisposition"
          ],
          "codeFilter" : [
            {
              "path" : "type",
              "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1111.143"
            }
          ]
        },
        {
          "type" : "Encounter",
          "profile" : [
            "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-encounter"
          ],
          "mustSupport" : [
            "type",
            "status",
            "status.value",
            "period",
            "rank",
            "rank.value",
            "condition",
            "condition.reference",
            "condition.reference.value",
            "hospitalization",
            "hospitalization.dischargeDisposition"
          ],
          "codeFilter" : [
            {
              "path" : "type",
              "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.117.1.7.1.292"
            }
          ]
        },
        {
          "type" : "Condition",
          "profile" : [
            "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-condition"
          ],
          "mustSupport" : ["id", "id.value"]
        },
        {
          "type" : "MedicationRequest",
          "profile" : [
            "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-medicationrequest"
          ],
          "mustSupport" : [
            "medication",
            "authoredOn",
            "authoredOn.value",
            "status",
            "status.value",
            "intent",
            "intent.value",
            "doNotPerform",
            "doNotPerform.value"
          ],
          "codeFilter" : [
            {
              "path" : "medication",
              "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1110.62"
            }
          ]
        },
        {
          "type" : "MedicationRequest",
          "profile" : [
            "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-medicationrequest"
          ],
          "mustSupport" : [
            "medication",
            "authoredOn",
            "authoredOn.value",
            "status",
            "status.value",
            "intent",
            "intent.value",
            "doNotPerform",
            "doNotPerform.value"
          ],
          "codeFilter" : [
            {
              "path" : "medication",
              "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1110.52"
            }
          ]
        },
        {
          "type" : "MedicationRequest",
          "profile" : [
            "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-medicationrequest"
          ],
          "mustSupport" : [
            "medication.reference.value",
            "authoredOn",
            "authoredOn.value",
            "status",
            "status.value",
            "intent",
            "intent.value",
            "doNotPerform",
            "doNotPerform.value"
          ]
        },
        {
          "type" : "Medication",
          "profile" : [
            "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-medication"
          ],
          "mustSupport" : ["id.value", "code"]
        },
        {
          "type" : "Coverage",
          "profile" : [
            "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-coverage"
          ],
          "mustSupport" : ["type", "period"],
          "codeFilter" : [
            {
              "path" : "type",
              "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.114222.4.11.3591"
            }
          ]
        },
        {
          "type" : "ServiceRequest",
          "profile" : [
            "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-servicerequest"
          ],
          "mustSupport" : [
            "code",
            "status",
            "status.value",
            "intent",
            "intent.value",
            "doNotPerform",
            "doNotPerform.value"
          ],
          "codeFilter" : [
            {
              "path" : "code",
              "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/1.3.6.1.4.1.33895.1.3.0.45"
            }
          ]
        },
        {
          "type" : "Procedure",
          "profile" : [
            "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-procedure"
          ],
          "mustSupport" : ["code", "status", "status.value"],
          "codeFilter" : [
            {
              "path" : "code",
              "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/1.3.6.1.4.1.33895.1.3.0.45"
            }
          ]
        },
        {
          "type" : "MedicationRequest",
          "profile" : [
            "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-mednotrequested"
          ],
          "mustSupport" : [
            "medication",
            "reasonCode",
            "intent",
            "intent.value",
            "authoredOn",
            "authoredOn.value"
          ],
          "codeFilter" : [
            {
              "path" : "medication",
              "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1110.62"
            }
          ]
        },
        {
          "type" : "MedicationRequest",
          "profile" : [
            "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-mednotrequested"
          ],
          "mustSupport" : [
            "medication",
            "reasonCode",
            "intent",
            "intent.value",
            "authoredOn",
            "authoredOn.value"
          ],
          "codeFilter" : [
            {
              "path" : "medication",
              "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1110.62"
            }
          ]
        }
      ]
    }
  ],
  "extension" : [
    {
      "id" : "supplementalDataGuidance",
      "extension" : [
        {
          "url" : "guidance",
          "valueString" : "Patient's Ethnicity:\nHispanic or Latino\nNot Hispanic or Latino\n Patient's Payer:\nCategories of types of health care payer entities as defined by the US Public Health Data Consortium SOP code system\n Patient's Race:\nNative Hawaiian or Other Pacific Islander\nAsian\nAmerican Indian or Alaska Native\nOther Race\nWhite\nBlack or African American\n Patient's Sex:\nGender identity restricted to only Male and Female used in administrative situations requiring a restriction to these two categories."
        },
        {
          "url" : "usage",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/measure-data-usage",
                "code" : "supplemental-data",
                "display" : "Supplemental Data"
              }
            ],
            "text" : "Supplemental Data Guidance"
          }
        }
      ],
      "url" : "http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-supplementalDataGuidance"
    },
    {
      "url" : "http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-softwaresystem",
      "valueReference" : {
        "reference" : "Device/cqf-tooling"
      }
    },
    {
      "url" : "http://hl7.org/fhir/uv/crmi/StructureDefinition/crmi-effectiveDataRequirements",
      "valueCanonical" : "#effective-data-requirements"
    }
  ],
  "url" : "http://somewhere.org/fhir/uv/mycontentig/Measure/DischargedonAntithromboticTherapyFHIRExample",
  "identifier" : [
    {
      "use" : "usual",
      "type" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/us/cqfmeasures/CodeSystem/identifier-type",
            "code" : "short-name"
          }
        ]
      },
      "system" : "https://madie.cms.gov/measure/shortName",
      "value" : "CMS104FHIR"
    },
    {
      "use" : "official",
      "type" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/us/cqfmeasures/CodeSystem/identifier-type",
            "code" : "version-independent"
          }
        ]
      },
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:uuid:4f57e4a2-097b-45f8-9c85-91b35ea92dc1"
    },
    {
      "use" : "official",
      "type" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/us/cqfmeasures/CodeSystem/identifier-type",
            "code" : "version-specific"
          }
        ]
      },
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:uuid:e0b5379f-4b9c-4177-a530-d744fa95d080"
    },
    {
      "use" : "official",
      "type" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/us/cqfmeasures/CodeSystem/identifier-type",
            "code" : "publisher"
          }
        ]
      },
      "system" : "https://madie.cms.gov/measure/cmsId",
      "value" : "104FHIR",
      "assigner" : {
        "display" : "CMS"
      }
    }
  ],
  "version" : "0.5.3",
  "name" : "DischargedonAntithromboticTherapyFHIRExample",
  "title" : "Discharged on Antithrombotic Therapy FHIR Example",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-09-30T04:16:55+00:00",
  "publisher" : "HL7 International - [Some] Work Group",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org/Special/committees/[something]"
        }
      ]
    }
  ],
  "description" : "Ischemic stroke patients prescribed or continuing to take antithrombotic therapy at hospital discharge",
  "useContext" : [
    {
      "code" : {
        "system" : "http://terminology.hl7.org/CodeSystem/usage-context-type",
        "code" : "venue"
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/uv/cqm/ValueSet/intended-venue",
            "code" : "eh",
            "display" : "EH"
          }
        ]
      }
    }
  ],
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001"
        }
      ]
    }
  ],
  "purpose" : "UNKNOWN",
  "usage" : "The \"Nonelective Inpatient Encounter\" value set intends to capture all non-scheduled hospitalizations. This value set is a subset of the \"Inpatient encounter\" value set, excluding concepts that specifically refer to elective hospital admissions. Non-elective admissions include emergency, urgent and unplanned admissions.\n\nThe \"MedicationRequest\" datatype refers to the discharge medication list and is intended to express medications ordered for post-discharge use.\n\nThe denominator population includes patients with inpatient hospitalizations and patients from Acute Hospital Care at Home programs, who are treated and billed as inpatients but receive care in their home.\n\nThis eCQM is an episode-based measure. An episode is defined as each inpatient hospitalization or encounter that ends during the measurement period.\n\nThis FHIR-based measure has been derived from the QDM-based measure: CMS104v12.\n \nPlease refer to the HL7 QI-Core Implementation Guide (http://hl7.org/fhir/us/qicore/index.html) for more information on QI-Core and mapping recommendations from QDM to QI-Core 4.1.1 (http://hl7.org/fhir/us/qicore/qdm-to-qicore.html).",
  "copyright" : "Measure specifications are in the Public Domain\n\nLOINC(R) copyright 2004-2022 Regenstrief Institute, Inc. This material contains SNOMED Clinical Terms(R) (SNOMED CT[R]) copyright 2004-2022 International Health Terminology Standards Development Organisation. ICD-10 copyright 2021 World Health Organization. All Rights Reserved.",
  "approvalDate" : "2023-08-01",
  "lastReviewDate" : "2023-08-01",
  "effectivePeriod" : {
    "start" : "2024-01-01",
    "end" : "2024-12-31"
  },
  "author" : [
    {
      "name" : "The Joint Commission",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.jointcommission.org/"
        }
      ]
    }
  ],
  "library" : [
    "http://somewhere.org/fhir/uv/mycontentig/Library/DischargedonAntithromboticTherapyFHIRExample"
  ],
  "disclaimer" : "These performance measures are not clinical guidelines and do not establish a standard of medical care, and have not been tested for all potential applications. The measures and specifications are provided without warranty.",
  "rationale" : "The effectiveness of antithrombotic agents in reducing stroke mortality, stroke-related morbidity and recurrence rates has been studied in several large clinical trials. While the use of these agents for patients with acute ischemic stroke and transient ischemic attacks continues to be the subject of study, substantial evidence is available from completed studies. Data at this time suggest that antithrombotic therapy should be prescribed at discharge following acute ischemic stroke to reduce stroke mortality and morbidity as long as no contraindications exist.\n\nor patients with a stroke due to a cardioembolic source (e.g. atrial fibrillation, mechanical heart valve), warfarin is recommended unless contraindicated. In recent years, novel oral anticoagulant agents (NOACs) have been developed and approved by the U.S. Food and Drug Administration (FDA) for stroke prevention, and may be considered as an alternative to warfarin for select patients. Anticoagulation therapy is not generally recommended for secondary stroke prevention in patients presumed to have a non-cardioembolic stroke.\nAnticoagulants at doses to prevent venous thromboembolism are insufficient antithrombotic therapy to prevent recurrent ischemic stroke or transient ischemic attack (TIA).",
  "clinicalRecommendationStatement" : "Clinical trial results suggest that antithrombotic therapy should be prescribed at discharge following acute ischemic stroke to reduce stroke mortality and morbidity as long as no contraindications exist",
  "group" : [
    {
      "id" : "64403d17d4d7050edabb0562",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-scoring",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/measure-scoring",
                "code" : "proportion",
                "display" : "Proportion"
              }
            ]
          }
        },
        {
          "url" : "http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-populationBasis",
          "valueCode" : "Encounter"
        },
        {
          "url" : "http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-type",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/measure-type",
                "code" : "process",
                "display" : "Process"
              }
            ]
          }
        }
      ],
      "population" : [
        {
          "id" : "937BAF2A-D36A-4EE5-B2B2-762A0FE04502",
          "code" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/measure-population",
                "code" : "initial-population",
                "display" : "Initial Population"
              }
            ]
          },
          "description" : "Inpatient hospitalizations for patients age 18 and older, discharged from inpatient care (non-elective admissions) with a principal diagnosis of ischemic or hemorrhagic stroke and a length of stay less than or equal to 120 days that ends during the measurement period",
          "criteria" : {
            "language" : "text/cql-identifier",
            "expression" : "Initial Population"
          }
        },
        {
          "id" : "302C1DCC-7FE6-41EF-A94E-FDAE24B7BB1B",
          "code" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/measure-population",
                "code" : "denominator",
                "display" : "Denominator"
              }
            ]
          },
          "description" : "Inpatient hospitalizations for patients with a principal diagnosis of Ischemic stroke",
          "criteria" : {
            "language" : "text/cql-identifier",
            "expression" : "Denominator"
          }
        },
        {
          "id" : "4B649804-9C55-4949-8CE0-01B462CAA74C",
          "code" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/measure-population",
                "code" : "denominator-exclusion",
                "display" : "Denominator Exclusion"
              }
            ]
          },
          "description" : "- Inpatient hospitalizations for patients admitted for elective carotid intervention. This exclusion is implicitly modeled by only including non-elective hospitalizations.\n- Inpatient hospitalizations for patients discharged to another hospital\n- Inpatient hospitalizations for patients who left against medical advice\n- Inpatient hospitalizations for patients who expired\n- Inpatient hospitalizations for patients discharged to home for hospice care\n- Inpatient hospitalizations for patients discharged to a health care facility for hospice care\n- Inpatient hospitalizations for patients with comfort measures documented",
          "criteria" : {
            "language" : "text/cql-identifier",
            "expression" : "Denominator Exclusions"
          }
        },
        {
          "id" : "516A3DD0-69B0-49EF-BBD3-12809CDC843E",
          "code" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/measure-population",
                "code" : "denominator-exception",
                "display" : "Denominator Exception"
              }
            ]
          },
          "description" : "- Inpatient hospitalizations for patients with a documented reason for not prescribing antithrombotic therapy at discharge.\n- Inpatient hospitalizations for patients who receive Prasugrel as an antithrombotic therapy at discharge.",
          "criteria" : {
            "language" : "text/cql-identifier",
            "expression" : "Denominator Exceptions"
          }
        },
        {
          "id" : "99961E3A-EFC4-4858-A3EE-F7F1D5B222FB",
          "code" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/measure-population",
                "code" : "numerator",
                "display" : "Numerator"
              }
            ]
          },
          "description" : "Inpatient hospitalizations for patients prescribed or continuing to take antithrombotic therapy at hospital discharge",
          "criteria" : {
            "language" : "text/cql-identifier",
            "expression" : "Numerator"
          }
        },
        {
          "id" : "5f33f3ea-6ffb-4897-85dd-872dd7ac55b8",
          "code" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/measure-population",
                "code" : "numerator-exclusion",
                "display" : "Numerator Exclusion"
              }
            ]
          },
          "criteria" : {
            "language" : "text/cql-identifier"
          }
        }
      ]
    }
  ],
  "supplementalData" : [
    {
      "id" : "sde-ethnicity",
      "usage" : [
        {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/measure-data-usage",
              "code" : "supplemental-data"
            }
          ]
        }
      ],
      "description" : "SDE Ethnicity",
      "criteria" : {
        "language" : "text/cql-identifier",
        "expression" : "SDE Ethnicity"
      }
    },
    {
      "id" : "sde-payer",
      "usage" : [
        {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/measure-data-usage",
              "code" : "supplemental-data"
            }
          ]
        }
      ],
      "description" : "SDE Payer",
      "criteria" : {
        "language" : "text/cql-identifier",
        "expression" : "SDE Payer"
      }
    },
    {
      "id" : "sde-race",
      "usage" : [
        {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/measure-data-usage",
              "code" : "supplemental-data"
            }
          ]
        }
      ],
      "description" : "SDE Race",
      "criteria" : {
        "language" : "text/cql-identifier",
        "expression" : "SDE Race"
      }
    },
    {
      "id" : "sde-sex",
      "usage" : [
        {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/measure-data-usage",
              "code" : "supplemental-data"
            }
          ]
        }
      ],
      "description" : "SDE Sex",
      "criteria" : {
        "language" : "text/cql-identifier",
        "expression" : "SDE Sex"
      }
    }
  ]
}

```
