# RetrieveExample - Your User Friendly Name for MyContentIG Here v0.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **RetrieveExample**

## Library: RetrieveExample 

| | |
| :--- | :--- |
| *Official URL*:http://somewhere.org/fhir/uv/mycontentig/Library/RetrieveExample | *Version*:0.5.3 |
| Draft as of 2025-12-10 | *Computable Name*:RetrieveExample |

* Metadata: Version
  * ?: 0.5.3
* Metadata: Status
  * ?: Draft
* Metadata: Jurisdiction
  * ?: 001 from[http://unstats.un.org/unsd/methods/m49/m49.htm](http://unstats.un.org/unsd/methods/m49/m49.htm)
* Metadata: Steward (Publisher)
  * ?: HL7 International - [Some] Work Group
* Metadata: Type
  * ?: logic-library from[http://terminology.hl7.org/CodeSystem/library-type](http://terminology.hl7.org/7.0.0/CodeSystem-library-type.html)
* Metadata: Dependency
  * ?: **Description**: Library FHIRHelpers**Resource**:`http://somewhere.org/fhir/uv/mycontentig/Library/FHIRHelpers|4.0.1`**Canonical URL**:http://somewhere.org/fhir/uv/mycontentig/Library/FHIRHelpers|4.0.1
* Metadata: Dependency
  * ?: **Description**: Code system LOINC**Resource**:[Logical Observation Identifiers, Names and Codes (LOINC)](http://terminology.hl7.org/5.2.0/CodeSystem-v3-loinc.html)**Canonical URL**:http://loinc.org
* Metadata: Dependency
  * ?: **Description**: Value set Lung Cancer**Resource**:[Lung Cancer](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1116.89/expansion)**Canonical URL**:http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1116.89
* Metadata: Dependency
  * ?: **Description**: Value set Condition Clinical Status**Resource**:`http://utah.edu/fhir/lcs-cds/ValueSet/conditionclinical`**Canonical URL**:http://utah.edu/fhir/lcs-cds/ValueSet/conditionclinical
* Metadata: Data Requirement
  * ?: **Type**: Patient**Profile(s)**:[Patient](http://hl7.org/fhir/R4/patient.html)
* Metadata: Data Requirement
  * ?: **Type**: Observation**Profile(s)**:[Observation](http://hl7.org/fhir/R4/observation.html)**Must Support Elements**: code, status**Code Filter(s)**:**Path**: code**Code(s)**:[LOINC: 72166-2](https://loinc.org/72166-2)(Tobacco smoking status)
* Metadata: Data Requirement
  * ?: **Type**: Condition**Profile(s)**:[Condition](http://hl7.org/fhir/R4/condition.html)**Must Support Elements**: code, clinicalStatus**Code Filter(s)**:**Path**: code**ValueSet**:[Lung Cancer](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1116.89/expansion)
* Metadata: Parameters
* Metadata: 
  * ?: 
| | | | | |
| :--- | :--- | :--- | :--- | :--- |
| **Name** | **Use** | **Card.** | **Type** | **Documentation** |
| Patient | Out | 0..1 | Patient |  |
| Smoking status observation | Out | 0..* | Observation |  |
| Lung cancer diagnosis | Out | 0..* | Condition |  |

* Metadata: Library Content
* Metadata: CQL Content
  * ?: ````library RetrieveExample version '0.5.3-cibuild' using FHIR version '4.0.1' include FHIRHelpers version '4.0.1' codesystem "LOINC": 'http://loinc.org' valueset "Lung Cancer": 'http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1116.89' valueset "Condition Clinical Status": 'http://utah.edu/fhir/lcs-cds/ValueSet/conditionclinical' code "Tobacco Smoking Status": '72166-2' from "LOINC" context Patient define "Smoking status observation": [Observation: "Tobacco Smoking Status"] O where O.status in { 'final', 'amended' } define "Lung cancer diagnosis": [Condition: "Lung Cancer"] C where C.clinicalStatus in "Condition Clinical Status"````
* Metadata: ELM XML Content
  * ?: ````Encoded data````
* Metadata: ELM JSON Content
  * ?: ````Encoded data````
* Metadata: Generated using version 0.5.3 of the sample-content-ig Liquid templates



## Resource Content

```json
{
  "resourceType" : "Library",
  "id" : "RetrieveExample",
  "contained" : [
    {
      "resourceType" : "Parameters",
      "id" : "options",
      "parameter" : [
        {
          "name" : "translatorVersion",
          "valueString" : "3.27.0"
        },
        {
          "name" : "option",
          "valueString" : "EnableAnnotations"
        },
        {
          "name" : "option",
          "valueString" : "EnableLocators"
        },
        {
          "name" : "option",
          "valueString" : "DisableListDemotion"
        },
        {
          "name" : "option",
          "valueString" : "DisableListPromotion"
        },
        {
          "name" : "format",
          "valueString" : "JSON"
        },
        {
          "name" : "format",
          "valueString" : "XML"
        },
        {
          "name" : "analyzeDataRequirements",
          "valueBoolean" : false
        },
        {
          "name" : "collapseDataRequirements",
          "valueBoolean" : true
        },
        {
          "name" : "compatibilityLevel",
          "valueString" : "1.5"
        },
        {
          "name" : "enableCqlOnly",
          "valueBoolean" : false
        },
        {
          "name" : "errorLevel",
          "valueString" : "Info"
        },
        {
          "name" : "signatureLevel",
          "valueString" : "Overloads"
        },
        {
          "name" : "validateUnits",
          "valueBoolean" : true
        },
        {
          "name" : "verifyOnly",
          "valueBoolean" : false
        }
      ]
    }
  ],
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-cqlOptions",
      "valueReference" : {
        "reference" : "#options"
      }
    }
  ],
  "url" : "http://somewhere.org/fhir/uv/mycontentig/Library/RetrieveExample",
  "version" : "0.5.3",
  "name" : "RetrieveExample",
  "status" : "draft",
  "type" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/library-type",
        "code" : "logic-library"
      }
    ]
  },
  "date" : "2025-12-10T03:14:19+00:00",
  "publisher" : "HL7 International - [Some] Work Group",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org/Special/committees/[something]"
        }
      ]
    }
  ],
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001"
        }
      ]
    }
  ],
  "relatedArtifact" : [
    {
      "type" : "depends-on",
      "display" : "Library FHIRHelpers",
      "resource" : "http://somewhere.org/fhir/uv/mycontentig/Library/FHIRHelpers|4.0.1"
    },
    {
      "type" : "depends-on",
      "display" : "Code system LOINC",
      "resource" : "http://loinc.org"
    },
    {
      "type" : "depends-on",
      "display" : "Value set Lung Cancer",
      "resource" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1116.89"
    },
    {
      "type" : "depends-on",
      "display" : "Value set Condition Clinical Status",
      "resource" : "http://utah.edu/fhir/lcs-cds/ValueSet/conditionclinical"
    }
  ],
  "parameter" : [
    {
      "name" : "Patient",
      "use" : "out",
      "min" : 0,
      "max" : "1",
      "type" : "Patient"
    },
    {
      "name" : "Smoking status observation",
      "use" : "out",
      "min" : 0,
      "max" : "*",
      "type" : "Observation"
    },
    {
      "name" : "Lung cancer diagnosis",
      "use" : "out",
      "min" : 0,
      "max" : "*",
      "type" : "Condition"
    }
  ],
  "dataRequirement" : [
    {
      "type" : "Patient",
      "profile" : ["http://hl7.org/fhir/StructureDefinition/Patient"]
    },
    {
      "type" : "Observation",
      "profile" : ["http://hl7.org/fhir/StructureDefinition/Observation"],
      "mustSupport" : ["code", "status"],
      "codeFilter" : [
        {
          "path" : "code",
          "code" : [
            {
              "system" : "http://loinc.org",
              "code" : "72166-2"
            }
          ]
        }
      ]
    },
    {
      "type" : "Condition",
      "profile" : ["http://hl7.org/fhir/StructureDefinition/Condition"],
      "mustSupport" : ["code", "clinicalStatus"],
      "codeFilter" : [
        {
          "path" : "code",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1116.89"
        }
      ]
    }
  ],
  "content" : [
    {
      "contentType" : "text/cql",
      "data" : "bGlicmFyeSBSZXRyaWV2ZUV4YW1wbGUgdmVyc2lvbiAnMC41LjMtY2lidWlsZCcNCg0KdXNpbmcgRkhJUiB2ZXJzaW9uICc0LjAuMScNCg0KaW5jbHVkZSBGSElSSGVscGVycyB2ZXJzaW9uICc0LjAuMScNCg0KY29kZXN5c3RlbSAiTE9JTkMiOiAnaHR0cDovL2xvaW5jLm9yZycNCg0KdmFsdWVzZXQgIkx1bmcgQ2FuY2VyIjogICdodHRwOi8vY3RzLm5sbS5uaWguZ292L2ZoaXIvVmFsdWVTZXQvMi4xNi44NDAuMS4xMTM3NjIuMS40LjExMTYuODknDQp2YWx1ZXNldCAiQ29uZGl0aW9uIENsaW5pY2FsIFN0YXR1cyI6ICdodHRwOi8vdXRhaC5lZHUvZmhpci9sY3MtY2RzL1ZhbHVlU2V0L2NvbmRpdGlvbmNsaW5pY2FsJw0KDQpjb2RlICJUb2JhY2NvIFNtb2tpbmcgU3RhdHVzIjogJzcyMTY2LTInIGZyb20gIkxPSU5DIg0KDQpjb250ZXh0IFBhdGllbnQNCg0KZGVmaW5lICJTbW9raW5nIHN0YXR1cyBvYnNlcnZhdGlvbiI6DQogIFtPYnNlcnZhdGlvbjogIlRvYmFjY28gU21va2luZyBTdGF0dXMiXSBPDQogICAgd2hlcmUgTy5zdGF0dXMgaW4geyAnZmluYWwnLCAnYW1lbmRlZCcgfQ0KDQpkZWZpbmUgIkx1bmcgY2FuY2VyIGRpYWdub3NpcyI6DQogIFtDb25kaXRpb246ICJMdW5nIENhbmNlciJdIEMNCiAgICB3aGVyZSBDLmNsaW5pY2FsU3RhdHVzIGluICJDb25kaXRpb24gQ2xpbmljYWwgU3RhdHVzIg0K",
      "url" : "http://somewhere.org/fhir/uv/mycontentig/RetrieveExample.cql"
    },
    {
      "contentType" : "application/elm+xml",
      "data" : "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"
    },
    {
      "contentType" : "application/elm+json",
      "data" : "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"
    }
  ]
}

```
